/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.pcc.strategy.partitioning;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.StateSpacePartition;
import org.sosy_lab.cpachecker.core.interfaces.StopOperator;
import org.sosy_lab.cpachecker.core.interfaces.TransferRelation;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.pcc.strategy.partitioning.PartitioningUtils;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.Pair;

public class CMCPartitionChecker {
    private Precision initPrec;
    private final StopOperator stopOp;
    private final TransferRelation transfer;
    private final ConfigurableProgramAnalysis cpa;
    private final AtomicBoolean checkResult;
    private final LogManager logger;
    private final ShutdownNotifier shutdown;
    private final ARGState root;
    private Map<AbstractState, ARGState> toARGState;
    private List<ARGState> incompleteStates;
    private Collection<AbstractState> inspectedStates;
    private Collection<AbstractState> externalNodes;
    private Multimap<CFANode, AbstractState> partitionNodes;

    public CMCPartitionChecker(ConfigurableProgramAnalysis pCpa, AtomicBoolean pCheckResult, ShutdownNotifier pShutdown, LogManager pLogger, AbstractState pRoot) throws InterruptedException {
        this.cpa = pCpa;
        this.stopOp = this.cpa.getStopOperator();
        this.transfer = this.cpa.getTransferRelation();
        this.checkResult = pCheckResult;
        this.logger = pLogger;
        this.shutdown = pShutdown;
        this.inspectedStates = new ArrayList<AbstractState>();
        this.incompleteStates = new ArrayList<ARGState>();
        this.toARGState = new HashMap<AbstractState, ARGState>();
        this.externalNodes = new ArrayList<AbstractState>();
        this.partitionNodes = HashMultimap.create();
        this.root = new ARGState(pRoot, null);
        this.toARGState.put(pRoot, this.root);
        this.externalNodes.add(pRoot);
        CFANode main = AbstractStates.extractLocation(pRoot);
        this.initPrec = this.cpa.getInitialPrecision(main, StateSpacePartition.getDefaultPartition());
    }

    public void checkPartition(AbstractState[] pPartitionNodes, AbstractState[] pExternalNodes, int[][] partitionEdgesAdjacencyList, int maxProofSize) throws InterruptedException {
        this.prepareCoverageInspectionOfExternalNodes(pPartitionNodes, pExternalNodes);
        Multimap<CFANode, AbstractState> statesPerLocation = this.computeMappingStatesToLocation(pPartitionNodes, pExternalNodes);
        try {
            for (int i = 0; i < pPartitionNodes.length; ++i) {
                this.shutdown.shutdownIfNecessary();
                if (!this.checkResult.get()) {
                    return;
                }
                if (this.moreThanMaxSizeInspected(maxProofSize)) {
                    this.logger.log(Level.SEVERE, new Object[]{"Checking failed, recomputed certificate bigger than original reached set."});
                    this.abortChecking();
                    return;
                }
                AbstractState current = pPartitionNodes[i];
                this.inspectedStates.add(current);
                int[] successorEdges = partitionEdgesAdjacencyList[i];
                if (successorEdges == null) {
                    this.checkSuccessorsStandard(this.transfer.getAbstractSuccessors(current, this.initPrec), statesPerLocation, maxProofSize);
                    continue;
                }
                if (this.toARGState.get(current) == null) {
                    this.toARGState.put(current, new ARGState(current, null));
                }
                if (successorEdges.length == 0) {
                    this.incompleteStates.add(this.toARGState.get(current));
                    continue;
                }
                this.checkSuccessorsInRecomputedARG(this.transfer.getAbstractSuccessors(current, this.initPrec), this.getARGSuccessors(successorEdges, pPartitionNodes, pExternalNodes), maxProofSize, this.toARGState.get(current));
            }
        }
        catch (CPATransferException e) {
            this.logger.log(Level.SEVERE, new Object[]{"Successor computation failed."});
            this.abortChecking();
        }
        catch (CPAException e) {
            this.logger.log(Level.SEVERE, new Object[]{"Coverage check of initial state or successor failed."});
            this.abortChecking();
        }
    }

    private Collection<AbstractState> getARGSuccessors(int[] pSuccessorEdges, AbstractState[] pPartitionNodes, AbstractState[] pExternalNodes) {
        ArrayList<AbstractState> result = new ArrayList<AbstractState>(pSuccessorEdges.length);
        for (int successor : pSuccessorEdges) {
            if (successor >= pPartitionNodes.length) {
                result.add(pExternalNodes[successor - pPartitionNodes.length]);
                continue;
            }
            result.add(pPartitionNodes[successor]);
        }
        return result;
    }

    protected void abortChecking() {
        this.checkResult.set(false);
    }

    private Multimap<CFANode, AbstractState> computeMappingStatesToLocation(AbstractState[] pPartitionNodes, AbstractState[] pExternalNodes) {
        HashMultimap result = HashMultimap.create();
        this.addStatesToMapping(pPartitionNodes, (Multimap<CFANode, AbstractState>)result);
        this.addStatesToMapping(pExternalNodes, (Multimap<CFANode, AbstractState>)result);
        return result;
    }

    private void addStatesToMapping(AbstractState[] stateSet, Multimap<CFANode, AbstractState> mapping) {
        for (AbstractState state : stateSet) {
            mapping.put((Object)AbstractStates.extractLocation(state), (Object)state);
        }
    }

    private boolean moreThanMaxSizeInspected(int maxSize) {
        return this.inspectedStates.size() > maxSize;
    }

    private void checkSuccessorsStandard(Collection<? extends AbstractState> pCollection, Multimap<CFANode, AbstractState> pStatesPerLocation, int maxSize) throws CPAException, InterruptedException {
        ArrayDeque<? extends AbstractState> successorsToInspect = new ArrayDeque<AbstractState>(pCollection);
        while (!successorsToInspect.isEmpty()) {
            this.shutdown.shutdownIfNecessary();
            AbstractState successor = (AbstractState)successorsToInspect.pop();
            if (this.stopOp.stop(successor, pStatesPerLocation.get((Object)AbstractStates.extractLocation(successor)), this.initPrec)) continue;
            this.inspectedStates.add(successor);
            if (this.moreThanMaxSizeInspected(maxSize)) {
                this.abortChecking();
                return;
            }
            successorsToInspect.addAll(this.transfer.getAbstractSuccessors(successor, this.initPrec));
        }
    }

    /*
     * WARNING - void declaration
     */
    private void checkSuccessorsInRecomputedARG(Collection<? extends AbstractState> pAbstractSuccessors, Collection<AbstractState> pArgSuccessors, int pMaxProofSize, ARGState predecessor) throws CPAException, InterruptedException {
        if (pAbstractSuccessors.size() != 1 || pArgSuccessors.size() > 1) {
            for (AbstractState abstractState : pAbstractSuccessors) {
                this.shutdown.shutdownIfNecessary();
                if (this.stopOp.stop(abstractState, pArgSuccessors, this.initPrec)) continue;
                this.logger.log(Level.SEVERE, new Object[]{"Successor not covered."});
                this.abortChecking();
                return;
            }
            for (AbstractState abstractState : pArgSuccessors) {
                this.shutdown.shutdownIfNecessary();
                this.addChild(predecessor, abstractState);
            }
        } else {
            void var6_11;
            ARGState currentPredecessor = predecessor;
            AbstractState abstractState = pAbstractSuccessors.iterator().next();
            while (!this.stopOp.stop((AbstractState)var6_11, pArgSuccessors, this.initPrec)) {
                this.shutdown.shutdownIfNecessary();
                this.addChild(currentPredecessor, (AbstractState)var6_11);
                currentPredecessor = this.toARGState.get(var6_11);
                this.inspectedStates.add((AbstractState)var6_11);
                if (this.moreThanMaxSizeInspected(pMaxProofSize)) {
                    this.abortChecking();
                    return;
                }
                Collection<? extends AbstractState> successors = this.transfer.getAbstractSuccessors((AbstractState)var6_11, this.initPrec);
                if (successors.size() > 1) {
                    this.logger.log(Level.SEVERE, new Object[]{"More than one successor cannot be recomputed if ARG is reconstructed."});
                    this.abortChecking();
                    return;
                }
                if (successors.isEmpty()) break;
                AbstractState abstractState2 = successors.iterator().next();
            }
            this.addChild(currentPredecessor, pArgSuccessors.iterator().next());
        }
    }

    private void addChild(ARGState parent, AbstractState child) {
        if (!this.toARGState.containsKey(child)) {
            this.toARGState.put(child, new ARGState(child, parent));
        } else {
            this.toARGState.get(child).addParent(parent);
        }
    }

    public Pair<ARGState, List<ARGState>> getAutomatonReconstructionInfo() {
        return Pair.of(this.root, this.incompleteStates);
    }

    public Collection<AbstractState> getInspectedStates() {
        return this.inspectedStates;
    }

    private void prepareCoverageInspectionOfExternalNodes(AbstractState[] pPartitionNodes, AbstractState[] pExternalNodes) {
        this.externalNodes.addAll(Arrays.asList(pExternalNodes));
        this.addStatesToMapping(pPartitionNodes, this.partitionNodes);
    }

    public boolean checkCoverageOfExternalsAndInitialState() throws CPAException, InterruptedException {
        return this.stopOp.stop(this.cpa.getInitialState(AbstractStates.extractLocation(this.root), StateSpacePartition.getDefaultPartition()), Collections.singleton(this.root.getWrappedState()), this.initPrec) && PartitioningUtils.areElementsCoveredByPartitionElement(this.externalNodes, this.partitionNodes, this.stopOp, this.initPrec);
    }
}

