/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.pcc.strategy.partitioning;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.pcc.strategy.AbstractStrategy;
import org.sosy_lab.cpachecker.pcc.strategy.partialcertificate.PartialReachedSetDirectedGraph;
import org.sosy_lab.cpachecker.pcc.strategy.partitioning.PartitioningIOHelper;
import org.sosy_lab.cpachecker.util.Pair;

public class CMCPartitioningIOHelper
extends PartitioningIOHelper {
    private List<int[][]> savedSuccessors;
    private AbstractState root;
    private final Set<ARGState> automatonStates;
    private final Set<ARGState> unexploredStates;

    public CMCPartitioningIOHelper(Configuration pConfig, LogManager pLogger, ShutdownNotifier pShutdownNotifier, Set<ARGState> pAutomatonStates, Set<ARGState> pUnexploredStates, @Nullable ARGState pRoot) throws InvalidConfigurationException {
        super(pConfig, pLogger, pShutdownNotifier, true);
        this.automatonStates = pAutomatonStates;
        this.unexploredStates = pUnexploredStates;
        if (pRoot != null) {
            this.root = pRoot.getWrappedState();
        }
    }

    public CMCPartitioningIOHelper(Configuration pConfig, LogManager pLogger, ShutdownNotifier pShutdownNotifier) throws InvalidConfigurationException {
        this(pConfig, pLogger, pShutdownNotifier, (Set<ARGState>)ImmutableSet.of(), (Set<ARGState>)ImmutableSet.of(), null);
    }

    public int @Nullable [][] getEdgesForPartition(int pIndex) {
        if (0 <= pIndex && pIndex < this.getNumPartitions() && pIndex < this.savedSuccessors.size()) {
            return this.savedSuccessors.get(pIndex);
        }
        return null;
    }

    @Override
    protected void saveInternalProof(int size, Pair<PartialReachedSetDirectedGraph, List<Set<Integer>>> pPartitionDescription) {
        super.saveInternalProof(size, pPartitionDescription);
        this.savedSuccessors = new ArrayList<int[][]>(pPartitionDescription.getSecond().size());
        int[] empty = new int[]{};
        for (int i = 0; i < this.savedSuccessors.size(); ++i) {
            Pair<AbstractState[], AbstractState[]> partition = this.getPartition(i);
            int[][] partitionSuccessors = new int[partition.getFirst().length][];
            this.savedSuccessors.add(partitionSuccessors);
            Iterator<Integer> partitionNodes = pPartitionDescription.getSecond().get(i).iterator();
            for (int j = 0; j < partitionSuccessors.length; ++j) {
                int nodeIndex = partitionNodes.next();
                ARGState node = (ARGState)pPartitionDescription.getFirst().getNode(nodeIndex);
                assert (node.getWrappedState() == partition.getFirst()[j]);
                if (!this.isAutomatonState(node)) continue;
                if (this.isUnexplored(node)) {
                    partitionSuccessors[j] = empty;
                    continue;
                }
                List successors = (List)pPartitionDescription.getFirst().getAdjacencyList().get(nodeIndex);
                partitionSuccessors[j] = new int[successors.size()];
                for (int k = 0; k < partitionSuccessors[j].length; ++k) {
                    partitionSuccessors[j][k] = this.findSuccessorIndex(((ARGState)pPartitionDescription.getFirst().getNode((Integer)successors.get(k))).getWrappedState(), partition.getFirst(), partition.getSecond());
                }
            }
        }
    }

    @Override
    public void writePartition(ObjectOutputStream pOut, Set<Integer> pPartition, PartialReachedSetDirectedGraph pPartialReachedSetDirectedGraph) throws IOException {
        super.writePartition(pOut, pPartition, pPartialReachedSetDirectedGraph);
        AbstractState[] partitionNodes = pPartialReachedSetDirectedGraph.getSetNodes(pPartition, true);
        AbstractState[] externalNodes = pPartialReachedSetDirectedGraph.getSuccessorNodesOutsideSet(pPartition, true);
        int[][] successorLinks = new int[pPartition.size()][];
        int count = 0;
        int[] empty = new int[]{};
        for (Integer partitionNode : pPartition) {
            ARGState node = (ARGState)pPartialReachedSetDirectedGraph.getNode(partitionNode);
            if (this.isAutomatonState(node)) {
                if (this.isUnexplored(node)) {
                    successorLinks[count] = empty;
                } else {
                    List successors = (List)pPartialReachedSetDirectedGraph.getAdjacencyList().get(partitionNode.intValue());
                    successorLinks[count] = new int[successors.size()];
                    for (int i = 0; i < successorLinks[count].length; ++i) {
                        successorLinks[count][i] = this.findSuccessorIndex(pPartialReachedSetDirectedGraph.getNode((Integer)successors.get(i)), partitionNodes, externalNodes);
                        Preconditions.checkState((successorLinks[count][i] != -1 ? 1 : 0) != 0);
                    }
                }
            }
            ++count;
        }
        pOut.writeObject(successorLinks);
    }

    private int findSuccessorIndex(AbstractState pNode, AbstractState[] pPartitionNodes, AbstractState[] pExternalNodes) {
        int i;
        for (i = 0; i < pPartitionNodes.length; ++i) {
            if (pNode != pPartitionNodes[i]) continue;
            return i;
        }
        for (i = 0; i < pExternalNodes.length; ++i) {
            if (pNode != pPartitionNodes[i]) continue;
            return pPartitionNodes.length + i;
        }
        return -1;
    }

    private boolean isUnexplored(ARGState pNode) {
        return this.unexploredStates.contains(pNode);
    }

    private boolean isAutomatonState(ARGState node) {
        return this.automatonStates.contains(node);
    }

    @Override
    public void readPartition(ObjectInputStream pIn, AbstractStrategy.PCStrategyStatistics pStats) throws ClassNotFoundException, IOException {
        super.readPartition(pIn, pStats);
        this.savedSuccessors.add((int[][])pIn.readObject());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readPartition(ObjectInputStream pIn, AbstractStrategy.PCStrategyStatistics pStats, Lock pLock) throws ClassNotFoundException, IOException {
        Preconditions.checkArgument((pLock != null ? 1 : 0) != 0, (Object)"Cannot protect against parallel access");
        pLock.lock();
        try {
            this.readPartition(pIn, pStats);
        }
        finally {
            pLock.unlock();
        }
    }

    @Override
    public void writeMetadata(ObjectOutputStream pOut, int pReachedSetSize, int pNumPartitions) throws IOException {
        super.writeMetadata(pOut, pReachedSetSize, pNumPartitions);
        pOut.writeObject(this.root);
    }

    @Override
    public void readMetadata(ObjectInputStream pIn, boolean pSave) throws IOException {
        super.readMetadata(pIn, pSave);
        if (pSave) {
            this.savedSuccessors = new ArrayList<int[][]>(this.getNumPartitions());
            try {
                this.root = (AbstractState)pIn.readObject();
            }
            catch (ClassNotFoundException e) {
                this.root = null;
            }
        } else {
            try {
                pIn.readObject();
            }
            catch (ClassNotFoundException e) {
                throw new AssertionError((Object)e);
            }
        }
    }

    public @Nullable AbstractState getRoot() {
        return this.root;
    }
}

