/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.pcc.strategy.partitioning;

import org.sosy_lab.cpachecker.core.interfaces.pcc.FiducciaMattheysesOptimizer;
import org.sosy_lab.cpachecker.pcc.strategy.partialcertificate.WeightedEdge;
import org.sosy_lab.cpachecker.pcc.strategy.partialcertificate.WeightedGraph;

public class EdgeCutOptimizer
implements FiducciaMattheysesOptimizer {
    @Override
    public int computeGain(int node, int toPartition, int[] nodeToPartition, WeightedGraph wGraph) {
        int gain = this.computeExternalDegree(node, toPartition, nodeToPartition, wGraph) - this.computeInternalDegree(node, nodeToPartition, wGraph);
        return gain;
    }

    @Override
    public int computeInternalDegree(int node, int[] nodeToPartition, WeightedGraph wGraph) {
        int internalDegree = 0;
        int partition = nodeToPartition[node];
        for (WeightedEdge outEdge : wGraph.getOutgoingEdges(node)) {
            if (nodeToPartition[outEdge.getEndNode().getNodeNumber()] != partition) continue;
            internalDegree += outEdge.getWeight();
        }
        for (WeightedEdge inEdge : wGraph.getIncomingEdges(node)) {
            if (nodeToPartition[inEdge.getStartNode().getNodeNumber()] != partition) continue;
            internalDegree += inEdge.getWeight();
        }
        return internalDegree;
    }

    @Override
    public int computeExternalDegree(int node, int toPartition, int[] nodeToPartition, WeightedGraph wGraph) {
        int externalDegree = 0;
        for (WeightedEdge outEdge : wGraph.getOutgoingEdges(node)) {
            if (nodeToPartition[outEdge.getEndNode().getNodeNumber()] != toPartition) continue;
            externalDegree += outEdge.getWeight();
        }
        for (WeightedEdge inEdge : wGraph.getIncomingEdges(node)) {
            if (nodeToPartition[inEdge.getStartNode().getNodeNumber()] != toPartition) continue;
            externalDegree += inEdge.getWeight();
        }
        return externalDegree;
    }
}

