/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.pcc.strategy.partitioning;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Set;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.cpachecker.core.interfaces.pcc.BalancedGraphPartitioner;
import org.sosy_lab.cpachecker.pcc.strategy.partialcertificate.PartialReachedSetDirectedGraph;

public class ExplorationOrderBalancedGraphPartitioner
implements BalancedGraphPartitioner {
    private final ShutdownNotifier shutdownNotifier;
    private final boolean useDFS;

    public ExplorationOrderBalancedGraphPartitioner(boolean pDFS, ShutdownNotifier pShutdownNotifier) {
        this.useDFS = pDFS;
        this.shutdownNotifier = pShutdownNotifier;
    }

    @Override
    public List<Set<Integer>> computePartitioning(int pNumPartitions, PartialReachedSetDirectedGraph pGraph) throws InterruptedException {
        ArrayDeque<Integer> waitlist = new ArrayDeque<Integer>();
        BitSet inPartition = new BitSet(pGraph.getNumNodes());
        int partitionSize = pGraph.getNumNodes() / pNumPartitions + 1;
        ArrayList<Set<Integer>> result = new ArrayList<Set<Integer>>(pNumPartitions);
        for (int i = 0; i < pNumPartitions; ++i) {
            result.add(Sets.newHashSetWithExpectedSize((int)partitionSize));
        }
        waitlist.add(0);
        inPartition.set(0);
        int partition = 0;
        ImmutableList<ImmutableList<Integer>> adjacencyList = pGraph.getAdjacencyList();
        while (!waitlist.isEmpty()) {
            this.shutdownNotifier.shutdownIfNecessary();
            Integer next = (Integer)waitlist.poll();
            if (((Set)result.get(partition)).size() > partitionSize) {
                ++partition;
            }
            ((Set)result.get(partition)).add(next);
            for (Integer successor : (ImmutableList)adjacencyList.get(next.intValue())) {
                if (inPartition.get(successor)) continue;
                inPartition.set(successor);
                if (this.useDFS) {
                    waitlist.push(successor);
                    continue;
                }
                waitlist.offer(successor);
            }
        }
        return result;
    }
}

