/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.pcc.strategy.partitioning;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.cpachecker.core.interfaces.pcc.BalancedGraphPartitioner;
import org.sosy_lab.cpachecker.pcc.strategy.partialcertificate.PartialReachedSetDirectedGraph;

public class ExponentialOptimalBalancedGraphPartitioner
implements BalancedGraphPartitioner {
    private final ShutdownNotifier shutdown;

    public ExponentialOptimalBalancedGraphPartitioner(ShutdownNotifier pShutdownNotifier) {
        this.shutdown = pShutdownNotifier;
    }

    @Override
    public List<Set<Integer>> computePartitioning(int pNumPartitions, PartialReachedSetDirectedGraph pGraph) throws InterruptedException {
        List<Integer> permutationIndices = this.initPermutationIndices(pGraph.getNumNodes());
        List<Set<Integer>> bestPartitioning = this.computePermutation(permutationIndices, pNumPartitions);
        long minNumCrossingEdges = this.getNumberOfPartitionCrossingEdges(pGraph, bestPartitioning);
        while (this.hasNextPermutation(permutationIndices)) {
            this.shutdown.shutdownIfNecessary();
            List<Set<Integer>> currentPartitioning = this.computeNextPermutation(permutationIndices, pNumPartitions);
            long currentNumCrossingEdges = this.getNumberOfPartitionCrossingEdges(pGraph, currentPartitioning);
            if (minNumCrossingEdges < currentNumCrossingEdges && minNumCrossingEdges != -1L) continue;
            bestPartitioning = currentPartitioning;
        }
        return bestPartitioning;
    }

    private List<Integer> initPermutationIndices(int pNumIndices) {
        ArrayList<Integer> permutationIndices = new ArrayList<Integer>(pNumIndices);
        for (int i = 0; i < pNumIndices; ++i) {
            permutationIndices.add(0);
        }
        return permutationIndices;
    }

    private List<Set<Integer>> initPartition(int pNumPartitions, int maxSize) {
        ArrayList<Set<Integer>> result = new ArrayList<Set<Integer>>(pNumPartitions);
        for (int i = 0; i < pNumPartitions; ++i) {
            result.add(i, new HashSet(maxSize));
        }
        return result;
    }

    private List<Set<Integer>> computePermutation(List<Integer> pPermutationIndices, int pNumPartitions) {
        int j;
        Set<Integer> currentPartition;
        int i;
        ArrayList<Integer> orderedNodes = new ArrayList<Integer>();
        for (int j2 = pPermutationIndices.size() - 1; j2 >= 0; --j2) {
            orderedNodes.add(pPermutationIndices.get(j2), j2);
        }
        int maxSize = (int)Math.ceil((double)pPermutationIndices.size() / (double)pNumPartitions);
        int numSmaller = maxSize * pNumPartitions - pPermutationIndices.size();
        List<Set<Integer>> result = this.initPartition(pNumPartitions, maxSize);
        for (i = 0; i < numSmaller; ++i) {
            currentPartition = result.get(i);
            for (j = i * (maxSize - 1); j < (i + 1) * (maxSize - 1); ++j) {
                currentPartition.add((Integer)orderedNodes.get(j));
            }
        }
        for (i = 0; i < pNumPartitions - numSmaller; ++i) {
            currentPartition = result.get(i);
            for (j = i * maxSize + numSmaller * (maxSize - 1); j < (i + 1) * maxSize + numSmaller * (maxSize - 1); ++j) {
                currentPartition.add((Integer)orderedNodes.get(j));
            }
        }
        return result;
    }

    private boolean hasNextPermutation(List<Integer> pPermutationIndices) {
        int i = 0;
        int j = pPermutationIndices.size() - 1;
        while (i < pPermutationIndices.size()) {
            if (pPermutationIndices.get(i) < j) {
                return true;
            }
            ++i;
            --j;
        }
        return false;
    }

    private List<Set<Integer>> computeNextPermutation(List<Integer> pPermutationIndices, int pNumPartitions) {
        int j = pPermutationIndices.size() - 1;
        int i = 0;
        while (j >= 0) {
            if (pPermutationIndices.get(j) < i) {
                pPermutationIndices.set(j, pPermutationIndices.get(j) + 1);
                break;
            }
            pPermutationIndices.set(j, 0);
            --j;
            ++i;
        }
        return this.computePermutation(pPermutationIndices, pNumPartitions);
    }

    private long getNumberOfPartitionCrossingEdges(PartialReachedSetDirectedGraph pGraph, List<Set<Integer>> partitioning) {
        long result = 0L;
        for (Set<Integer> partition : partitioning) {
            result += pGraph.getNumSuccessorNodesOutsideSet(partition);
        }
        return result;
    }
}

