/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.pcc.strategy.partitioning;

import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.core.interfaces.pcc.BalancedGraphPartitioner;
import org.sosy_lab.cpachecker.pcc.strategy.partialcertificate.PartialReachedSetDirectedGraph;
import org.sosy_lab.cpachecker.pcc.strategy.partitioning.FiducciaMattheysesAlgorithm;
import org.sosy_lab.cpachecker.pcc.strategy.partitioning.RandomBalancedGraphPartitioner;

@Options(prefix="pcc.partitioning.fm")
public class FiducciaMattheysesBalancedGraphPartitioner
implements BalancedGraphPartitioner {
    private final ShutdownNotifier shutdownNotifier;
    private final LogManager logger;
    @Option(secure=true, description="Heuristic for computing an initial partitioning of proof")
    private InitPartitioningHeuristics initialPartitioningStrategy = InitPartitioningHeuristics.RANDOM;
    @Option(secure=true, description="Balance criterion for pairwise optimization of partitions")
    private double balanceCriterion = 1.5;
    private final BalancedGraphPartitioner partitioner;

    public FiducciaMattheysesBalancedGraphPartitioner(Configuration pConfig, LogManager pLogger, ShutdownNotifier pShutdownNotifier) throws InvalidConfigurationException {
        pConfig.inject((Object)this);
        this.shutdownNotifier = pShutdownNotifier;
        this.logger = pLogger;
        switch (this.initialPartitioningStrategy) {
            default: 
        }
        this.partitioner = new RandomBalancedGraphPartitioner();
    }

    @Override
    public List<Set<Integer>> computePartitioning(int pNumPartitions, PartialReachedSetDirectedGraph pGraph) throws InterruptedException {
        List<Set<Integer>> partition = this.partitioner.computePartitioning(pNumPartitions, pGraph);
        long cutSizeAfter = 0L;
        for (Set<Integer> v1 : partition) {
            for (Set<Integer> v2 : partition) {
                long gain;
                if (v1 == v2) break;
                this.shutdownNotifier.shutdownIfNecessary();
                FiducciaMattheysesAlgorithm fm = new FiducciaMattheysesAlgorithm(this.balanceCriterion, v1, v2, pGraph);
                do {
                    this.shutdownNotifier.shutdownIfNecessary();
                } while ((gain = fm.improvePartitioning()) > 0L);
                cutSizeAfter += pGraph.getNumEdgesBetween(v1, v2);
            }
        }
        this.logger.log(Level.FINE, new Object[]{String.format("[FM] Computed partitioning of cut size %d", cutSizeAfter)});
        return partition;
    }

    public static enum InitPartitioningHeuristics {
        RANDOM;

    }
}

