/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.pcc.strategy.partitioning;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.core.interfaces.pcc.PartitioningRefiner;
import org.sosy_lab.cpachecker.core.interfaces.pcc.WeightedBalancedGraphPartitioner;
import org.sosy_lab.cpachecker.pcc.strategy.partialcertificate.PartialReachedSetDirectedGraph;
import org.sosy_lab.cpachecker.pcc.strategy.partialcertificate.WeightedGraph;
import org.sosy_lab.cpachecker.pcc.strategy.partitioning.FiducciaMattheysesOptimzerFactory;
import org.sosy_lab.cpachecker.pcc.strategy.partitioning.FiducciaMattheysesWeightedKWayAlgorithm;
import org.sosy_lab.cpachecker.pcc.strategy.partitioning.GlobalGraphPartitionerHeuristicFactory;

@Options(prefix="pcc.partitioning.kwayfm")
public class FiducciaMattheysesKWayBalancedGraphPartitioner
implements WeightedBalancedGraphPartitioner,
PartitioningRefiner {
    private final LogManager logger;
    private final WeightedBalancedGraphPartitioner globalPartitioner;
    @Option(secure=true, description="[FM-k-way] Balance criterion for pairwise optimization of partitions")
    private double balancePrecision = 1.3;
    @Option(secure=true, description="[FM-k-way] Partitioning method to compute initial partitioning.")
    private GlobalGraphPartitionerHeuristicFactory.GlobalPartitioningHeuristics globalHeuristic = GlobalGraphPartitionerHeuristicFactory.GlobalPartitioningHeuristics.BEST_IMPROVEMENT_FIRST;
    @Option(secure=true, description="[FM-k-way] Local optimization criterion to be minimized druing Fiduccia/Mattheyses refinment")
    private FiducciaMattheysesOptimzerFactory.OptimizationCriteria optimizationCriterion = FiducciaMattheysesOptimzerFactory.OptimizationCriteria.NODECUT;

    public FiducciaMattheysesKWayBalancedGraphPartitioner(Configuration pConfig, LogManager pLogger) throws InvalidConfigurationException {
        pConfig.inject((Object)this);
        this.logger = pLogger;
        this.globalPartitioner = GlobalGraphPartitionerHeuristicFactory.createPartitioner(pConfig, pLogger, this.globalHeuristic);
    }

    public FiducciaMattheysesKWayBalancedGraphPartitioner(Configuration pConfig, LogManager pLogger, FiducciaMattheysesOptimzerFactory.OptimizationCriteria criterion) throws InvalidConfigurationException {
        pConfig.inject((Object)this);
        this.logger = pLogger;
        this.optimizationCriterion = criterion;
        this.globalPartitioner = GlobalGraphPartitionerHeuristicFactory.createPartitioner(pConfig, pLogger, this.globalHeuristic);
    }

    @Override
    public List<Set<Integer>> computePartitioning(int pNumPartitions, PartialReachedSetDirectedGraph pGraph) throws InterruptedException {
        return this.computePartitioning(pNumPartitions, new WeightedGraph(pGraph));
    }

    @Override
    public List<Set<Integer>> computePartitioning(int pNumPartitions, WeightedGraph wGraph) throws InterruptedException {
        Preconditions.checkArgument((pNumPartitions > 0 && wGraph != null ? 1 : 0) != 0, (Object)"Partitioniong must contain at most 1 partition. Graph may not be null.");
        if (pNumPartitions == 1) {
            return wGraph.getGraphAsOnePartition();
        }
        if (pNumPartitions >= wGraph.getNumNodes()) {
            return wGraph.getNodesSeperatelyPartitioned(pNumPartitions);
        }
        List<Set<Integer>> partitioning = this.globalPartitioner.computePartitioning(pNumPartitions, wGraph);
        this.refinePartitioning(partitioning, wGraph, pNumPartitions);
        this.removeEmptyPartitions(partitioning);
        return partitioning;
    }

    private void removeEmptyPartitions(List<Set<Integer>> partitions) {
        partitions.removeIf(partition -> partition != null && partition.isEmpty());
    }

    @Override
    public int refinePartitioning(List<Set<Integer>> partitioning, PartialReachedSetDirectedGraph pGraph, int numPartitions) {
        WeightedGraph wGraph = new WeightedGraph(pGraph);
        return this.refinePartitioning(partitioning, wGraph, numPartitions);
    }

    @Override
    public int refinePartitioning(List<Set<Integer>> partitioning, WeightedGraph wGraph, int numPartitions) {
        int step;
        int maxLoad = wGraph.computePartitionLoad(numPartitions);
        FiducciaMattheysesWeightedKWayAlgorithm fm = new FiducciaMattheysesWeightedKWayAlgorithm(partitioning, this.balancePrecision, wGraph, maxLoad, this.optimizationCriterion);
        int maxNumSteps = 50;
        int oldGain = 0;
        int totalGain = 0;
        int timesWithoutImprovement = 0;
        for (step = 1; step <= maxNumSteps && timesWithoutImprovement < 5; ++step) {
            int newGain = fm.refinePartitioning();
            totalGain += newGain;
            if (oldGain == newGain) {
                ++timesWithoutImprovement;
            }
            oldGain = newGain;
        }
        this.logger.log(Level.FINE, new Object[]{String.format("[KWayFM] refinement gain %d after % d refinement steps", totalGain, step)});
        return totalGain;
    }
}

