/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.pcc.strategy.partitioning;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.sosy_lab.cpachecker.core.interfaces.pcc.FiducciaMattheysesOptimizer;
import org.sosy_lab.cpachecker.pcc.strategy.partialcertificate.WeightedGraph;
import org.sosy_lab.cpachecker.pcc.strategy.partialcertificate.WeightedNode;
import org.sosy_lab.cpachecker.pcc.strategy.partitioning.FiducciaMattheysesOptimzerFactory;

public class FiducciaMattheysesWeightedKWayAlgorithm {
    private final double balanceCriterion;
    private final int maxLoad;
    private final WeightedGraph wGraph;
    private List<Set<Integer>> actualPartitioning;
    private int[] partitionWeights;
    private int[] nodeToPartition;
    private final FiducciaMattheysesOptimizer optimizer;

    public FiducciaMattheysesWeightedKWayAlgorithm(List<Set<Integer>> pInitPartitioning, double pBalanceCriterion, WeightedGraph pWGraph, int pMaxLoad, FiducciaMattheysesOptimzerFactory.OptimizationCriteria opt) {
        this.optimizer = FiducciaMattheysesOptimzerFactory.createFMOptimizer(opt);
        this.balanceCriterion = pBalanceCriterion;
        this.wGraph = pWGraph;
        this.actualPartitioning = pInitPartitioning;
        this.maxLoad = pMaxLoad;
        this.initializePartitionStructures();
    }

    private void initializePartitionStructures() {
        int numNodes = this.wGraph.getNumNodes();
        int numPartitions = this.actualPartitioning.size();
        this.partitionWeights = new int[numPartitions];
        this.nodeToPartition = new int[numNodes];
        for (int partition = 0; partition < numPartitions; ++partition) {
            for (Integer node : this.actualPartitioning.get(partition)) {
                int nodeWeight = this.wGraph.getNode(node).getWeight();
                this.nodeToPartition[node.intValue()] = partition;
                int n = partition;
                this.partitionWeights[n] = this.partitionWeights[n] + nodeWeight;
            }
        }
    }

    private int getPartition(int node) {
        return this.nodeToPartition[node];
    }

    public int refinePartitioning() {
        int totalGain = 0;
        for (WeightedNode node : this.wGraph.randomIterator()) {
            int nodeNum = node.getNodeNumber();
            int maxGain = 0;
            int from = this.getPartition(nodeNum);
            int maxUnbalancing = node.getWeight();
            int to = from;
            for (Integer toPartition : this.getSuccessorPartitions(nodeNum)) {
                int unbalancing;
                if (!this.isNodeMovable(nodeNum, from, toPartition)) continue;
                int gain = this.optimizer.computeGain(nodeNum, toPartition, this.nodeToPartition, this.wGraph);
                if (gain > maxGain) {
                    maxGain = gain;
                    to = toPartition;
                    continue;
                }
                if (maxGain > 0 || gain != 0 || (unbalancing = this.partitionWeights[from] - this.partitionWeights[to]) <= maxUnbalancing) continue;
                maxUnbalancing = unbalancing;
                to = toPartition;
            }
            this.moveNode(nodeNum, from, to);
            totalGain += maxGain;
        }
        return totalGain;
    }

    private Set<Integer> getSuccessorPartitions(int node) {
        HashSet<Integer> succPartitions = new HashSet<Integer>(this.wGraph.getSuccessors(node).size());
        for (Integer succ : this.wGraph.getIntSuccessors(node)) {
            succPartitions.add(this.getPartition(succ));
        }
        return succPartitions;
    }

    private boolean isNodeMovable(int node, int fromPartition, int toPartition) {
        int partWeight = this.partitionWeights[toPartition];
        int nodeWeight = this.wGraph.getNode(node).getWeight();
        if ((double)(partWeight + nodeWeight) > this.balanceCriterion * (double)this.maxLoad) {
            return false;
        }
        return fromPartition != toPartition;
    }

    private boolean moveNode(int node, int fromPartition, int toPartition) {
        if (!this.isNodeMovable(node, fromPartition, toPartition)) {
            return false;
        }
        int nodeWeight = this.wGraph.getNode(node).getWeight();
        int n = fromPartition;
        this.partitionWeights[n] = this.partitionWeights[n] - nodeWeight;
        int n2 = toPartition;
        this.partitionWeights[n2] = this.partitionWeights[n2] + nodeWeight;
        this.nodeToPartition[node] = toPartition;
        this.actualPartitioning.get(fromPartition).remove(node);
        this.actualPartitioning.get(toPartition).add(node);
        return true;
    }
}

