/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.pcc.strategy.partitioning;

import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.core.interfaces.pcc.WeightedBalancedGraphPartitioner;
import org.sosy_lab.cpachecker.pcc.strategy.partitioning.BestFirstEvaluationFunctionFactory;
import org.sosy_lab.cpachecker.pcc.strategy.partitioning.BestFirstWeightedBalancedGraphPartitioner;
import org.sosy_lab.cpachecker.pcc.strategy.partitioning.RandomBalancedWeightedGraphPartitioner;

public class GlobalGraphPartitionerHeuristicFactory {
    private GlobalGraphPartitionerHeuristicFactory() {
    }

    public static WeightedBalancedGraphPartitioner createPartitioner(Configuration pConfig, LogManager pLogger, GlobalPartitioningHeuristics pHeuristic) throws InvalidConfigurationException {
        switch (pHeuristic) {
            case RANDOM: {
                return new RandomBalancedWeightedGraphPartitioner();
            }
            case DFS: {
                return new BestFirstWeightedBalancedGraphPartitioner(pConfig, pLogger, BestFirstEvaluationFunctionFactory.BestFirstEvaluationFunctions.DEPTH_FIRST);
            }
            case BFS: {
                return new BestFirstWeightedBalancedGraphPartitioner(pConfig, pLogger, BestFirstEvaluationFunctionFactory.BestFirstEvaluationFunctions.BREADTH_FIRST);
            }
        }
        return new BestFirstWeightedBalancedGraphPartitioner(pConfig, pLogger);
    }

    public static enum GlobalPartitioningHeuristics {
        RANDOM,
        DFS,
        BFS,
        BEST_IMPROVEMENT_FIRST;

    }
}

