/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.pcc.strategy.partitioning;

import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.core.interfaces.pcc.BalancedGraphPartitioner;
import org.sosy_lab.cpachecker.pcc.strategy.partitioning.BestFirstWeightedBalancedGraphPartitioner;
import org.sosy_lab.cpachecker.pcc.strategy.partitioning.ExplorationOrderBalancedGraphPartitioner;
import org.sosy_lab.cpachecker.pcc.strategy.partitioning.ExponentialOptimalBalancedGraphPartitioner;
import org.sosy_lab.cpachecker.pcc.strategy.partitioning.FiducciaMattheysesBalancedGraphPartitioner;
import org.sosy_lab.cpachecker.pcc.strategy.partitioning.FiducciaMattheysesKWayBalancedGraphPartitioner;
import org.sosy_lab.cpachecker.pcc.strategy.partitioning.MultilevelBalancedGraphPartitioner;
import org.sosy_lab.cpachecker.pcc.strategy.partitioning.RandomBalancedGraphPartitioner;

public class GraphPartitionerFactory {
    private GraphPartitionerFactory() {
    }

    public static BalancedGraphPartitioner createPartitioner(LogManager pLogger, PartitioningHeuristics pHeuristic, ShutdownNotifier pShutdownNotifier, Configuration pConfig) throws InvalidConfigurationException {
        switch (pHeuristic) {
            case DFS: {
                return new ExplorationOrderBalancedGraphPartitioner(true, pShutdownNotifier);
            }
            case BFS: {
                return new ExplorationOrderBalancedGraphPartitioner(false, pShutdownNotifier);
            }
            case OPTIMAL: {
                return new ExponentialOptimalBalancedGraphPartitioner(pShutdownNotifier);
            }
            case BEST_FIRST: {
                return new BestFirstWeightedBalancedGraphPartitioner(pConfig, pLogger);
            }
            case FM: {
                return new FiducciaMattheysesBalancedGraphPartitioner(pConfig, pLogger, pShutdownNotifier);
            }
            case FM_K_WAY: {
                return new FiducciaMattheysesKWayBalancedGraphPartitioner(pConfig, pLogger);
            }
            case MULTILEVEL: {
                return new MultilevelBalancedGraphPartitioner(pConfig, pLogger);
            }
        }
        return new RandomBalancedGraphPartitioner();
    }

    public static enum PartitioningHeuristics {
        RANDOM,
        DFS,
        BFS,
        OPTIMAL,
        BEST_FIRST,
        FM,
        FM_K_WAY,
        MULTILEVEL;

    }
}

