/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.pcc.strategy.partitioning;

import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.core.interfaces.pcc.MatchingGenerator;
import org.sosy_lab.cpachecker.pcc.strategy.partialcertificate.WeightedEdge;
import org.sosy_lab.cpachecker.pcc.strategy.partialcertificate.WeightedGraph;
import org.sosy_lab.cpachecker.pcc.strategy.partialcertificate.WeightedNode;

public class HeavyEdgeMatchingGenerator
implements MatchingGenerator {
    private final LogManager logger;

    public HeavyEdgeMatchingGenerator(LogManager pLogger) {
        this.logger = pLogger;
    }

    @Override
    public Map<Integer, Integer> computeMatching(WeightedGraph wGraph) {
        HashMap<Integer, Integer> matching = new HashMap<Integer, Integer>(wGraph.getNumNodes() / 2);
        BitSet alreadyMatched = new BitSet(wGraph.getNumNodes());
        int currentSuperNode = 0;
        for (WeightedNode node : wGraph.randomIterator()) {
            int nodeNum = node.getNodeNumber();
            if (alreadyMatched.get(nodeNum)) continue;
            int maxWeight = -1;
            int maxNeighbor = -1;
            for (WeightedEdge succEdge : wGraph.getOutgoingEdges(node)) {
                WeightedNode succ = succEdge.getEndNode();
                int succNum = succ.getNodeNumber();
                if (alreadyMatched.get(succNum) || succEdge.getWeight() <= maxWeight) continue;
                maxWeight = succEdge.getWeight();
                maxNeighbor = succNum;
            }
            if (maxNeighbor > -1) {
                matching.put(nodeNum, currentSuperNode);
                matching.put(maxNeighbor, currentSuperNode);
                alreadyMatched.set(nodeNum);
                alreadyMatched.set(maxNeighbor);
                this.logger.log(Level.FINE, new Object[]{String.format("[Multilevel] Node %d and %d matched to supernode %d- matched heaviest edge weight %d", nodeNum, maxNeighbor, currentSuperNode, maxWeight)});
            } else {
                matching.put(nodeNum, currentSuperNode);
                alreadyMatched.set(nodeNum);
                this.logger.log(Level.FINE, new Object[]{String.format("[Multilevel] Node %d lonely: Supernode %d", nodeNum, currentSuperNode)});
            }
            ++currentSuperNode;
        }
        return matching;
    }
}

