/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.pcc.strategy.partitioning;

import com.google.common.base.Preconditions;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.core.interfaces.pcc.MatchingGenerator;
import org.sosy_lab.cpachecker.core.interfaces.pcc.PartitioningRefiner;
import org.sosy_lab.cpachecker.core.interfaces.pcc.WeightedBalancedGraphPartitioner;
import org.sosy_lab.cpachecker.pcc.strategy.partialcertificate.PartialReachedSetDirectedGraph;
import org.sosy_lab.cpachecker.pcc.strategy.partialcertificate.WeightedEdge;
import org.sosy_lab.cpachecker.pcc.strategy.partialcertificate.WeightedGraph;
import org.sosy_lab.cpachecker.pcc.strategy.partialcertificate.WeightedNode;
import org.sosy_lab.cpachecker.pcc.strategy.partitioning.GlobalGraphPartitionerHeuristicFactory;
import org.sosy_lab.cpachecker.pcc.strategy.partitioning.MatchingGeneratorFactory;
import org.sosy_lab.cpachecker.pcc.strategy.partitioning.PartitioningRefinerFactory;

@Options(prefix="pcc.partitioning.multilevel")
public class MultilevelBalancedGraphPartitioner
implements WeightedBalancedGraphPartitioner {
    private final LogManager logger;
    @Option(secure=true, description="Partitioning method applied in multilevel heuristic to compute initial partitioning.")
    private GlobalGraphPartitionerHeuristicFactory.GlobalPartitioningHeuristics globalHeuristic = GlobalGraphPartitionerHeuristicFactory.GlobalPartitioningHeuristics.BEST_IMPROVEMENT_FIRST;
    @Option(secure=true, description="Refinement method applied in multilevel heuristic's uncoarsening phase.")
    private PartitioningRefinerFactory.RefinementHeuristics refinementHeuristic = PartitioningRefinerFactory.RefinementHeuristics.FM_NODECUT;
    @Option(secure=true, description="Matching method applied to coarsen graph down in multilevel heuristic.")
    private MatchingGeneratorFactory.MatchingGenerators matchingGenerator = MatchingGeneratorFactory.MatchingGenerators.HEAVY_EDGE;
    private final PartitioningRefiner refiner;
    private final WeightedBalancedGraphPartitioner globalPartitioner;
    private final MatchingGenerator matcher;

    public MultilevelBalancedGraphPartitioner(Configuration pConfig, LogManager pLogger) throws InvalidConfigurationException {
        pConfig.inject((Object)this);
        this.logger = pLogger;
        this.globalPartitioner = GlobalGraphPartitionerHeuristicFactory.createPartitioner(pConfig, pLogger, this.globalHeuristic);
        this.refiner = PartitioningRefinerFactory.createRefiner(pConfig, pLogger, this.refinementHeuristic);
        this.matcher = MatchingGeneratorFactory.createMatchingGenerator(pLogger, this.matchingGenerator);
    }

    @Override
    public List<Set<Integer>> computePartitioning(int pNumPartitions, PartialReachedSetDirectedGraph pGraph) throws InterruptedException {
        return this.computePartitioning(pNumPartitions, new WeightedGraph(pGraph));
    }

    @Override
    public List<Set<Integer>> computePartitioning(int pNumPartitions, WeightedGraph wGraph) throws InterruptedException {
        Preconditions.checkArgument((pNumPartitions > 0 && wGraph != null ? 1 : 0) != 0, (Object)"Partitioniong must contain at most 1 partition. Graph may not be null.");
        if (pNumPartitions == 1) {
            return wGraph.getGraphAsOnePartition();
        }
        if (pNumPartitions >= wGraph.getNumNodes()) {
            return wGraph.getNodesSeperatelyPartitioned(pNumPartitions);
        }
        ArrayDeque<WeightedGraph> levels = new ArrayDeque<WeightedGraph>();
        ArrayDeque<Map<Integer, Integer>> matchings = new ArrayDeque<Map<Integer, Integer>>();
        int maxLoad = wGraph.getNumNodes() / pNumPartitions + 1;
        int minGraphSize = (int)(Math.min((double)maxLoad / 15.0 + 1.0, 15.0) * (double)pNumPartitions);
        this.logger.log(Level.FINE, new Object[]{String.format("[Multilevel] Coarsen graph down to at least %d nodes", minGraphSize)});
        int currentLevel = 0;
        levels.push(wGraph);
        this.logger.log(Level.FINE, new Object[]{String.format("[Multilevel] Weighted Graph (size: %d) level %d pushed to Stack", wGraph.getNumNodes(), currentLevel++)});
        while (wGraph.getNumNodes() > minGraphSize) {
            wGraph = (WeightedGraph)levels.peek();
            Map<Integer, Integer> matching = this.matcher.computeMatching(wGraph);
            matchings.push(matching);
            wGraph = this.createMatchedGraph(matching, wGraph);
            levels.push(wGraph);
            this.logger.log(Level.FINE, new Object[]{String.format("[Multilevel] Weighted Graph (size: %d) level %d pushed to Stack", wGraph.getNumNodes(), currentLevel++)});
        }
        wGraph = (WeightedGraph)levels.pop();
        this.logger.log(Level.FINE, new Object[]{String.format("[Multilevel] Weighted Graph (size: %d) popped", wGraph.getNumNodes())});
        List<Set<Integer>> partitioning = this.globalPartitioner.computePartitioning(pNumPartitions, wGraph);
        this.refiner.refinePartitioning(partitioning, wGraph, pNumPartitions);
        while (!levels.isEmpty()) {
            wGraph = (WeightedGraph)levels.pop();
            this.logger.log(Level.FINE, new Object[]{String.format("[Multilevel] Weighted Graph (size: %d) popped", wGraph.getNumNodes())});
            Map matching = (Map)matchings.pop();
            this.retransformPartitioning(partitioning, matching);
            this.refiner.refinePartitioning(partitioning, wGraph, pNumPartitions);
        }
        this.removeEmptyPartitions(partitioning);
        return partitioning;
    }

    private void removeEmptyPartitions(List<Set<Integer>> partitions) {
        partitions.removeIf(partition -> partition != null && partition.isEmpty());
    }

    private WeightedGraph createMatchedGraph(Map<Integer, Integer> matching, WeightedGraph wGraph) {
        int matchingSize = this.computeMatchingSize(matching);
        WeightedGraph newGraph = new WeightedGraph(matchingSize);
        int[] nodeWeights = new int[matchingSize];
        Map<Integer, Set<Integer>> newToOldNodes = this.computeInverseMappping(matching);
        for (Map.Entry<Integer, Integer> oldToNewNode : matching.entrySet()) {
            int newNode = oldToNewNode.getValue();
            int oldNode = oldToNewNode.getKey();
            int oldNodeWeight = wGraph.getNode(oldNode).getWeight();
            int n = newNode;
            nodeWeights[n] = nodeWeights[n] + oldNodeWeight;
        }
        for (Map.Entry<Integer, Integer> oldAndNewNode : matching.entrySet()) {
            int oldNode = oldAndNewNode.getKey();
            int newNode = oldAndNewNode.getValue();
            int newNodeWeight = nodeWeights[newNode];
            newGraph.insertNode(new WeightedNode(newNode, newNodeWeight));
            WeightedNode startNode = new WeightedNode(newNode, newNodeWeight);
            Set<Integer> contractedNeigbors = newToOldNodes.get(newNode);
            for (WeightedEdge succEdge : wGraph.getOutgoingEdges(oldNode)) {
                int oldSuccNum = succEdge.getEndNode().getNodeNumber();
                int newSuccNum = matching.get(oldSuccNum);
                if (contractedNeigbors.contains(oldSuccNum)) continue;
                int newSuccWeight = nodeWeights[newSuccNum];
                WeightedNode endNode = new WeightedNode(newSuccNum, newSuccWeight);
                WeightedEdge newEdge = new WeightedEdge(startNode, endNode, succEdge.getWeight());
                newGraph.addEdge(newEdge);
            }
        }
        return newGraph;
    }

    private int computeMatchingSize(Map<Integer, Integer> matching) {
        int count = new HashSet<Integer>(matching.values()).size();
        return count;
    }

    private void retransformPartitioning(List<Set<Integer>> partitioning, Map<Integer, Integer> matching) {
        Map<Integer, Set<Integer>> newToOldNodes = this.computeInverseMappping(matching);
        for (int index = 0; index < partitioning.size(); ++index) {
            Set<Integer> partition = partitioning.get(index);
            HashSet<Integer> newPartition = new HashSet<Integer>(2 * partition.size());
            for (Integer node : partition) {
                Set<Integer> contractedNodes = newToOldNodes.get(node);
                newPartition.addAll(contractedNodes);
            }
            partitioning.set(index, newPartition);
        }
    }

    private Map<Integer, Set<Integer>> computeInverseMappping(Map<Integer, Integer> matching) {
        HashMap<Integer, Set<Integer>> inverseMap = new HashMap<Integer, Set<Integer>>(this.computeMatchingSize(matching));
        for (Map.Entry<Integer, Integer> oldToNewNode : matching.entrySet()) {
            int newNode = oldToNewNode.getValue();
            int oldNode = oldToNewNode.getKey();
            if (!inverseMap.containsKey(newNode)) {
                inverseMap.put(newNode, new HashSet(2));
            }
            ((Set)inverseMap.get(newNode)).add(oldNode);
        }
        return inverseMap;
    }
}

