/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.pcc.strategy.partitioning;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.logging.Level;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.core.CPAcheckerResult;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.interfaces.pcc.BalancedGraphPartitioner;
import org.sosy_lab.cpachecker.core.interfaces.pcc.PartialReachedConstructionAlgorithm;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.pcc.strategy.AbstractStrategy;
import org.sosy_lab.cpachecker.pcc.strategy.partialcertificate.PartialCertificateTypeProvider;
import org.sosy_lab.cpachecker.pcc.strategy.partialcertificate.PartialReachedSetDirectedGraph;
import org.sosy_lab.cpachecker.pcc.strategy.partitioning.GraphPartitionerFactory;
import org.sosy_lab.cpachecker.pcc.util.ProofStatesInfoCollector;
import org.sosy_lab.cpachecker.util.Pair;

@Options(prefix="pcc.partitioning")
public class PartitioningIOHelper {
    @Option(secure=true, description="If enabled uses the number of nodes saved in certificate to compute partition number otherwise the number of states explored during analysis")
    private boolean useGraphSizeToComputePartitionNumber = false;
    @Option(secure=true, description="Specifies the maximum size of the partition. This size is used to compute the number of partitions if a proof (reached set) should be written. Default value 0 means always a single partition.")
    private int maxNumElemsPerPartition = 0;
    @Option(secure=true, description="Heuristic for computing partitioning of proof (partial reached set).")
    private GraphPartitionerFactory.PartitioningHeuristics partitioningStrategy = GraphPartitionerFactory.PartitioningHeuristics.RANDOM;
    private final LogManager logger;
    private final PartialReachedConstructionAlgorithm partialConstructor;
    private final BalancedGraphPartitioner partitioner;
    private int savedReachedSetSize;
    private int numPartitions;
    private List<Pair<AbstractState[], AbstractState[]>> partitions;
    private Statistics currentGraphStatistics;
    private ProofStatesInfoCollector infoCollector;

    public PartitioningIOHelper(Configuration pConfig, LogManager pLogger, ShutdownNotifier pShutdownNotifier) throws InvalidConfigurationException {
        this(pConfig, pLogger, pShutdownNotifier, false);
    }

    protected PartitioningIOHelper(Configuration pConfig, LogManager pLogger, ShutdownNotifier pShutdownNotifier, boolean withCMC) throws InvalidConfigurationException {
        pConfig.inject((Object)this, PartitioningIOHelper.class);
        this.logger = pLogger;
        this.partialConstructor = new PartialCertificateTypeProvider(pConfig, false, withCMC).getCertificateConstructor();
        this.partitioner = GraphPartitionerFactory.createPartitioner(this.logger, this.partitioningStrategy, pShutdownNotifier, pConfig);
    }

    public int getSavedReachedSetSize() {
        return this.savedReachedSetSize;
    }

    public int getNumPartitions() {
        return this.numPartitions;
    }

    public @Nullable Pair<AbstractState[], AbstractState[]> getPartition(int pIndex) {
        if (0 <= pIndex && pIndex < this.numPartitions && pIndex < this.partitions.size()) {
            return this.partitions.get(pIndex);
        }
        return null;
    }

    public void constructInternalProofRepresentation(UnmodifiableReachedSet pReached, ConfigurableProgramAnalysis pCpa) throws InvalidConfigurationException, InterruptedException {
        this.saveInternalProof(pReached.size(), this.computePartialReachedSetAndPartition(pReached, pCpa));
    }

    protected void saveInternalProof(int size, Pair<PartialReachedSetDirectedGraph, List<Set<Integer>>> pPartitionDescription) {
        this.savedReachedSetSize = size;
        this.numPartitions = pPartitionDescription.getSecond().size();
        this.partitions = new ArrayList<Pair<AbstractState[], AbstractState[]>>(this.numPartitions);
        for (Set<Integer> partition : pPartitionDescription.getSecond()) {
            this.partitions.add(Pair.of(pPartitionDescription.getFirst().getSetNodes(partition, false), pPartitionDescription.getFirst().getSuccessorNodesOutsideSet(partition, false)));
        }
    }

    public Pair<PartialReachedSetDirectedGraph, List<Set<Integer>>> computePartialReachedSetAndPartition(UnmodifiableReachedSet pReached, ConfigurableProgramAnalysis pCpa) throws InvalidConfigurationException, InterruptedException {
        AbstractState[] partialCertificate = this.partialConstructor.computePartialReachedSet(pReached, pCpa);
        ARGState[] argNodes = new ARGState[partialCertificate.length];
        for (int i = 0; i < partialCertificate.length; ++i) {
            argNodes[i] = (ARGState)partialCertificate[i];
        }
        PartialReachedSetDirectedGraph graph = new PartialReachedSetDirectedGraph(argNodes);
        this.currentGraphStatistics = graph;
        if (this.useGraphSizeToComputePartitionNumber) {
            return Pair.of(graph, this.partitioner.computePartitioning(this.maxNumElemsPerPartition <= 0 ? 1 : (int)Math.ceil((double)graph.getNumNodes() / (double)this.maxNumElemsPerPartition), graph));
        }
        return Pair.of(graph, this.partitioner.computePartitioning(this.maxNumElemsPerPartition <= 0 ? 1 : (int)Math.ceil((double)pReached.size() / (double)this.maxNumElemsPerPartition), graph));
    }

    public void readPartition(ObjectInputStream pIn, AbstractStrategy.PCStrategyStatistics pStats) throws ClassNotFoundException, IOException {
        Pair<AbstractState[], AbstractState[]> result = this.readPartitionContent(pIn);
        this.partitions.add(result);
        pStats.increaseProofSize(result.getFirst().length + result.getSecond().length);
    }

    private Pair<AbstractState[], AbstractState[]> readPartitionContent(ObjectInputStream pIn) throws ClassNotFoundException, IOException {
        return Pair.of((AbstractState[])pIn.readObject(), (AbstractState[])pIn.readObject());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readPartition(ObjectInputStream pIn, AbstractStrategy.PCStrategyStatistics pStats, Lock pLock) throws ClassNotFoundException, IOException {
        Preconditions.checkArgument((pLock != null ? 1 : 0) != 0, (Object)"Cannot protect against parallel access");
        Pair<AbstractState[], AbstractState[]> result = this.readPartitionContent(pIn);
        int partialProofSize = result.getFirst().length + result.getSecond().length;
        pLock.lock();
        try {
            this.partitions.add(result);
            pStats.increaseProofSize(partialProofSize);
        }
        finally {
            pLock.unlock();
        }
    }

    public void readMetadata(ObjectInputStream pIn, boolean pSave) throws IOException {
        if (pSave) {
            this.savedReachedSetSize = pIn.readInt();
            this.numPartitions = pIn.readInt();
            this.partitions = new ArrayList<Pair<AbstractState[], AbstractState[]>>(this.numPartitions);
        } else {
            pIn.readInt();
            pIn.readInt();
        }
    }

    public void readProof(ObjectInputStream pIn, AbstractStrategy.PCStrategyStatistics pStats) throws IOException, ClassNotFoundException {
        this.readMetadata(pIn, true);
        for (int i = 0; i < this.numPartitions; ++i) {
            this.readPartition(pIn, pStats);
        }
    }

    public void writeMetadata(ObjectOutputStream pOut, int pReachedSetSize, int pNumPartitions) throws IOException {
        this.logger.log(Level.FINER, new Object[]{"Write metadata of partition"});
        pOut.writeInt(pReachedSetSize);
        pOut.writeInt(pNumPartitions);
        pOut.reset();
    }

    public void writePartition(ObjectOutputStream pOut, Set<Integer> pPartition, PartialReachedSetDirectedGraph pPartialReachedSetDirectedGraph) throws IOException {
        this.logger.log(Level.FINER, new Object[]{"Write partition"});
        this.writePartition(pOut, pPartialReachedSetDirectedGraph.getSetNodes(pPartition, false), pPartialReachedSetDirectedGraph.getSuccessorNodesOutsideSet(pPartition, false));
    }

    public void writePartition(ObjectOutputStream pOut, Pair<AbstractState[], AbstractState[]> pPartition) throws IOException {
        this.writePartition(pOut, pPartition.getFirst(), pPartition.getSecond());
    }

    private void writePartition(ObjectOutputStream pOut, AbstractState[] pPartitionNodes, AbstractState[] pAdjacentNodesOutside) throws IOException {
        if (this.infoCollector != null) {
            this.infoCollector.addInfoForStates(pPartitionNodes);
        }
        pOut.writeObject(pPartitionNodes);
        pOut.writeObject(pAdjacentNodesOutside);
    }

    public void writeProof(ObjectOutputStream pOut, UnmodifiableReachedSet pReached, ConfigurableProgramAnalysis pCpa) throws InvalidConfigurationException, IOException, InterruptedException {
        Pair<PartialReachedSetDirectedGraph, List<Set<Integer>>> partitionDescription = this.computePartialReachedSetAndPartition(pReached, pCpa);
        this.writeMetadata(pOut, pReached.size(), partitionDescription.getSecond().size());
        for (Set<Integer> partition : partitionDescription.getSecond()) {
            this.writePartition(pOut, partition, partitionDescription.getFirst());
        }
    }

    public void setProofInfoCollector(ProofStatesInfoCollector pInfoCollector) {
        this.infoCollector = pInfoCollector;
    }

    public Statistics getPartitioningStatistc() {
        return new PartitioningStatistics();
    }

    public Statistics getGraphStatistic() {
        if (this.currentGraphStatistics == null) {
            return new Statistics(){

                @Override
                public void printStatistics(PrintStream pOut, CPAcheckerResult.Result pResult, UnmodifiableReachedSet pReached) {
                }

                @Override
                public @Nullable String getName() {
                    return null;
                }
            };
        }
        return this.currentGraphStatistics;
    }

    private class PartitioningStatistics
    implements Statistics {
        private PartitioningStatistics() {
        }

        @Override
        public void printStatistics(PrintStream pOut, CPAcheckerResult.Result pResult, UnmodifiableReachedSet pReached) {
            if (PartitioningIOHelper.this.numPartitions > 0 && PartitioningIOHelper.this.partitions != null) {
                pOut.printf("Number of partitions: %d%n", PartitioningIOHelper.this.numPartitions);
                pOut.printf("The following numbers are given in number of states.%n", new Object[0]);
                this.computeAndPrintDetailedPartitioningStats(pOut);
            }
            if (PartitioningIOHelper.this.currentGraphStatistics != null) {
                pOut.println("\nStatistics for partial reached set directed graph used in proof construction");
                PartitioningIOHelper.this.currentGraphStatistics.printStatistics(pOut, pResult, pReached);
            }
        }

        @Override
        public void writeOutputFiles(CPAcheckerResult.Result pResult, UnmodifiableReachedSet pReached) {
            if (PartitioningIOHelper.this.currentGraphStatistics != null) {
                PartitioningIOHelper.this.currentGraphStatistics.writeOutputFiles(pResult, pReached);
            }
        }

        private void computeAndPrintDetailedPartitioningStats(PrintStream pOut) {
            int maxP = 0;
            int maxO = 0;
            int minP = Integer.MAX_VALUE;
            int minO = Integer.MAX_VALUE;
            int totalO = 0;
            int totalS = 0;
            for (Pair<AbstractState[], AbstractState[]> partition : PartitioningIOHelper.this.partitions) {
                int current = partition.getSecond().length;
                maxO = Math.max(maxO, current);
                minO = Math.min(minO, current);
                totalO += current;
                maxP = Math.max(maxP, current += partition.getFirst().length);
                minP = Math.min(minP, current);
                totalS += current;
            }
            pOut.printf("Certificate size: %d %n", totalS);
            pOut.printf("Total overhead:  %d%n", totalO);
            pOut.printf("Avg. partition size:  %.2f%n", (double)totalS / (double)PartitioningIOHelper.this.numPartitions);
            pOut.printf("Avg. partition overhead: %.2f%n", (double)totalO / (double)PartitioningIOHelper.this.numPartitions);
            pOut.printf("Max partition size: %d%n", maxP);
            pOut.printf("Max partition overhead: %d%n", maxO);
            pOut.printf("Min partition size: %d%n", minP);
            pOut.printf("Min partition overhead: %d%n", minO);
        }

        @Override
        public String getName() {
            return "PCC Partitioning Statistic";
        }
    }
}

