/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.pcc.strategy.partitioning;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import org.sosy_lab.cpachecker.core.interfaces.pcc.WeightedBalancedGraphPartitioner;
import org.sosy_lab.cpachecker.pcc.strategy.partialcertificate.WeightedGraph;
import org.sosy_lab.cpachecker.pcc.strategy.partitioning.RandomBalancedGraphPartitioner;

public class RandomBalancedWeightedGraphPartitioner
extends RandomBalancedGraphPartitioner
implements WeightedBalancedGraphPartitioner {
    @Override
    public List<Set<Integer>> computePartitioning(int pNumPartitions, WeightedGraph wGraph) throws InterruptedException {
        Preconditions.checkArgument((pNumPartitions > 0 && wGraph != null ? 1 : 0) != 0, (Object)"Partitioniong must contain at most 1 partition. Graph may not be null.");
        if (pNumPartitions == 1) {
            return wGraph.getGraphAsOnePartition();
        }
        if (pNumPartitions >= wGraph.getNumNodes()) {
            return wGraph.getNodesSeperatelyPartitioned(pNumPartitions);
        }
        ArrayList<Set<Integer>> partitioning = new ArrayList<Set<Integer>>(pNumPartitions);
        for (int i = 0; i < pNumPartitions; ++i) {
            partitioning.add(new HashSet());
        }
        Random randomGen = new Random(0L);
        for (int i = 0; i < wGraph.getNumNodes(); ++i) {
            ((Set)partitioning.get(randomGen.nextInt(pNumPartitions))).add(i);
        }
        return partitioning;
    }
}

