/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.pcc.strategy.util.cmc;

import java.io.IOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.FileOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.io.IO;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.core.algorithm.AssumptionCollectorAlgorithm;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.exceptions.CPAException;

@Options(prefix="pcc.cmc")
public class AssumptionAutomatonGenerator {
    private final LogManager logger;
    @Option(secure=true, name="file", description="write collected assumptions to file")
    @FileOption(value=FileOption.Type.OUTPUT_FILE)
    private Path assumptionsFile = Path.of("AssumptionAutomaton.txt", new String[0]);

    public AssumptionAutomatonGenerator(Configuration config, LogManager pLogger) throws InvalidConfigurationException {
        config.inject((Object)this);
        this.logger = pLogger;
    }

    public Set<ARGState> getAllAncestorsFor(Collection<ARGState> nodes) {
        TreeSet<ARGState> uncoveredAncestors = new TreeSet<ARGState>();
        ArrayDeque<ARGState> toAdd = new ArrayDeque<ARGState>(nodes);
        while (!toAdd.isEmpty()) {
            ARGState current = (ARGState)toAdd.pop();
            assert (!current.isCovered());
            if (!uncoveredAncestors.add(current)) continue;
            toAdd.addAll(current.getParents());
            for (ARGState coveredByCurrent : current.getCoveredByThis()) {
                toAdd.addAll(coveredByCurrent.getParents());
            }
        }
        return uncoveredAncestors;
    }

    public void writeAutomaton(ARGState root, List<ARGState> incompleteNodes) throws CPAException {
        assert (this.notCovered(incompleteNodes));
        try (Writer w = IO.openOutputFile((Path)this.assumptionsFile, (Charset)Charset.defaultCharset(), (OpenOption[])new OpenOption[0]);){
            this.logger.log(Level.FINEST, new Object[]{"Write assumption automaton to file ", this.assumptionsFile});
            AssumptionCollectorAlgorithm.writeAutomaton(w, root, this.getAllAncestorsFor(incompleteNodes), new HashSet<AbstractState>(incompleteNodes), 0, true, false);
        }
        catch (IOException e) {
            this.logger.log(Level.SEVERE, new Object[]{"Could not write assumption automaton for next partial ARG checking"});
            throw new CPAException("Assumption automaton writing failed", e);
        }
    }

    private boolean notCovered(List<ARGState> nodes) {
        for (ARGState state : nodes) {
            if (!state.isCovered()) continue;
            return false;
        }
        return true;
    }
}

