/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.pcc.strategy.util.cmc;

import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.logging.Level;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.ConfigurationBuilder;
import org.sosy_lab.common.configuration.FileOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.core.CPABuilder;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.reachedset.AggregatedReachedSets;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSetFactory;
import org.sosy_lab.cpachecker.core.specification.Specification;
import org.sosy_lab.cpachecker.exceptions.CPAException;

@Options(prefix="pcc.cmc")
public class PartialCPABuilder {
    @Option(secure=true, description="List of files with configurations to use. ")
    @FileOption(value=FileOption.Type.OPTIONAL_INPUT_FILE)
    private List<Path> configFiles;
    private final LogManager logger;
    private final Configuration globalConfig;
    private final CFA cfa;
    private final ShutdownNotifier shutdown;
    private final Specification specification;

    public PartialCPABuilder(Configuration config, LogManager pLogger, ShutdownNotifier pShutdownNotifier, CFA pCfa, Specification pSpecification) throws InvalidConfigurationException {
        config.inject((Object)this);
        this.globalConfig = config;
        this.logger = pLogger;
        this.cfa = pCfa;
        this.shutdown = pShutdownNotifier;
        this.specification = pSpecification;
    }

    public ConfigurableProgramAnalysis buildPartialCPA(int iterationNumber, ReachedSetFactory pFactory) throws InvalidConfigurationException, CPAException, InterruptedException {
        this.logger.log(Level.FINEST, new Object[]{"Build CPA configuration"});
        ConfigurationBuilder singleConfigBuilder = Configuration.builder();
        singleConfigBuilder.copyFrom(this.globalConfig);
        try {
            if (this.configFiles == null) {
                throw new InvalidConfigurationException("Require that option pcc.arg.cmc.configFiles is set for proof checking");
            }
            singleConfigBuilder.loadFromFile(this.configFiles.get(iterationNumber));
        }
        catch (IOException e) {
            throw new InvalidConfigurationException("Cannot read configuration for current partial ARG checking.");
        }
        Configuration singleConfig = singleConfigBuilder.build();
        this.logger.log(Level.FINEST, new Object[]{"Create CPA instance"});
        return new CPABuilder(singleConfig, this.logger, this.shutdown, pFactory).buildCPAs(this.cfa, this.specification, AggregatedReachedSets.empty());
    }
}

