/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.pcc.util;

import java.io.PrintStream;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.cpachecker.core.CPAcheckerResult;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.cpa.value.ValueAnalysisState;
import org.sosy_lab.cpachecker.util.AbstractStates;

@Options(prefix="pcc")
public class ProofStatesInfoCollector
implements Statistics {
    @Option(secure=true, description="collects information about value analysis states in proof")
    private boolean collectValueAnalysisStateInfo = false;
    private int numProofStates = 0;
    private int numValuesInValueAnalysisStates = 0;

    public ProofStatesInfoCollector(Configuration pConfig) throws InvalidConfigurationException {
        pConfig.inject((Object)this);
    }

    public void addInfoForStates(AbstractState[] partialProofStates) {
        this.numProofStates += partialProofStates.length;
        if (this.collectValueAnalysisStateInfo) {
            this.collectValueAnalysisInfo(partialProofStates);
        }
    }

    private void collectValueAnalysisInfo(AbstractState[] partialProofStates) {
        for (AbstractState state : partialProofStates) {
            ValueAnalysisState vState = AbstractStates.extractStateByType(state, ValueAnalysisState.class);
            if (vState == null) continue;
            this.numValuesInValueAnalysisStates += vState.getSize();
        }
    }

    public String getInfoAsString() {
        if (this.collectValueAnalysisStateInfo) {
            return "Proof state info:\n #states in proof:\t" + this.numProofStates + "\n #values stored in value analysis:\t" + this.numValuesInValueAnalysisStates;
        }
        return "No proof state information collected.";
    }

    @Override
    public void printStatistics(PrintStream pOut, CPAcheckerResult.Result pResult, UnmodifiableReachedSet pReached) {
        pOut.println(this.getInfoAsString());
    }

    @Override
    public @Nullable String getName() {
        return null;
    }
}

