/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.pcc.util;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.ConfigurationBuilder;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.io.IO;
import org.sosy_lab.cpachecker.exceptions.ValidationConfigurationConstructionFailed;

public class ValidationConfigurationBuilder {
    private final Configuration veriConfig;

    public ValidationConfigurationBuilder(Configuration pVerifConfig) {
        this.veriConfig = pVerifConfig;
    }

    public Configuration getValidationConfiguration() throws ValidationConfigurationConstructionFailed {
        ConfigurationBuilder configBuilder = Configuration.builder();
        configBuilder.copyFrom(this.veriConfig);
        Map<String, String> relPropEntries = this.extractRelevantPropertyEntriesAndClearAnalysisOptions(configBuilder);
        if (relPropEntries.containsKey("analysis.restartAfterUnknown") && relPropEntries.get("analysis.restartAfterUnknown").equals("true")) {
            throw new ValidationConfigurationConstructionFailed();
        }
        this.clearProofCreationOptions(configBuilder);
        this.adaptCPAConfig(configBuilder, relPropEntries);
        try {
            return configBuilder.build();
        }
        catch (InvalidConfigurationException e) {
            throw new ValidationConfigurationConstructionFailed(e);
        }
    }

    private Map<String, String> extractRelevantPropertyEntriesAndClearAnalysisOptions(ConfigurationBuilder pConfigBuilder) {
        HashMap relevantPropertyEntries = Maps.newHashMapWithExpectedSize((int)4);
        try (Scanner s = new Scanner(this.veriConfig.asPropertiesString());){
            while (s.hasNextLine()) {
                String line = s.nextLine();
                int eqSignPos = line.indexOf("=");
                if (eqSignPos < 0) continue;
                String prop = line.substring(0, eqSignPos).trim();
                if (prop.equals("specification") || prop.startsWith("analysis.") || prop.startsWith("statistics.") || prop.startsWith("limits.")) {
                    pConfigBuilder.clearOption(prop);
                    if (!prop.equals("analysis.restartAfterUnknown")) continue;
                }
                if (!prop.contains("cpa") && !prop.equals("pcc.strategy") && !prop.equals("analysis.restartAfterUnknown")) continue;
                String value = line.substring(eqSignPos + 1).trim();
                relevantPropertyEntries.put(prop, value);
            }
        }
        return relevantPropertyEntries;
    }

    private void clearProofCreationOptions(ConfigurationBuilder pConfigBuilder) {
        String[] options;
        for (String option : options = new String[]{"pcc.proofgen.doPCC", "pcc.proofFile", "pcc.resultcheck.writeProof", "pcc.sliceProof", "pcc.resultcheck.checkerConfig", "pcc.collectValueAnalysisStateInfo", "pcc.partial.certificateType", "pcc.partitioning.useGraphSizeToComputePartitionNumber", "pcc.partitioning.partitioningStrategy", "pcc.partitioning.multilevel.refinementHeuristic", "pcc.partitioning.bestfirst.balancePrecision", "pcc.partitioning.bestfirst.chosenFunction", "pcc.partitioning.fm.balanceCriterion", "pcc.partitioning.fm.initialPartitioningStrategy", "pcc.partitioning.kwayfm.balancePrecision", "pcc.partitioning.kwayfm.globalHeuristic", "pcc.partitioning.kwayfm.optimizationCriterion", "pcc.partitioning.maxNumElemsPerPartition", "pcc.partitioning.multilevel.matchingGenerator", "pcc.partitioning.multilevel.globalHeuristic"}) {
            pConfigBuilder.clearOption(option);
        }
    }

    private void adaptCPAConfig(ConfigurationBuilder pConfigBuilder, Map<String, String> pRelPropEntries) {
        String topCPA = pRelPropEntries.get("cpa");
        String strategy = pRelPropEntries.get("pcc.strategy");
        if (strategy == null) {
            strategy = "arg.ARGProofCheckerStrategy";
            pConfigBuilder.setOption("pcc.strategy", "arg.ARGProofCheckerStrategy");
        }
        if (this.notIsARGStrategy(strategy)) {
            this.removeARGCPA(pConfigBuilder, pRelPropEntries);
            if (topCPA.equals("cpa.arg.ARGCPA")) {
                topCPA = pRelPropEntries.get("ARGCPA.cpa");
            }
        }
        if (this.notIsARGCPAStrategyNorContainsPropertyChecker(strategy, topCPA)) {
            this.addPropertyChecker(pConfigBuilder, topCPA);
        }
        if (this.containsCPA("cpa.callstack.CallstackCPA", pRelPropEntries.values())) {
            ValidationConfigurationBuilder.adaptCallstackConfig(pConfigBuilder);
        }
        if (this.containsCPA("cpa.predicate.PredicateCPA", pRelPropEntries.values())) {
            ValidationConfigurationBuilder.adaptPredicateConfig(pConfigBuilder);
        }
    }

    private boolean notIsARGStrategy(String pProofValStrategy) {
        return !pProofValStrategy.contains("ARG");
    }

    private void removeARGCPA(ConfigurationBuilder pConfigBuilder, Map<String, String> pRelPropEntries) {
        for (Map.Entry<String, String> relProp : pRelPropEntries.entrySet()) {
            if (!relProp.getValue().equals("cpa.arg.ARGCPA")) continue;
            ValidationConfigurationBuilder.overwriteOrAddConfigOption(pConfigBuilder, relProp.getKey(), pRelPropEntries.get("ARGCPA.cpa"));
            pConfigBuilder.clearOption("ARGCPA.cpa");
            break;
        }
    }

    private boolean notIsARGCPAStrategyNorContainsPropertyChecker(String pProofValStrategy, String pTopCPA) {
        return !pProofValStrategy.contains("ARGProofCheckerStrategy") && !pTopCPA.equals("cpa.PropertyChecker.PropertyCheckerCPA");
    }

    private void addPropertyChecker(ConfigurationBuilder pConfigBuilder, String pTopCPAValue) {
        ValidationConfigurationBuilder.overwriteOrAddConfigOption(pConfigBuilder, "cpa", "cpa.PropertyChecker.PropertyCheckerCPA");
        pConfigBuilder.setOption("PropertyCheckerCPA.cpa", pTopCPAValue);
        ValidationConfigurationBuilder.overwriteOrAddConfigOption(pConfigBuilder, "cpa.propertychecker.className", "NoTargetStateChecker");
    }

    private boolean containsCPA(String cpaByName, Collection<String> pPropValueSubset) {
        for (String value : pPropValueSubset) {
            if (!value.contains(cpaByName)) continue;
            return true;
        }
        return false;
    }

    public static void adaptCallstackConfig(ConfigurationBuilder pConfigBuilder) {
        ValidationConfigurationBuilder.overwriteOrAddConfigOption(pConfigBuilder, "cpa.callstack.domain", "FLATPCC");
    }

    public static void adaptPredicateConfig(ConfigurationBuilder pConfigBuilder) {
        ValidationConfigurationBuilder.overwriteOrAddConfigOption(pConfigBuilder, "cpa.predicate.stop", "SEPPCC");
        ValidationConfigurationBuilder.overwriteOrAddConfigOption(pConfigBuilder, "cpa.predicate.targetStateSatCheck", "true");
        ValidationConfigurationBuilder.overwriteOrAddConfigOption(pConfigBuilder, "satCheckAtAbstraction", "true");
    }

    private static void overwriteOrAddConfigOption(ConfigurationBuilder pConfigBuilder, String pOptionName, String pValue) {
        pConfigBuilder.clearOption(pOptionName);
        pConfigBuilder.setOption(pOptionName, pValue);
    }

    public static Configuration readConfigFromProof(Path proofFile) throws IOException, InvalidConfigurationException {
        try (InputStream fis = Files.newInputStream(proofFile, new OpenOption[0]);){
            Configuration configuration;
            try (ZipInputStream zis = new ZipInputStream(fis);){
                ZipEntry entry;
                while ((entry = zis.getNextEntry()) != null && !entry.getName().equals("Config")) {
                }
                if (entry == null) {
                    throw new IOException("Unable to find configuration entry in proof.");
                }
                Path valConfig = Files.createTempFile("pcc-check-config", "properties", new FileAttribute[0]);
                try (ObjectInputStream in = new ObjectInputStream(zis);){
                    IO.writeFile((Path)valConfig, (Charset)StandardCharsets.UTF_8, (Object)in.readObject());
                }
                catch (ClassNotFoundException e) {
                    throw new IOException("Failed to read configuration");
                }
                configuration = Configuration.builder().loadFromFile(valConfig).build();
            }
            return configuration;
        }
    }
}

