/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.graph.Traverser;
import java.util.Optional;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.defaults.AbstractSerializableSingleWrapperState;
import org.sosy_lab.cpachecker.core.defaults.AbstractSingleWrapperState;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.AbstractStateWithLocation;
import org.sosy_lab.cpachecker.core.interfaces.AbstractStateWithLocations;
import org.sosy_lab.cpachecker.core.interfaces.AbstractWrapperState;
import org.sosy_lab.cpachecker.core.interfaces.FormulaReportingState;
import org.sosy_lab.cpachecker.core.interfaces.Targetable;
import org.sosy_lab.cpachecker.core.reachedset.LocationMappedReachedSet;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.cpa.assumptions.storage.AssumptionStorageState;
import org.sosy_lab.cpachecker.cpa.callstack.CallstackState;
import org.sosy_lab.cpachecker.cpa.callstack.CallstackStateEqualsWrapper;
import org.sosy_lab.cpachecker.util.predicates.smt.FormulaManagerView;
import org.sosy_lab.java_smt.api.BooleanFormula;

public final class AbstractStates {
    private AbstractStates() {
    }

    public static <T extends AbstractState> @Nullable T extractStateByType(AbstractState pState, Class<T> pType) {
        if (pType.isInstance(pState)) {
            return (T)((AbstractState)pType.cast(pState));
        }
        if (pState instanceof AbstractSingleWrapperState) {
            AbstractState wrapped = ((AbstractSingleWrapperState)pState).getWrappedState();
            return AbstractStates.extractStateByType(wrapped, pType);
        }
        if (pState instanceof AbstractSerializableSingleWrapperState) {
            AbstractState wrapped = ((AbstractSerializableSingleWrapperState)pState).getWrappedState();
            return AbstractStates.extractStateByType(wrapped, pType);
        }
        if (pState instanceof AbstractWrapperState) {
            for (AbstractState wrapped : ((AbstractWrapperState)pState).getWrappedStates()) {
                T result = AbstractStates.extractStateByType(wrapped, pType);
                if (result == null) continue;
                return result;
            }
        }
        return null;
    }

    public static <T extends AbstractState> FluentIterable<T> projectToType(Iterable<AbstractState> states, Class<T> pType) {
        return FluentIterable.from(states).transform(AbstractStates.toState(pType)).filter(Predicates.notNull());
    }

    public static @Nullable CFANode extractLocation(AbstractState pState) {
        AbstractStateWithLocation e = AbstractStates.extractStateByType(pState, AbstractStateWithLocation.class);
        return e == null ? null : e.getLocationNode();
    }

    public static Optional<CallstackStateEqualsWrapper> extractOptionalCallstackWraper(AbstractState pState) {
        CallstackState callstack = AbstractStates.extractStateByType(pState, CallstackState.class);
        return callstack == null ? Optional.empty() : Optional.of(new CallstackStateEqualsWrapper(callstack));
    }

    public static Iterable<CFANode> extractLocations(AbstractState pState) {
        AbstractStateWithLocations e = AbstractStates.extractStateByType(pState, AbstractStateWithLocations.class);
        return e == null ? ImmutableList.of() : e.getLocationNodes();
    }

    public static FluentIterable<CFANode> extractLocations(Iterable<? extends AbstractState> pStates) {
        return FluentIterable.from(pStates).transformAndConcat(AbstractStates::extractLocations);
    }

    public static Iterable<CFAEdge> getOutgoingEdges(AbstractState pState) {
        return AbstractStates.extractStateByType(pState, AbstractStateWithLocations.class).getOutgoingEdges();
    }

    public static Iterable<AbstractState> filterLocation(Iterable<AbstractState> pStates, CFANode pLoc) {
        if (pStates instanceof LocationMappedReachedSet) {
            return ((LocationMappedReachedSet)pStates).getReached(pLoc);
        }
        Predicate statesWithRightLocation = Predicates.compose((Predicate)Predicates.equalTo((Object)pLoc), AbstractStates::extractLocation);
        return FluentIterable.from(pStates).filter(statesWithRightLocation);
    }

    public static FluentIterable<AbstractState> filterLocations(Iterable<AbstractState> pStates, Set<CFANode> pLocs) {
        if (pStates instanceof LocationMappedReachedSet) {
            LocationMappedReachedSet states = (LocationMappedReachedSet)pStates;
            return FluentIterable.from(pLocs).transformAndConcat(states::getReached);
        }
        Predicate statesWithRightLocation = Predicates.compose((Predicate)Predicates.in(pLocs), AbstractStates::extractLocation);
        return FluentIterable.from(pStates).filter(statesWithRightLocation);
    }

    public static boolean isTargetState(AbstractState as) {
        return as instanceof Targetable && ((Targetable)((Object)as)).isTarget();
    }

    public static FluentIterable<AbstractState> getTargetStates(UnmodifiableReachedSet pReachedSet) {
        return FluentIterable.from((Iterable)pReachedSet).filter(AbstractStates::isTargetState);
    }

    public static boolean hasAssumptions(AbstractState as) {
        AssumptionStorageState assumption = AbstractStates.extractStateByType(as, AssumptionStorageState.class);
        return assumption != null && !assumption.isStopFormulaTrue() && !assumption.isAssumptionTrue();
    }

    public static <T extends AbstractState> Function<AbstractState, T> toState(Class<T> pType) {
        return as -> AbstractStates.extractStateByType(as, pType);
    }

    public static FluentIterable<AbstractState> asIterable(AbstractState as) {
        return FluentIterable.from((Iterable)Traverser.forTree(state -> {
            if (state instanceof AbstractWrapperState) {
                return ((AbstractWrapperState)state).getWrappedStates();
            }
            return ImmutableList.of();
        }).depthFirstPreOrder((Object)as));
    }

    public static FluentIterable<AbstractState> asFlatIterable(Iterable<AbstractState> pStates) {
        return FluentIterable.from(pStates).transformAndConcat(AbstractStates::asIterable);
    }

    public static BooleanFormula extractReportedFormulas(FormulaManagerView manager, AbstractState state) {
        return AbstractStates.asIterable(state).filter(FormulaReportingState.class).transform(s -> s.getFormulaApproximation(manager)).stream().collect(manager.getBooleanFormulaManager().toConjunction());
    }
}

