/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util;

import apron.Box;
import apron.Manager;
import apron.Octagon;
import apron.Polka;
import apron.PolkaEq;
import apron.SetUp;
import org.sosy_lab.common.NativeLibraries;

public class ApronManager {
    private final Manager manager;

    public ApronManager(AbstractDomain pAbstractDomain) {
        try {
            SetUp.init((String)NativeLibraries.getNativeLibraryPath().resolve("apron").toAbsolutePath().toString());
        }
        catch (RuntimeException e) {
            if ("Could not add the necessary path to java.library.path".equals(e.getMessage())) {
                UnsatisfiedLinkError error = new UnsatisfiedLinkError();
                error.initCause(e);
                throw error;
            }
            throw e;
        }
        this.manager = this.createManager(pAbstractDomain);
    }

    public Manager getManager() {
        return this.manager;
    }

    private Manager createManager(AbstractDomain pAbstractDomain) {
        switch (pAbstractDomain) {
            case BOX: {
                return new Box();
            }
            case OCTAGON: {
                return new Octagon();
            }
            case POLKA: {
                return new Polka(false);
            }
            case POLKA_STRICT: {
                return new Polka(true);
            }
            case POLKA_EQ: {
                return new PolkaEq();
            }
        }
        throw new UnsupportedOperationException("Unexpected argument for domain option.");
    }

    public static enum AbstractDomain {
        BOX,
        OCTAGON,
        POLKA,
        POLKA_STRICT,
        POLKA_EQ;

    }
}

