/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import org.sosy_lab.common.collect.Collections3;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.common.log.LogManagerWithoutDuplicates;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.ast.ASimpleDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.FileLocation;
import org.sosy_lab.cpachecker.cfa.ast.c.CArraySubscriptExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CCastExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CComplexCastExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CComplexTypeDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CDesignatedInitializer;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpressionAssignmentStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpressionStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallAssignmentStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializer;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializerExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializerList;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializerVisitor;
import org.sosy_lab.cpachecker.cfa.ast.c.CIntegerLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CParameterDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CPointerExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CSimpleDeclarationVisitor;
import org.sosy_lab.cpachecker.cfa.ast.c.CStatementVisitor;
import org.sosy_lab.cpachecker.cfa.ast.c.CTypeDefDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CUnaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.DefaultCExpressionVisitor;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.c.CAssumeEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CDeclarationEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionCallEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CReturnStatementEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CStatementEdge;
import org.sosy_lab.cpachecker.cfa.simplification.ExpressionSimplificationVisitor;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.cfa.types.c.CEnumType;
import org.sosy_lab.cpachecker.cfa.types.c.CNumericTypes;
import org.sosy_lab.cpachecker.cfa.types.c.CPointerType;
import org.sosy_lab.cpachecker.cfa.types.c.CSimpleType;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.cpa.assumptions.genericassumptions.GenericAssumptionBuilder;
import org.sosy_lab.cpachecker.exceptions.UnrecognizedCodeException;
import org.sosy_lab.cpachecker.util.CFAUtils;
import org.sosy_lab.cpachecker.util.LiveVariables;
import org.sosy_lab.cpachecker.util.OverflowAssumptionManager;

@Options(prefix="overflow")
public final class ArithmeticOverflowAssumptionBuilder
implements GenericAssumptionBuilder {
    @Option(description="Only check live variables for overflow, as compiler can remove dead variables.", secure=true)
    private boolean useLiveness = true;
    @Option(description="Track overflows in left-shift operations.")
    private boolean trackLeftShifts = true;
    @Option(description="Track overflows in additive(+/-) operations.")
    private boolean trackAdditiveOperations = true;
    @Option(description="Track overflows in multiplication operations.")
    private boolean trackMultiplications = true;
    @Option(description="Track overflows in division(/ or %) operations.")
    private boolean trackDivisions = true;
    @Option(description="Track overflows in binary expressions involving pointers.")
    private boolean trackPointers = false;
    @Option(description="Simplify overflow assumptions.")
    private boolean simplifyExpressions = true;
    private final Map<CType, CLiteralExpression> upperBounds;
    private final Map<CType, CLiteralExpression> lowerBounds;
    private final Map<CType, CLiteralExpression> width;
    private final OverflowAssumptionManager ofmgr;
    private final ExpressionSimplificationVisitor simplificationVisitor;
    private final MachineModel machineModel;
    private final Optional<LiveVariables> liveVariables;
    private final LogManager logger;

    public ArithmeticOverflowAssumptionBuilder(CFA cfa, LogManager logger, Configuration pConfiguration) throws InvalidConfigurationException {
        this(cfa.getMachineModel(), cfa.getLiveVariables(), logger, pConfiguration);
    }

    public ArithmeticOverflowAssumptionBuilder(MachineModel pMachineModel, Optional<LiveVariables> pLiveVariables, LogManager logger, Configuration pConfiguration) throws InvalidConfigurationException {
        pConfiguration.inject((Object)this);
        this.logger = logger;
        this.liveVariables = pLiveVariables;
        this.machineModel = pMachineModel;
        if (this.useLiveness) {
            Preconditions.checkState((boolean)this.liveVariables.isPresent(), (Object)"Liveness information is required for overflow analysis.");
        }
        this.upperBounds = new HashMap<CType, CLiteralExpression>();
        this.lowerBounds = new HashMap<CType, CLiteralExpression>();
        this.width = new HashMap<CType, CLiteralExpression>();
        this.trackType(CNumericTypes.INT);
        this.trackType(CNumericTypes.SIGNED_INT);
        this.trackType(CNumericTypes.LONG_INT);
        this.trackType(CNumericTypes.SIGNED_LONG_INT);
        this.trackType(CNumericTypes.LONG_LONG_INT);
        this.trackType(CNumericTypes.SIGNED_LONG_LONG_INT);
        this.ofmgr = new OverflowAssumptionManager(this.machineModel, logger);
        this.simplificationVisitor = new ExpressionSimplificationVisitor(this.machineModel, new LogManagerWithoutDuplicates(logger));
    }

    @Override
    public Set<CExpression> assumptionsForEdge(CFAEdge pEdge) throws UnrecognizedCodeException {
        LinkedHashSet<CExpression> result = new LinkedHashSet<CExpression>();
        CFANode node = pEdge.getPredecessor();
        AssumptionsFinder finder = new AssumptionsFinder(result, node);
        switch (pEdge.getEdgeType()) {
            case BlankEdge: {
                break;
            }
            case AssumeEdge: {
                CAssumeEdge assumeEdge = (CAssumeEdge)pEdge;
                assumeEdge.getExpression().accept(finder);
                break;
            }
            case FunctionCallEdge: {
                CFunctionCallEdge fcallEdge = (CFunctionCallEdge)pEdge;
                for (CExpression e : fcallEdge.getArguments()) {
                    e.accept(finder);
                }
                break;
            }
            case StatementEdge: {
                CStatementEdge stmtEdge = (CStatementEdge)pEdge;
                stmtEdge.getStatement().accept(finder);
                break;
            }
            case DeclarationEdge: {
                CDeclarationEdge declarationEdge = (CDeclarationEdge)pEdge;
                declarationEdge.getDeclaration().accept(finder);
                break;
            }
            case ReturnStatementEdge: {
                CReturnStatementEdge returnEdge = (CReturnStatementEdge)pEdge;
                if (!returnEdge.getExpression().isPresent()) break;
                returnEdge.getExpression().orElseThrow().accept(finder);
                break;
            }
            case FunctionReturnEdge: 
            case CallToReturnEdge: {
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unexpected edge type");
            }
        }
        if (this.simplifyExpressions) {
            return Collections3.transformedImmutableSetCopy(result, x -> x.accept(this.simplificationVisitor));
        }
        return ImmutableSet.copyOf(result);
    }

    private void trackType(CSimpleType type) {
        CIntegerLiteralExpression typeMinValue = new CIntegerLiteralExpression(FileLocation.DUMMY, type, this.machineModel.getMinimalIntegerValue(type));
        CIntegerLiteralExpression typeMaxValue = new CIntegerLiteralExpression(FileLocation.DUMMY, type, this.machineModel.getMaximalIntegerValue(type));
        CIntegerLiteralExpression typeWidth = new CIntegerLiteralExpression(FileLocation.DUMMY, type, OverflowAssumptionManager.getWidthForMaxOf(this.machineModel.getMaximalIntegerValue(type)));
        this.upperBounds.put(type, typeMaxValue);
        this.lowerBounds.put(type, typeMinValue);
        this.width.put(type, typeWidth);
    }

    private void addAssumptionOnBounds(CExpression exp, Set<CExpression> result, CFANode node) throws UnrecognizedCodeException {
        Set<ASimpleDeclaration> liveVars;
        ImmutableSet referencedDeclarations;
        if (this.useLiveness && Sets.intersection((Set)(referencedDeclarations = CFAUtils.getIdExpressionsOfExpression(exp).transform(CIdExpression::getDeclaration).toSet()), liveVars = this.liveVariables.orElseThrow().getLiveVariablesForNode(node)).isEmpty()) {
            this.logger.log(Level.FINE, new Object[]{"No live variables found in expression", exp, "skipping"});
            return;
        }
        if (this.isBinaryExpressionThatMayOverflow(exp)) {
            CBinaryExpression binexp = (CBinaryExpression)exp;
            CBinaryExpression.BinaryOperator binop = binexp.getOperator();
            CType calculationType = binexp.getCalculationType();
            CExpression op1 = binexp.getOperand1();
            CExpression op2 = binexp.getOperand2();
            if (this.trackAdditiveOperations && (binop.equals(CBinaryExpression.BinaryOperator.PLUS) || binop.equals(CBinaryExpression.BinaryOperator.MINUS))) {
                if (this.lowerBounds.get(calculationType) != null) {
                    result.add(this.ofmgr.getLowerAssumption(op1, op2, binop, this.lowerBounds.get(calculationType)));
                }
                if (this.upperBounds.get(calculationType) != null) {
                    result.add(this.ofmgr.getUpperAssumption(op1, op2, binop, this.upperBounds.get(calculationType)));
                }
            } else if (this.trackMultiplications && binop.equals(CBinaryExpression.BinaryOperator.MULTIPLY)) {
                if (this.lowerBounds.get(calculationType) != null && this.upperBounds.get(calculationType) != null) {
                    result.addAll(this.ofmgr.addMultiplicationAssumptions(op1, op2, this.lowerBounds.get(calculationType), this.upperBounds.get(calculationType)));
                }
            } else if (this.trackDivisions && (binop.equals(CBinaryExpression.BinaryOperator.DIVIDE) || binop.equals(CBinaryExpression.BinaryOperator.MODULO))) {
                if (this.lowerBounds.get(calculationType) != null) {
                    this.ofmgr.addDivisionAssumption(op1, op2, this.lowerBounds.get(calculationType), result);
                }
            } else if (this.trackLeftShifts && binop.equals(CBinaryExpression.BinaryOperator.SHIFT_LEFT) && this.upperBounds.get(calculationType) != null && this.width.get(calculationType) != null) {
                this.ofmgr.addLeftShiftAssumptions(op1, op2, this.upperBounds.get(calculationType), result);
            }
        } else if (exp instanceof CUnaryExpression) {
            CType calculationType = exp.getExpressionType();
            CUnaryExpression unaryexp = (CUnaryExpression)exp;
            if (unaryexp.getOperator().equals(CUnaryExpression.UnaryOperator.MINUS) && this.lowerBounds.get(calculationType) != null) {
                CExpression operand = unaryexp.getOperand();
                result.add(this.ofmgr.getNegationAssumption(operand, this.lowerBounds.get(calculationType)));
            }
        }
    }

    private boolean isBinaryExpressionThatMayOverflow(CExpression pExp) {
        if (pExp instanceof CBinaryExpression) {
            CBinaryExpression binexp = (CBinaryExpression)pExp;
            CExpression op1 = binexp.getOperand1();
            CExpression op2 = binexp.getOperand2();
            if (op1.getExpressionType() instanceof CPointerType || op2.getExpressionType() instanceof CPointerType) {
                return this.trackPointers;
            }
            return true;
        }
        return false;
    }

    private boolean resultCanOverflow(CExpression expr) {
        if (expr instanceof CBinaryExpression) {
            switch (((CBinaryExpression)expr).getOperator()) {
                case MULTIPLY: 
                case DIVIDE: 
                case PLUS: 
                case MINUS: 
                case SHIFT_LEFT: 
                case SHIFT_RIGHT: {
                    return true;
                }
            }
            return false;
        }
        if (expr instanceof CUnaryExpression) {
            switch (((CUnaryExpression)expr).getOperator()) {
                case MINUS: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    private class AssumptionsFinder
    extends DefaultCExpressionVisitor<Void, UnrecognizedCodeException>
    implements CStatementVisitor<Void, UnrecognizedCodeException>,
    CSimpleDeclarationVisitor<Void, UnrecognizedCodeException>,
    CInitializerVisitor<Void, UnrecognizedCodeException> {
        private final Set<CExpression> assumptions;
        private final CFANode node;

        private AssumptionsFinder(Set<CExpression> pAssumptions, CFANode node) {
            this.assumptions = pAssumptions;
            this.node = node;
        }

        @Override
        public Void visit(CBinaryExpression pIastBinaryExpression) throws UnrecognizedCodeException {
            if (ArithmeticOverflowAssumptionBuilder.this.resultCanOverflow(pIastBinaryExpression)) {
                ArithmeticOverflowAssumptionBuilder.this.addAssumptionOnBounds(pIastBinaryExpression, this.assumptions, this.node);
            }
            pIastBinaryExpression.getOperand1().accept(this);
            pIastBinaryExpression.getOperand2().accept(this);
            return null;
        }

        @Override
        protected Void visitDefault(CExpression exp) throws UnrecognizedCodeException {
            return null;
        }

        @Override
        public Void visit(CArraySubscriptExpression pIastArraySubscriptExpression) throws UnrecognizedCodeException {
            return pIastArraySubscriptExpression.getSubscriptExpression().accept(this);
        }

        @Override
        public Void visit(CPointerExpression pointerExpression) throws UnrecognizedCodeException {
            return pointerExpression.getOperand().accept(this);
        }

        @Override
        public Void visit(CComplexCastExpression complexCastExpression) throws UnrecognizedCodeException {
            return complexCastExpression.getOperand().accept(this);
        }

        @Override
        public Void visit(CUnaryExpression pIastUnaryExpression) throws UnrecognizedCodeException {
            if (ArithmeticOverflowAssumptionBuilder.this.resultCanOverflow(pIastUnaryExpression)) {
                ArithmeticOverflowAssumptionBuilder.this.addAssumptionOnBounds(pIastUnaryExpression, this.assumptions, this.node);
            }
            return pIastUnaryExpression.getOperand().accept(this);
        }

        @Override
        public Void visit(CCastExpression pIastCastExpression) throws UnrecognizedCodeException {
            return pIastCastExpression.getOperand().accept(this);
        }

        @Override
        public Void visit(CExpressionStatement pIastExpressionStatement) throws UnrecognizedCodeException {
            return pIastExpressionStatement.getExpression().accept(this);
        }

        @Override
        public Void visit(CExpressionAssignmentStatement pIastExpressionAssignmentStatement) throws UnrecognizedCodeException {
            return pIastExpressionAssignmentStatement.getRightHandSide().accept(this);
        }

        @Override
        public Void visit(CFunctionCallAssignmentStatement pIastFunctionCallAssignmentStatement) throws UnrecognizedCodeException {
            for (CExpression arg : pIastFunctionCallAssignmentStatement.getRightHandSide().getParameterExpressions()) {
                arg.accept(this);
            }
            return null;
        }

        @Override
        public Void visit(CFunctionCallStatement pIastFunctionCallStatement) throws UnrecognizedCodeException {
            for (CExpression arg : pIastFunctionCallStatement.getFunctionCallExpression().getParameterExpressions()) {
                arg.accept(this);
            }
            return null;
        }

        @Override
        public Void visit(CFunctionDeclaration pDecl) throws UnrecognizedCodeException {
            return null;
        }

        @Override
        public Void visit(CComplexTypeDeclaration pDecl) throws UnrecognizedCodeException {
            return null;
        }

        @Override
        public Void visit(CTypeDefDeclaration pDecl) throws UnrecognizedCodeException {
            return null;
        }

        @Override
        public Void visit(CVariableDeclaration pDecl) throws UnrecognizedCodeException {
            if (pDecl.getInitializer() != null) {
                pDecl.getInitializer().accept(this);
            }
            return null;
        }

        @Override
        public Void visit(CParameterDeclaration pDecl) throws UnrecognizedCodeException {
            return null;
        }

        @Override
        public Void visit(CEnumType.CEnumerator pDecl) throws UnrecognizedCodeException {
            return null;
        }

        @Override
        public Void visit(CInitializerExpression pInitializerExpression) throws UnrecognizedCodeException {
            pInitializerExpression.getExpression().accept(this);
            return null;
        }

        @Override
        public Void visit(CInitializerList pInitializerList) throws UnrecognizedCodeException {
            for (CInitializer initializer : pInitializerList.getInitializers()) {
                initializer.accept(this);
            }
            return null;
        }

        @Override
        public Void visit(CDesignatedInitializer pCStructInitializerPart) throws UnrecognizedCodeException {
            pCStructInitializerPart.getRightHandSide().accept(this);
            return null;
        }
    }
}

