/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util;

import com.google.common.base.Predicate;
import java.util.Collection;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import org.sosy_lab.cpachecker.util.Pair;

public class BiPredicates {
    public static <T, U> BiPredicate<T, U> alwaysFalse() {
        return (a, b) -> false;
    }

    public static <T, U> BiPredicate<T, U> alwaysTrue() {
        return (a, b) -> true;
    }

    public static <T> BiPredicate<T, T> bothSatisfy(java.util.function.Predicate<? super T> p) {
        return (a, b) -> p.test(a) && p.test(b);
    }

    public static <T> BiPredicate<T, T> bothSatisfy(Predicate<? super T> p) {
        return (a, b) -> p.apply(a) && p.apply(b);
    }

    public static <T> BiPredicate<T, T> anySatisfies(java.util.function.Predicate<? super T> p) {
        return (a, b) -> p.test(a) || p.test(b);
    }

    public static <T> BiPredicate<T, T> anySatisfies(Predicate<? super T> p) {
        return (a, b) -> p.test(a) || p.test(b);
    }

    public static <T, U> BiPredicate<T, U> pairIn(Collection<Pair<T, U>> collection) {
        return (a, b) -> collection.contains(Pair.of(a, b));
    }

    public static <T, U, R> BiPredicate<T, U> compose(BiFunction<? super T, ? super U, R> func, java.util.function.Predicate<? super R> pred) {
        return (a, b) -> pred.test((Object)func.apply(a, b));
    }
}

