/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import org.sosy_lab.cpachecker.cfa.types.c.CNumericTypes;
import org.sosy_lab.cpachecker.cfa.types.c.CSimpleType;
import org.sosy_lab.cpachecker.cfa.types.c.CType;

public class BuiltinFloatFunctions {
    private static final ImmutableList<String> INFINITY_FLOAT = BuiltinFloatFunctions.of("inff");
    private static final ImmutableList<String> INFINITY = BuiltinFloatFunctions.of("inf");
    private static final ImmutableList<String> INFINITY_LONG_DOUBLE = BuiltinFloatFunctions.of("infl");
    private static final ImmutableList<String> HUGE_VAL_FLOAT = BuiltinFloatFunctions.of("huge_valf");
    private static final ImmutableList<String> HUGE_VAL = BuiltinFloatFunctions.of("huge_val");
    private static final ImmutableList<String> HUGE_VAL_LONG_DOUBLE = BuiltinFloatFunctions.of("huge_vall");
    private static final ImmutableList<String> NOT_A_NUMBER_FLOAT = BuiltinFloatFunctions.of("nanf");
    private static final ImmutableList<String> NOT_A_NUMBER = BuiltinFloatFunctions.of("nan");
    private static final ImmutableList<String> NOT_A_NUMBER_LONG_DOUBLE = BuiltinFloatFunctions.of("nanl");
    private static final ImmutableList<String> ABSOLUTE_VAL_FLOAT = BuiltinFloatFunctions.of("fabsf");
    private static final ImmutableList<String> ABSOLUTE_VAL = BuiltinFloatFunctions.of("fabs");
    private static final ImmutableList<String> ABSOLUTE_VAL_LONG_DOUBLE = BuiltinFloatFunctions.of("fabsl");
    private static final ImmutableList<String> FLOOR_FLOAT = BuiltinFloatFunctions.of("floorf");
    private static final ImmutableList<String> FLOOR = BuiltinFloatFunctions.of("floor");
    private static final ImmutableList<String> FLOOR_LONG_DOUBLE = BuiltinFloatFunctions.of("floorl");
    private static final ImmutableList<String> CEIL_FLOAT = BuiltinFloatFunctions.of("ceilf");
    private static final ImmutableList<String> CEIL = BuiltinFloatFunctions.of("ceil");
    private static final ImmutableList<String> CEIL_LONG_DOUBLE = BuiltinFloatFunctions.of("ceill");
    private static final ImmutableList<String> ROUND_FLOAT = BuiltinFloatFunctions.of("roundf");
    private static final ImmutableList<String> ROUND = BuiltinFloatFunctions.of("round");
    private static final ImmutableList<String> ROUND_LONG_DOUBLE = BuiltinFloatFunctions.of("roundl");
    private static final ImmutableList<String> LROUND_FLOAT = BuiltinFloatFunctions.of("lroundf");
    private static final ImmutableList<String> LROUND = BuiltinFloatFunctions.of("lround");
    private static final ImmutableList<String> LROUND_LONG_DOUBLE = BuiltinFloatFunctions.of("lroundl");
    private static final ImmutableList<String> LLROUND_FLOAT = BuiltinFloatFunctions.of("llroundf");
    private static final ImmutableList<String> LLROUND = BuiltinFloatFunctions.of("llround");
    private static final ImmutableList<String> LLROUND_LONG_DOUBLE = BuiltinFloatFunctions.of("llroundl");
    private static final ImmutableList<String> TRUNC_FLOAT = BuiltinFloatFunctions.of("truncf");
    private static final ImmutableList<String> TRUNC = BuiltinFloatFunctions.of("trunc");
    private static final ImmutableList<String> TRUNC_LONG_DOUBLE = BuiltinFloatFunctions.of("truncl");
    private static final ImmutableList<String> FDIM_FLOAT = BuiltinFloatFunctions.of("fdimf");
    private static final ImmutableList<String> FDIM = BuiltinFloatFunctions.of("fdim");
    private static final ImmutableList<String> FDIM_LONG_DOUBLE = BuiltinFloatFunctions.of("fdiml");
    private static final ImmutableList<String> FMAX_FLOAT = BuiltinFloatFunctions.of("fmaxf");
    private static final ImmutableList<String> FMAX = BuiltinFloatFunctions.of("fmax");
    private static final ImmutableList<String> FMAX_LONG_DOUBLE = BuiltinFloatFunctions.of("fmaxl");
    private static final ImmutableList<String> FMIN_FLOAT = BuiltinFloatFunctions.of("fminf");
    private static final ImmutableList<String> FMIN = BuiltinFloatFunctions.of("fmin");
    private static final ImmutableList<String> FMIN_LONG_DOUBLE = BuiltinFloatFunctions.of("fminl");
    private static final ImmutableList<String> FMOD_FLOAT = BuiltinFloatFunctions.of("fmodf");
    private static final ImmutableList<String> FMOD = BuiltinFloatFunctions.of("fmod");
    private static final ImmutableList<String> FMOD_LONG_DOUBLE = BuiltinFloatFunctions.of("fmodl");
    private static final ImmutableList<String> MODF_FLOAT = BuiltinFloatFunctions.of("modff");
    private static final ImmutableList<String> MODF = BuiltinFloatFunctions.of("modf");
    private static final ImmutableList<String> MODF_LONG_DOUBLE = BuiltinFloatFunctions.of("modfl");
    private static final ImmutableList<String> FREMAINDER_FLOAT = BuiltinFloatFunctions.of("remainderf");
    private static final ImmutableList<String> FREMAINDER = BuiltinFloatFunctions.of("remainder");
    private static final ImmutableList<String> FREMAINDER_LONG_DOUBLE = BuiltinFloatFunctions.of("remainderl");
    private static final ImmutableList<String> ISGREATER = BuiltinFloatFunctions.of("isgreater");
    private static final ImmutableList<String> ISGREATEREQUAL = BuiltinFloatFunctions.of("isgreaterequal");
    private static final ImmutableList<String> ISLESS = BuiltinFloatFunctions.of("isless");
    private static final ImmutableList<String> ISLESSEQUAL = BuiltinFloatFunctions.of("islessequal");
    private static final ImmutableList<String> ISLESSGREATER = BuiltinFloatFunctions.of("islessgreater");
    private static final ImmutableList<String> ISUNORDERED = BuiltinFloatFunctions.of("isunordered");
    private static final String SIGNBIT_FLOAT = "__signbitf";
    private static final String SIGNBIT = "__signbit";
    private static final String SIGNBIT_LONG_DOUBLE = "__signbitl";
    private static final String COPYSIGN_FLOAT = "copysignf";
    private static final String COPYSIGN = "copysign";
    private static final String COPYSIGN_LONG_DOUBLE = "copysignl";
    private static final String FLOAT_CLASSIFY = "__fpclassify";
    private static final String IS_FINITE = "__finite";
    private static final String IS_NAN = "__isnan";
    private static final String IS_INFINITY = "__isinf";
    private static final ImmutableList<String> possiblePrefixes = ImmutableList.builder().addAll(INFINITY).addAll(HUGE_VAL).addAll(ABSOLUTE_VAL).addAll(CEIL).addAll(FLOOR).addAll(ROUND).addAll(LROUND).addAll(LLROUND).addAll(TRUNC).addAll(FDIM).addAll(FMAX).addAll(FMIN).addAll(FMOD).addAll(MODF).addAll(FREMAINDER).addAll(ISGREATEREQUAL).addAll(ISGREATER).addAll(ISLESSGREATER).addAll(ISLESSEQUAL).addAll(ISLESS).addAll(ISUNORDERED).add((Object)"__fpclassify").add((Object)"copysign").add((Object)"__signbit").add((Object)"__finite").add((Object)"__isnan").add((Object)"__isinf").addAll(NOT_A_NUMBER).build();

    private static ImmutableList<String> of(String suffix) {
        return ImmutableList.of((Object)("__builtin_" + suffix), (Object)suffix);
    }

    public static boolean isBuiltinFloatFunction(String pFunctionName) {
        for (String prefix : possiblePrefixes) {
            if (!BuiltinFloatFunctions.isBuiltinFloatFunctionWithPrefix(pFunctionName, prefix)) continue;
            return true;
        }
        return false;
    }

    private static boolean isBuiltinFloatFunctionWithPrefix(String pFunctionName, Collection<String> pPrefix) {
        return pPrefix.stream().anyMatch(nan -> BuiltinFloatFunctions.isBuiltinFloatFunctionWithPrefix(pFunctionName, nan));
    }

    private static boolean isBuiltinFloatFunctionWithPrefix(String pFunctionName, String pPrefix) {
        int prefixLength;
        int length = pFunctionName.length();
        if (length != (prefixLength = pPrefix.length()) && length != prefixLength + 1) {
            return false;
        }
        if (!pFunctionName.startsWith(pPrefix)) {
            return false;
        }
        String suffix = pFunctionName.substring(prefixLength);
        return suffix.isEmpty() || suffix.equals("f") || suffix.equals("l");
    }

    public static CSimpleType getTypeOfBuiltinFloatFunction(String pFunctionName) {
        for (String p : possiblePrefixes) {
            String suffix;
            if (!pFunctionName.startsWith(p)) continue;
            switch (suffix = pFunctionName.substring(p.length())) {
                case "": {
                    return CNumericTypes.DOUBLE;
                }
                case "f": {
                    return CNumericTypes.FLOAT;
                }
                case "l": {
                    return CNumericTypes.LONG_DOUBLE;
                }
            }
            throw new IllegalArgumentException("Builtin function '" + pFunctionName + "' with unknown suffix '" + suffix + "'");
        }
        throw new IllegalArgumentException("Invalid function name " + pFunctionName);
    }

    public static boolean matchesInfinityFloat(String pFunctionName) {
        return INFINITY_FLOAT.contains((Object)pFunctionName);
    }

    public static boolean matchesInfinityDouble(String pFunctionName) {
        return INFINITY.contains((Object)pFunctionName);
    }

    public static boolean matchesInfinityLongDouble(String pFunctionName) {
        return INFINITY_LONG_DOUBLE.contains((Object)pFunctionName);
    }

    public static boolean matchesInfinity(String pFunctionName) {
        return BuiltinFloatFunctions.isBuiltinFloatFunctionWithPrefix(pFunctionName, INFINITY);
    }

    public static boolean matchesHugeValFloat(String pFunctionName) {
        return HUGE_VAL_FLOAT.contains((Object)pFunctionName);
    }

    public static boolean matchesHugeValDouble(String pFunctionName) {
        return HUGE_VAL.contains((Object)pFunctionName);
    }

    public static boolean matchesHugeValLongDouble(String pFunctionName) {
        return HUGE_VAL_LONG_DOUBLE.contains((Object)pFunctionName);
    }

    public static boolean matchesHugeVal(String pFunctionName) {
        return BuiltinFloatFunctions.isBuiltinFloatFunctionWithPrefix(pFunctionName, HUGE_VAL);
    }

    public static boolean matchesNaNFloat(String pFunctionName) {
        return NOT_A_NUMBER_FLOAT.contains((Object)pFunctionName);
    }

    public static boolean matchesNaNDouble(String pFunctionName) {
        return NOT_A_NUMBER.contains((Object)pFunctionName);
    }

    public static boolean matchesNaNLongDouble(String pFunctionName) {
        return NOT_A_NUMBER_LONG_DOUBLE.contains((Object)pFunctionName);
    }

    public static boolean matchesNaN(String pFunctionName) {
        return BuiltinFloatFunctions.isBuiltinFloatFunctionWithPrefix(pFunctionName, NOT_A_NUMBER);
    }

    public static boolean matchesAbsoluteFloat(String pFunctionName) {
        return ABSOLUTE_VAL_FLOAT.contains((Object)pFunctionName);
    }

    public static boolean matchesAbsoluteDouble(String pFunctionName) {
        return ABSOLUTE_VAL.contains((Object)pFunctionName);
    }

    public static boolean matchesAbsoluteLongDouble(String pFunctionName) {
        return ABSOLUTE_VAL_LONG_DOUBLE.contains((Object)pFunctionName);
    }

    public static boolean matchesCeil(String pFunctionName) {
        return CEIL_FLOAT.contains((Object)pFunctionName) || CEIL.contains((Object)pFunctionName) || CEIL_LONG_DOUBLE.contains((Object)pFunctionName);
    }

    public static boolean matchesFloor(String pFunctionName) {
        return FLOOR_FLOAT.contains((Object)pFunctionName) || FLOOR.contains((Object)pFunctionName) || FLOOR_LONG_DOUBLE.contains((Object)pFunctionName);
    }

    public static boolean matchesRound(String pFunctionName) {
        return ROUND_FLOAT.contains((Object)pFunctionName) || ROUND.contains((Object)pFunctionName) || ROUND_LONG_DOUBLE.contains((Object)pFunctionName);
    }

    public static boolean matchesLround(String pFunctionName) {
        return LROUND_FLOAT.contains((Object)pFunctionName) || LROUND.contains((Object)pFunctionName) || LROUND_LONG_DOUBLE.contains((Object)pFunctionName);
    }

    public static boolean matchesLlround(String pFunctionName) {
        return LLROUND_FLOAT.contains((Object)pFunctionName) || LLROUND.contains((Object)pFunctionName) || LLROUND_LONG_DOUBLE.contains((Object)pFunctionName);
    }

    public static boolean matchesTrunc(String pFunctionName) {
        return TRUNC_FLOAT.contains((Object)pFunctionName) || TRUNC.contains((Object)pFunctionName) || TRUNC_LONG_DOUBLE.contains((Object)pFunctionName);
    }

    public static boolean matchesFdim(String pFunctionName) {
        return FDIM_FLOAT.contains((Object)pFunctionName) || FDIM.contains((Object)pFunctionName) || FDIM_LONG_DOUBLE.contains((Object)pFunctionName);
    }

    public static boolean matchesFmax(String pFunctionName) {
        return FMAX_FLOAT.contains((Object)pFunctionName) || FMAX.contains((Object)pFunctionName) || FMAX_LONG_DOUBLE.contains((Object)pFunctionName);
    }

    public static boolean matchesFmin(String pFunctionName) {
        return FMIN_FLOAT.contains((Object)pFunctionName) || FMIN.contains((Object)pFunctionName) || FMIN_LONG_DOUBLE.contains((Object)pFunctionName);
    }

    public static boolean matchesFmod(String pFunctionName) {
        return FMOD_FLOAT.contains((Object)pFunctionName) || FMOD.contains((Object)pFunctionName) || FMOD_LONG_DOUBLE.contains((Object)pFunctionName);
    }

    public static boolean matchesModf(String pFunctionName) {
        return MODF_FLOAT.contains((Object)pFunctionName) || MODF.contains((Object)pFunctionName) || MODF_LONG_DOUBLE.contains((Object)pFunctionName);
    }

    public static boolean matchesFremainder(String pFunctionName) {
        return FREMAINDER_FLOAT.contains((Object)pFunctionName) || FREMAINDER.contains((Object)pFunctionName) || FREMAINDER_LONG_DOUBLE.contains((Object)pFunctionName);
    }

    public static boolean matchesSignbit(String pFunctionName) {
        return SIGNBIT_FLOAT.equals(pFunctionName) || SIGNBIT.equals(pFunctionName) || SIGNBIT_LONG_DOUBLE.equals(pFunctionName);
    }

    public static boolean matchesCopysign(String pFunctionName) {
        return COPYSIGN_FLOAT.equals(pFunctionName) || COPYSIGN.equals(pFunctionName) || COPYSIGN_LONG_DOUBLE.equals(pFunctionName);
    }

    public static boolean matchesIsgreater(String pFunctionName) {
        return ISGREATER.contains((Object)pFunctionName);
    }

    public static boolean matchesIsgreaterequal(String pFunctionName) {
        return ISGREATEREQUAL.contains((Object)pFunctionName);
    }

    public static boolean matchesIsless(String pFunctionName) {
        return ISLESS.contains((Object)pFunctionName);
    }

    public static boolean matchesIslessequal(String pFunctionName) {
        return ISLESSEQUAL.contains((Object)pFunctionName);
    }

    public static boolean matchesIslessgreater(String pFunctionName) {
        return ISLESSGREATER.contains((Object)pFunctionName);
    }

    public static boolean matchesIsunordered(String pFunctionName) {
        return ISUNORDERED.contains((Object)pFunctionName);
    }

    public static boolean matchesAbsolute(String pFunctionName) {
        return BuiltinFloatFunctions.isBuiltinFloatFunctionWithPrefix(pFunctionName, ABSOLUTE_VAL);
    }

    public static boolean matchesFloatClassify(String pFunctionName) {
        return BuiltinFloatFunctions.isBuiltinFloatFunctionWithPrefix(pFunctionName, FLOAT_CLASSIFY);
    }

    public static boolean matchesFinite(String pFunctionName) {
        return BuiltinFloatFunctions.isBuiltinFloatFunctionWithPrefix(pFunctionName, IS_FINITE);
    }

    public static boolean matchesIsNaN(String pFunctionName) {
        return BuiltinFloatFunctions.isBuiltinFloatFunctionWithPrefix(pFunctionName, IS_NAN);
    }

    public static boolean matchesIsInfinity(String pFunctionName) {
        return BuiltinFloatFunctions.isBuiltinFloatFunctionWithPrefix(pFunctionName, IS_INFINITY);
    }

    public static String getAppropriateTruncName(CType pReturnType) {
        if (pReturnType == CNumericTypes.DOUBLE) {
            return (String)TRUNC.get(1);
        }
        if (pReturnType == CNumericTypes.FLOAT) {
            return (String)TRUNC_FLOAT.get(1);
        }
        if (pReturnType == CNumericTypes.LONG_DOUBLE) {
            return (String)TRUNC_LONG_DOUBLE.get(1);
        }
        throw new AssertionError((Object)("There is no built-in function 'trunc' with the parameter- or return-type " + pReturnType));
    }
}

