/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util;

import java.util.Objects;
import org.sosy_lab.cpachecker.cfa.types.c.CBasicType;
import org.sosy_lab.cpachecker.cfa.types.c.CNumericTypes;
import org.sosy_lab.cpachecker.cfa.types.c.CSimpleType;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.cfa.types.c.CVoidType;
import org.sosy_lab.cpachecker.util.BuiltinFloatFunctions;
import org.sosy_lab.cpachecker.util.BuiltinOverflowFunctions;

public class BuiltinFunctions {
    private static final String FREE = "free";
    private static final String STRLEN = "strlen";
    private static final String POPCOUNT = "popcount";
    private static final CType UNSPECIFIED_TYPE = new CSimpleType(false, false, CBasicType.UNSPECIFIED, false, false, false, false, false, false, false);

    public static boolean isBuiltinFunction(String pFunctionName) {
        return pFunctionName.startsWith("__builtin_") || pFunctionName.startsWith("__atomic_") || pFunctionName.equals(FREE) || BuiltinFunctions.matchesStrlen(pFunctionName) || BuiltinFloatFunctions.isBuiltinFloatFunction(pFunctionName);
    }

    public static CType getFunctionType(String pFunctionName) {
        if (pFunctionName.equals(FREE)) {
            return CVoidType.VOID;
        }
        if (BuiltinFloatFunctions.isBuiltinFloatFunction(pFunctionName)) {
            return BuiltinFloatFunctions.getTypeOfBuiltinFloatFunction(pFunctionName);
        }
        if (BuiltinOverflowFunctions.isBuiltinOverflowFunction(pFunctionName)) {
            return Objects.requireNonNullElse(BuiltinOverflowFunctions.getType(pFunctionName).orElse(null), UNSPECIFIED_TYPE);
        }
        if (BuiltinFunctions.isPopcountFunction(pFunctionName)) {
            return new CSimpleType(false, false, CBasicType.INT, false, false, false, false, false, false, false);
        }
        return UNSPECIFIED_TYPE;
    }

    public static boolean matchesStrlen(String pFunctionName) {
        return pFunctionName.equals(STRLEN);
    }

    public static boolean isPopcountFunction(String pFunctionName) {
        return pFunctionName.contains(POPCOUNT);
    }

    public static CSimpleType getParameterTypeOfBuiltinPopcountFunction(String pFunctionName) {
        if (BuiltinFunctions.isPopcountFunction(pFunctionName)) {
            if (pFunctionName.endsWith("popcountll")) {
                return CNumericTypes.LONG_LONG_INT;
            }
            if (pFunctionName.endsWith("popcountl")) {
                return CNumericTypes.LONG_INT;
            }
            if (pFunctionName.endsWith(POPCOUNT)) {
                return CNumericTypes.INT;
            }
            throw new IllegalArgumentException("Builtin function '" + pFunctionName + "' with unknown suffix '" + pFunctionName.substring(pFunctionName.length()) + "'");
        }
        throw new IllegalArgumentException("Builtin function '" + pFunctionName + "' is not a popcount function'");
    }
}

