/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import java.math.BigInteger;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.log.LogManagerWithoutDuplicates;
import org.sosy_lab.cpachecker.cfa.ast.AIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.FileLocation;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CCastExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpression;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.cfa.types.c.CNumericTypes;
import org.sosy_lab.cpachecker.cfa.types.c.CPointerType;
import org.sosy_lab.cpachecker.cfa.types.c.CSimpleType;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.cpa.value.AbstractExpressionValueVisitor;
import org.sosy_lab.cpachecker.cpa.value.type.NumericValue;
import org.sosy_lab.cpachecker.cpa.value.type.Value;
import org.sosy_lab.cpachecker.exceptions.UnrecognizedCodeException;
import org.sosy_lab.cpachecker.util.OverflowAssumptionManager;

public class BuiltinOverflowFunctions {
    private static final Map<String, BuiltinOverflowFunction> functions = FluentIterable.from((Object[])BuiltinOverflowFunction.values()).uniqueIndex(func -> func.name);

    public static Optional<CSimpleType> getType(String pFunctionName) {
        Preconditions.checkState((boolean)functions.containsKey(pFunctionName));
        return BuiltinOverflowFunctions.functions.get((Object)pFunctionName).type;
    }

    public static CBinaryExpression.BinaryOperator getOperator(String pFunctionName) {
        Preconditions.checkState((boolean)functions.containsKey(pFunctionName));
        return BuiltinOverflowFunctions.functions.get((Object)pFunctionName).operator;
    }

    public static boolean isBuiltinOverflowFunction(String pFunctionName) {
        return functions.containsKey(pFunctionName);
    }

    public static boolean isFunctionWithArbitraryArgumentTypes(String pFunctionName) {
        Preconditions.checkState((boolean)functions.containsKey(pFunctionName));
        return !BuiltinOverflowFunctions.functions.get((Object)pFunctionName).type.isPresent();
    }

    public static boolean isFunctionWithoutSideEffect(String pFunctionName) {
        Preconditions.checkState((boolean)functions.containsKey(pFunctionName));
        return BuiltinOverflowFunctions.functions.get((Object)pFunctionName).hasNoSideEffects;
    }

    public static List<CType> getParameterTypes(String pFunctionName) {
        Preconditions.checkState((boolean)functions.containsKey(pFunctionName));
        Optional<CSimpleType> type = BuiltinOverflowFunctions.functions.get((Object)pFunctionName).type;
        if (type.isPresent()) {
            return ImmutableList.of((Object)type.orElseThrow(), (Object)type.orElseThrow(), (Object)new CPointerType(false, false, type.orElseThrow()));
        }
        return ImmutableList.of();
    }

    public static CExpression handleOverflow(OverflowAssumptionManager ofmgr, CExpression var1, CExpression var2, CExpression var3, String pFunctionName) throws UnrecognizedCodeException {
        Preconditions.checkState((boolean)functions.containsKey(pFunctionName));
        CSimpleType targetType = BuiltinOverflowFunctions.getTargetType(pFunctionName, var3);
        CBinaryExpression.BinaryOperator operator = BuiltinOverflowFunctions.getOperator(pFunctionName);
        CExpression castedVar1 = var1;
        CExpression castedVar2 = var2;
        if (!BuiltinOverflowFunctions.isFunctionWithArbitraryArgumentTypes(pFunctionName)) {
            castedVar1 = new CCastExpression(FileLocation.DUMMY, targetType, var1);
            castedVar2 = new CCastExpression(FileLocation.DUMMY, targetType, var2);
        }
        CExpression result = operator == CBinaryExpression.BinaryOperator.MULTIPLY ? ofmgr.getConjunctionOfMultiplicationAssumptions(castedVar1, castedVar2, targetType, true) : ofmgr.getConjunctionOfAdditiveAssumptions(castedVar1, castedVar2, operator, targetType, true);
        return new CCastExpression(FileLocation.DUMMY, CNumericTypes.BOOL, result);
    }

    public static CExpression handleOverflowSideeffects(OverflowAssumptionManager ofmgr, CExpression var1, CExpression var2, CExpression var3, String pFunctionName) throws UnrecognizedCodeException {
        Preconditions.checkState((boolean)functions.containsKey(pFunctionName));
        CSimpleType targetType = BuiltinOverflowFunctions.getTargetType(pFunctionName, var3);
        CBinaryExpression.BinaryOperator operator = BuiltinOverflowFunctions.getOperator(pFunctionName);
        CCastExpression castedVar1 = new CCastExpression(FileLocation.DUMMY, targetType, var1);
        CCastExpression castedVar2 = new CCastExpression(FileLocation.DUMMY, targetType, var2);
        return ofmgr.getResultOfOperation(castedVar1, castedVar2, operator);
    }

    private static CSimpleType getTargetType(String pFunctionName, CExpression thirdArgument) {
        if (!BuiltinOverflowFunctions.isFunctionWithArbitraryArgumentTypes(pFunctionName)) {
            return BuiltinOverflowFunctions.getType(pFunctionName).orElseThrow();
        }
        CType targetType = thirdArgument.getExpressionType().getCanonicalType();
        if (targetType instanceof CPointerType) {
            targetType = ((CPointerType)targetType).getType();
        }
        return (CSimpleType)targetType;
    }

    public static Value evaluateFunctionCall(CFunctionCallExpression functionCallExpression, AbstractExpressionValueVisitor evv, MachineModel machineModel, LogManagerWithoutDuplicates logger) throws UnrecognizedCodeException {
        List<CExpression> parameters;
        String nameOfCalledFunc;
        CExpression nameExpressionOfCalledFunc = functionCallExpression.getFunctionNameExpression();
        if (nameExpressionOfCalledFunc instanceof AIdExpression && BuiltinOverflowFunctions.isBuiltinOverflowFunction(nameOfCalledFunc = ((CIdExpression)nameExpressionOfCalledFunc).getName()) && (parameters = functionCallExpression.getParameterExpressions()).size() == 3) {
            Value firstParameterValue = evv.evaluate(parameters.get(0), parameters.get(0).getExpressionType());
            Value secondParameterValue = evv.evaluate(parameters.get(1), parameters.get(1).getExpressionType());
            CSimpleType resultType = BuiltinOverflowFunctions.getTargetType(nameOfCalledFunc, parameters.get(2));
            if (resultType.getType().isIntegerType() && firstParameterValue.isExplicitlyKnown() && secondParameterValue.isExplicitlyKnown()) {
                BigInteger resultOfComputation;
                if (!BuiltinOverflowFunctions.isFunctionWithArbitraryArgumentTypes(nameOfCalledFunc)) {
                    firstParameterValue = AbstractExpressionValueVisitor.castCValue(firstParameterValue, resultType, machineModel, logger, functionCallExpression.getFileLocation());
                    secondParameterValue = AbstractExpressionValueVisitor.castCValue(secondParameterValue, resultType, machineModel, logger, functionCallExpression.getFileLocation());
                }
                BigInteger p1 = firstParameterValue.asNumericValue().bigInteger();
                BigInteger p2 = secondParameterValue.asNumericValue().bigInteger();
                CBinaryExpression.BinaryOperator operator = BuiltinOverflowFunctions.getOperator(nameOfCalledFunc);
                switch (operator) {
                    case PLUS: {
                        resultOfComputation = p1.add(p2);
                        break;
                    }
                    case MINUS: {
                        resultOfComputation = p1.subtract(p2);
                        break;
                    }
                    case MULTIPLY: {
                        resultOfComputation = p1.multiply(p2);
                        break;
                    }
                    default: {
                        throw new UnrecognizedCodeException("Can not determine operator of function " + nameOfCalledFunc, null, null);
                    }
                }
                Value resultValue = new NumericValue(resultOfComputation);
                resultValue = AbstractExpressionValueVisitor.castCValue(resultValue, resultType, machineModel, logger, functionCallExpression.getFileLocation());
                if (resultValue.asNumericValue().bigInteger().equals(resultOfComputation)) {
                    return new NumericValue(0);
                }
                return new NumericValue(1);
            }
        }
        return Value.UnknownValue.getInstance();
    }

    private static enum BuiltinOverflowFunction {
        ADD(CBinaryExpression.BinaryOperator.PLUS, null, false),
        ADD_P(CBinaryExpression.BinaryOperator.PLUS, null, true),
        SADD(CBinaryExpression.BinaryOperator.PLUS, CNumericTypes.SIGNED_INT, false),
        SADDL(CBinaryExpression.BinaryOperator.PLUS, CNumericTypes.SIGNED_LONG_INT, false),
        SADDLL(CBinaryExpression.BinaryOperator.PLUS, CNumericTypes.SIGNED_LONG_LONG_INT, false),
        UADD(CBinaryExpression.BinaryOperator.PLUS, CNumericTypes.UNSIGNED_INT, false),
        UADDL(CBinaryExpression.BinaryOperator.PLUS, CNumericTypes.UNSIGNED_LONG_INT, false),
        UADDLL(CBinaryExpression.BinaryOperator.PLUS, CNumericTypes.UNSIGNED_LONG_LONG_INT, false),
        SUB(CBinaryExpression.BinaryOperator.MINUS, null, false),
        SUB_P(CBinaryExpression.BinaryOperator.MINUS, null, true),
        SSUB(CBinaryExpression.BinaryOperator.MINUS, CNumericTypes.SIGNED_INT, false),
        SSUBL(CBinaryExpression.BinaryOperator.MINUS, CNumericTypes.SIGNED_LONG_INT, false),
        SSUBLL(CBinaryExpression.BinaryOperator.MINUS, CNumericTypes.SIGNED_LONG_LONG_INT, false),
        USUB(CBinaryExpression.BinaryOperator.MINUS, CNumericTypes.UNSIGNED_INT, false),
        USUBL(CBinaryExpression.BinaryOperator.MINUS, CNumericTypes.UNSIGNED_LONG_INT, false),
        USUBLL(CBinaryExpression.BinaryOperator.MINUS, CNumericTypes.UNSIGNED_LONG_LONG_INT, false),
        MUL(CBinaryExpression.BinaryOperator.MULTIPLY, null, false),
        MUL_P(CBinaryExpression.BinaryOperator.MULTIPLY, null, true),
        SMUL(CBinaryExpression.BinaryOperator.MULTIPLY, CNumericTypes.SIGNED_INT, false),
        SMULL(CBinaryExpression.BinaryOperator.MULTIPLY, CNumericTypes.SIGNED_LONG_INT, false),
        SMULLL(CBinaryExpression.BinaryOperator.MULTIPLY, CNumericTypes.SIGNED_LONG_LONG_INT, false),
        UMUL(CBinaryExpression.BinaryOperator.MULTIPLY, CNumericTypes.UNSIGNED_INT, false),
        UMULL(CBinaryExpression.BinaryOperator.MULTIPLY, CNumericTypes.UNSIGNED_LONG_INT, false),
        UMULLL(CBinaryExpression.BinaryOperator.MULTIPLY, CNumericTypes.UNSIGNED_LONG_LONG_INT, false);

        public final CBinaryExpression.BinaryOperator operator;
        public final Optional<CSimpleType> type;
        public final Boolean hasNoSideEffects;
        public final String name;

        private BuiltinOverflowFunction(CBinaryExpression.BinaryOperator pOperator, CSimpleType pType, Boolean pHasNoSideEffect) {
            this.operator = pOperator;
            this.type = Optional.ofNullable(pType);
            this.hasNoSideEffects = pHasNoSideEffect;
            StringBuilder sb = new StringBuilder();
            sb.append("__builtin_").append(BuiltinOverflowFunction.getDataTypePrefix(pType)).append(BuiltinOverflowFunction.getOperatorName(pOperator)).append(BuiltinOverflowFunction.getDataTypeSuffix(pType)).append("_overflow").append(pHasNoSideEffect != false ? "_p" : "");
            this.name = sb.toString();
        }

        private static String getOperatorName(CBinaryExpression.BinaryOperator pOperator) {
            if (pOperator == CBinaryExpression.BinaryOperator.PLUS) {
                return "add";
            }
            if (pOperator == CBinaryExpression.BinaryOperator.MINUS) {
                return "sub";
            }
            return "mul";
        }

        private static String getDataTypePrefix(@Nullable CSimpleType pType) {
            if (pType == null) {
                return "";
            }
            if (pType.isSigned()) {
                return "s";
            }
            return "u";
        }

        private static String getDataTypeSuffix(@Nullable CSimpleType pType) {
            if (pType == null) {
                return "";
            }
            if (pType.isLong()) {
                return "l";
            }
            if (pType.isLongLong()) {
                return "ll";
            }
            return "";
        }
    }
}

