/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util;

import org.sosy_lab.cpachecker.cfa.ast.AAssignment;
import org.sosy_lab.cpachecker.cfa.ast.AFunctionCall;
import org.sosy_lab.cpachecker.cfa.ast.AFunctionCallAssignmentStatement;
import org.sosy_lab.cpachecker.cfa.ast.AIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.ALeftHandSide;
import org.sosy_lab.cpachecker.cfa.ast.AVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CAssignment;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCall;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallAssignmentStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializer;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializerExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CRightHandSide;
import org.sosy_lab.cpachecker.cfa.ast.c.CVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.model.ADeclarationEdge;
import org.sosy_lab.cpachecker.cfa.model.AStatementEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.FunctionCallEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CDeclarationEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionCallEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CStatementEdge;
import org.sosy_lab.cpachecker.cfa.types.Type;

public final class CFAEdgeUtils {
    public static Type getLeftHandType(CFAEdge pEdge) {
        if (pEdge instanceof ADeclarationEdge) {
            ADeclarationEdge declarationEdge = (ADeclarationEdge)pEdge;
            if (declarationEdge.getDeclaration() instanceof AVariableDeclaration) {
                AVariableDeclaration variableDeclaration = (AVariableDeclaration)declarationEdge.getDeclaration();
                return variableDeclaration.getType();
            }
        } else {
            ALeftHandSide lhs = CFAEdgeUtils.getLeftHandSide(pEdge);
            if (lhs instanceof AIdExpression) {
                return ((AIdExpression)lhs).getDeclaration().getType();
            }
        }
        return null;
    }

    public static String getLeftHandVariable(CFAEdge pEdge) {
        if (pEdge instanceof ADeclarationEdge) {
            ADeclarationEdge declarationEdge = (ADeclarationEdge)pEdge;
            if (declarationEdge.getDeclaration() instanceof AVariableDeclaration) {
                AVariableDeclaration variableDeclaration = (AVariableDeclaration)declarationEdge.getDeclaration();
                return variableDeclaration.getQualifiedName();
            }
        } else {
            ALeftHandSide lhs = CFAEdgeUtils.getLeftHandSide(pEdge);
            if (lhs instanceof AIdExpression) {
                return ((AIdExpression)lhs).getDeclaration().getQualifiedName();
            }
        }
        return null;
    }

    public static ALeftHandSide getLeftHandSide(CFAEdge pEdge) {
        FunctionCallEdge functionCallEdge;
        AFunctionCall functionCall;
        if (pEdge instanceof AStatementEdge) {
            AStatementEdge statementEdge = (AStatementEdge)pEdge;
            if (statementEdge.getStatement() instanceof AAssignment) {
                AAssignment assignment = (AAssignment)((Object)statementEdge.getStatement());
                return assignment.getLeftHandSide();
            }
        } else if (pEdge instanceof FunctionCallEdge && (functionCall = (functionCallEdge = (FunctionCallEdge)pEdge).getSummaryEdge().getExpression()) instanceof AFunctionCallAssignmentStatement) {
            AFunctionCallAssignmentStatement assignment = (AFunctionCallAssignmentStatement)functionCall;
            return assignment.getLeftHandSide();
        }
        return null;
    }

    public static CRightHandSide getRightHandSide(CFAEdge pEdge) {
        CFunctionCallEdge functionCallEdge;
        CFunctionCall functionCall;
        if (pEdge instanceof CDeclarationEdge) {
            CVariableDeclaration variableDeclaration;
            CInitializer initializer;
            CDeclarationEdge declarationEdge = (CDeclarationEdge)pEdge;
            if (declarationEdge.getDeclaration() instanceof CVariableDeclaration && (initializer = (variableDeclaration = (CVariableDeclaration)declarationEdge.getDeclaration()).getInitializer()) instanceof CInitializerExpression) {
                return ((CInitializerExpression)initializer).getExpression();
            }
        } else if (pEdge instanceof CStatementEdge) {
            CStatementEdge statementEdge = (CStatementEdge)pEdge;
            if (statementEdge.getStatement() instanceof CAssignment) {
                CAssignment assignment = (CAssignment)statementEdge.getStatement();
                return assignment.getRightHandSide();
            }
        } else if (pEdge instanceof CFunctionCallEdge && (functionCall = (functionCallEdge = (CFunctionCallEdge)pEdge).getSummaryEdge().getExpression()) instanceof CFunctionCallAssignmentStatement) {
            CFunctionCallAssignmentStatement assignment = (CFunctionCallAssignmentStatement)functionCall;
            return assignment.getRightHandSide();
        }
        return null;
    }
}

