/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.sosy_lab.cpachecker.cfa.ast.ADeclaration;
import org.sosy_lab.cpachecker.cfa.ast.AParameterDeclaration;
import org.sosy_lab.cpachecker.cfa.model.ADeclarationEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdgeType;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.FunctionCallEdge;
import org.sosy_lab.cpachecker.cfa.model.FunctionReturnEdge;
import org.sosy_lab.cpachecker.cfa.model.FunctionSummaryEdge;
import org.sosy_lab.cpachecker.util.CFAUtils;

public class CFATraversal {
    private static final Function<CFANode, Iterable<CFAEdge>> FORWARD_EDGE_SUPPLIER = CFAUtils::allLeavingEdges;
    private static final Function<CFANode, Iterable<CFAEdge>> BACKWARD_EDGE_SUPPLIER = CFAUtils::allEnteringEdges;
    private final Function<CFANode, Iterable<CFAEdge>> edgeSupplier;
    private final Function<CFAEdge, CFANode> successorSupplier;
    private final Predicate<CFAEdge> ignoreEdge;

    protected CFATraversal(Function<CFANode, Iterable<CFAEdge>> pEdgeSupplier, Function<CFAEdge, CFANode> pSuccessorSupplier, Predicate<CFAEdge> pIgnoreEdge) {
        this.edgeSupplier = pEdgeSupplier;
        this.successorSupplier = pSuccessorSupplier;
        this.ignoreEdge = pIgnoreEdge;
    }

    public static CFATraversal dfs() {
        return new CFATraversal(FORWARD_EDGE_SUPPLIER, CFAEdge::getSuccessor, (Predicate<CFAEdge>)Predicates.alwaysFalse());
    }

    public CFATraversal backwards() {
        if (this.edgeSupplier == FORWARD_EDGE_SUPPLIER) {
            return new CFATraversal(BACKWARD_EDGE_SUPPLIER, CFAEdge::getPredecessor, this.ignoreEdge);
        }
        if (this.edgeSupplier == BACKWARD_EDGE_SUPPLIER) {
            return new CFATraversal(FORWARD_EDGE_SUPPLIER, CFAEdge::getSuccessor, this.ignoreEdge);
        }
        throw new AssertionError();
    }

    public CFATraversal ignoreSummaryEdges() {
        return new CFATraversal(this.edgeSupplier, this.successorSupplier, (Predicate<CFAEdge>)Predicates.or(this.ignoreEdge, (Predicate)Predicates.instanceOf(FunctionSummaryEdge.class)));
    }

    public CFATraversal ignoreFunctionCalls() {
        return new CFATraversal(this.edgeSupplier, this.successorSupplier, (Predicate<CFAEdge>)Predicates.or((Predicate[])new Predicate[]{this.ignoreEdge, Predicates.instanceOf(FunctionCallEdge.class), Predicates.instanceOf(FunctionReturnEdge.class)}));
    }

    public CFATraversal ignoreEdgeType(CFAEdgeType ignoreType) {
        return new CFATraversal(this.edgeSupplier, this.successorSupplier, (Predicate<CFAEdge>)Predicates.or(this.ignoreEdge, edge -> edge.getEdgeType() == ignoreType));
    }

    public void traverse(CFANode startingNode, CFAVisitor visitor) {
        ArrayDeque<CFANode> toProcess = new ArrayDeque<CFANode>();
        toProcess.addLast(startingNode);
        while (!toProcess.isEmpty()) {
            CFANode n = (CFANode)toProcess.removeLast();
            TraversalProcess result = visitor.visitNode(n);
            if (result == TraversalProcess.ABORT) {
                return;
            }
            if (result == TraversalProcess.SKIP) continue;
            for (CFAEdge edge : this.edgeSupplier.apply(n)) {
                if (this.ignoreEdge.apply((Object)edge)) continue;
                result = visitor.visitEdge(edge);
                if (result == TraversalProcess.ABORT) {
                    return;
                }
                if (result == TraversalProcess.SKIP) continue;
                toProcess.addLast(this.successorSupplier.apply(edge));
            }
        }
    }

    public void traverseOnce(CFANode startingNode, CFAVisitor visitor) {
        this.traverse(startingNode, new NodeCollectingCFAVisitor(visitor));
    }

    public Set<CFANode> collectNodesReachableFrom(CFANode startingNode) {
        NodeCollectingCFAVisitor visitor = new NodeCollectingCFAVisitor();
        this.traverse(startingNode, visitor);
        return visitor.getVisitedNodes();
    }

    public Set<CFANode> collectNodesReachableFromTo(CFANode startingNode, CFANode endingNode) {
        NodeCollectingCFAVisitor visitor = new NodeCollectingCFAVisitor();
        visitor.stopVisitingNode = endingNode;
        this.traverse(startingNode, visitor);
        return visitor.getVisitedNodes();
    }

    public static abstract class ForwardingCFAVisitor
    implements CFAVisitor {
        protected final CFAVisitor delegate;

        protected ForwardingCFAVisitor(CFAVisitor pDelegate) {
            this.delegate = pDelegate;
        }

        @Override
        public TraversalProcess visitEdge(CFAEdge pEdge) {
            return this.delegate.visitEdge(pEdge);
        }

        @Override
        public TraversalProcess visitNode(CFANode pNode) {
            return this.delegate.visitNode(pNode);
        }
    }

    public static class DefaultCFAVisitor
    implements CFAVisitor {
        private static final CFAVisitor INSTANCE = new DefaultCFAVisitor();

        @Override
        public TraversalProcess visitEdge(CFAEdge pEdge) {
            return TraversalProcess.CONTINUE;
        }

        @Override
        public TraversalProcess visitNode(CFANode pNode) {
            return TraversalProcess.CONTINUE;
        }
    }

    public static enum TraversalProcess {
        CONTINUE,
        SKIP,
        ABORT;

    }

    public static interface CFAVisitor {
        public TraversalProcess visitEdge(CFAEdge var1);

        public TraversalProcess visitNode(CFANode var1);
    }

    public static class CompositeCFAVisitor
    implements CFAVisitor {
        private final ImmutableList<CFAVisitor> visitors;

        public CompositeCFAVisitor(Iterable<CFAVisitor> pVisitors) {
            this.visitors = ImmutableList.copyOf(pVisitors);
        }

        public CompositeCFAVisitor(CFAVisitor ... pVisitors) {
            this.visitors = ImmutableList.copyOf((Object[])pVisitors);
        }

        @Override
        public TraversalProcess visitEdge(CFAEdge pEdge) {
            TraversalProcess totalResult = TraversalProcess.CONTINUE;
            for (CFAVisitor visitor : this.visitors) {
                TraversalProcess result = visitor.visitEdge(pEdge);
                if (result == TraversalProcess.ABORT) {
                    totalResult = TraversalProcess.ABORT;
                    continue;
                }
                if (result != TraversalProcess.SKIP || totalResult == TraversalProcess.ABORT) continue;
                totalResult = TraversalProcess.SKIP;
            }
            return totalResult;
        }

        @Override
        public TraversalProcess visitNode(CFANode pNode) {
            TraversalProcess totalResult = TraversalProcess.CONTINUE;
            for (CFAVisitor visitor : this.visitors) {
                TraversalProcess result = visitor.visitNode(pNode);
                if (result == TraversalProcess.ABORT) {
                    totalResult = TraversalProcess.ABORT;
                    continue;
                }
                if (result != TraversalProcess.SKIP || totalResult == TraversalProcess.ABORT) continue;
                totalResult = TraversalProcess.SKIP;
            }
            return totalResult;
        }
    }

    public static final class DeclarationCollectingCFAVisitor
    extends ForwardingCFAVisitor {
        private final Map<String, Set<String>> funToVars = new HashMap<String, Set<String>>();

        public DeclarationCollectingCFAVisitor(CFAVisitor pDelegate) {
            super(pDelegate);
        }

        public DeclarationCollectingCFAVisitor() {
            super(new NodeCollectingCFAVisitor());
        }

        @Override
        public TraversalProcess visitEdge(CFAEdge pEdge) {
            String funName = pEdge.getSuccessor().getFunctionName();
            if (pEdge instanceof ADeclarationEdge) {
                ADeclaration decl = ((ADeclarationEdge)pEdge).getDeclaration();
                this.handleDeclaration(decl.isGlobal() ? "" : funName, decl.getOrigName());
            } else if (pEdge instanceof FunctionCallEdge) {
                for (AParameterDeclaration aParameterDeclaration : ((FunctionCallEdge)pEdge).getSuccessor().getFunctionParameters()) {
                    this.handleDeclaration(funName, aParameterDeclaration.getOrigName());
                }
            }
            return super.visitEdge(pEdge);
        }

        private void handleDeclaration(String pFunName, String pVarName) {
            Set<String> vars = this.funToVars.get(pFunName);
            if (vars == null) {
                vars = new HashSet<String>();
                this.funToVars.put(pFunName, vars);
            }
            vars.add(pVarName);
        }

        public Map<String, Set<String>> getVisitedDeclarations() {
            return this.funToVars;
        }
    }

    public static final class EdgeCollectingCFAVisitor
    extends ForwardingCFAVisitor {
        private final List<CFAEdge> visitedEdges = new ArrayList<CFAEdge>();

        public EdgeCollectingCFAVisitor(CFAVisitor pDelegate) {
            super(pDelegate);
        }

        public EdgeCollectingCFAVisitor() {
            super(new NodeCollectingCFAVisitor());
        }

        @Override
        public TraversalProcess visitEdge(CFAEdge pEdge) {
            this.visitedEdges.add(pEdge);
            return super.visitEdge(pEdge);
        }

        public List<CFAEdge> getVisitedEdges() {
            return this.visitedEdges;
        }
    }

    public static final class NodeCollectingCFAVisitor
    extends ForwardingCFAVisitor {
        private final Set<CFANode> visitedNodes = new HashSet<CFANode>();
        private CFANode stopVisitingNode = null;

        public NodeCollectingCFAVisitor(CFAVisitor pDelegate) {
            super(pDelegate);
        }

        public NodeCollectingCFAVisitor() {
            super(DefaultCFAVisitor.INSTANCE);
        }

        @Override
        public TraversalProcess visitNode(CFANode pNode) {
            if (this.visitedNodes.add(pNode) && (this.stopVisitingNode == null || !this.stopVisitingNode.equals(pNode))) {
                return super.visitNode(pNode);
            }
            return TraversalProcess.SKIP;
        }

        public Set<CFANode> getVisitedNodes() {
            return this.visitedNodes;
        }
    }
}

