/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.UnmodifiableIterator;
import com.google.common.graph.Traverser;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.function.Function;
import java.util.regex.Pattern;
import org.sosy_lab.common.Optionals;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.collect.Collections3;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.ast.AArraySubscriptExpression;
import org.sosy_lab.cpachecker.cfa.ast.AAstNode;
import org.sosy_lab.cpachecker.cfa.ast.AAstNodeVisitor;
import org.sosy_lab.cpachecker.cfa.ast.ABinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.ACastExpression;
import org.sosy_lab.cpachecker.cfa.ast.ACharLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.AExpression;
import org.sosy_lab.cpachecker.cfa.ast.AExpressionAssignmentStatement;
import org.sosy_lab.cpachecker.cfa.ast.AExpressionStatement;
import org.sosy_lab.cpachecker.cfa.ast.AFloatLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.AFunctionCallAssignmentStatement;
import org.sosy_lab.cpachecker.cfa.ast.AFunctionCallExpression;
import org.sosy_lab.cpachecker.cfa.ast.AFunctionCallStatement;
import org.sosy_lab.cpachecker.cfa.ast.AFunctionDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.AIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.AInitializerExpression;
import org.sosy_lab.cpachecker.cfa.ast.AIntegerLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.ALeftHandSide;
import org.sosy_lab.cpachecker.cfa.ast.AParameterDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.AReturnStatement;
import org.sosy_lab.cpachecker.cfa.ast.AStringLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.AUnaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.AVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.FileLocation;
import org.sosy_lab.cpachecker.cfa.ast.c.CAddressOfLabelExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CArrayDesignator;
import org.sosy_lab.cpachecker.cfa.ast.c.CArrayRangeDesignator;
import org.sosy_lab.cpachecker.cfa.ast.c.CAstNode;
import org.sosy_lab.cpachecker.cfa.ast.c.CComplexCastExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CComplexTypeDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CDesignatedInitializer;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFieldDesignator;
import org.sosy_lab.cpachecker.cfa.ast.c.CFieldReference;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CImaginaryLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializer;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializerExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializerList;
import org.sosy_lab.cpachecker.cfa.ast.c.CPointerExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CRightHandSide;
import org.sosy_lab.cpachecker.cfa.ast.c.CTypeDefDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CTypeIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.java.JArrayCreationExpression;
import org.sosy_lab.cpachecker.cfa.ast.java.JArrayInitializer;
import org.sosy_lab.cpachecker.cfa.ast.java.JArrayLengthExpression;
import org.sosy_lab.cpachecker.cfa.ast.java.JAstNode;
import org.sosy_lab.cpachecker.cfa.ast.java.JBooleanLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.java.JClassInstanceCreation;
import org.sosy_lab.cpachecker.cfa.ast.java.JClassLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.java.JEnumConstantExpression;
import org.sosy_lab.cpachecker.cfa.ast.java.JNullLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.java.JRunTimeTypeEqualsType;
import org.sosy_lab.cpachecker.cfa.ast.java.JThisExpression;
import org.sosy_lab.cpachecker.cfa.ast.java.JVariableRunTimeType;
import org.sosy_lab.cpachecker.cfa.model.AssumeEdge;
import org.sosy_lab.cpachecker.cfa.model.BlankEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.CFATerminationNode;
import org.sosy_lab.cpachecker.cfa.model.FunctionCallEdge;
import org.sosy_lab.cpachecker.cfa.model.FunctionEntryNode;
import org.sosy_lab.cpachecker.cfa.model.FunctionExitNode;
import org.sosy_lab.cpachecker.cfa.model.FunctionSummaryEdge;
import org.sosy_lab.cpachecker.cfa.types.c.CEnumType;
import org.sosy_lab.cpachecker.exceptions.NoException;
import org.sosy_lab.cpachecker.util.CFATraversal;
import org.sosy_lab.cpachecker.util.LoopStructure;

public class CFAUtils {
    public static final Pattern CFA_NODE_NAME_PATTERN = Pattern.compile("N([0-9][0-9]*)");
    private static final Traverser<AAstNode> AST_LHS_TRAVERSER = Traverser.forTree(node -> (Iterable)node.accept_(LeftHandSideVisitor.INSTANCE));
    private static final Traverser<AAstNode> AST_TRAVERSER = Traverser.forTree(node -> (Iterable)node.accept_(ChildExpressionVisitor.INSTANCE));

    public static FluentIterable<CFAEdge> allEnteringEdges(final CFANode node) {
        Preconditions.checkNotNull((Object)node);
        return new FluentIterable<CFAEdge>(){

            public Iterator<CFAEdge> iterator() {
                return new UnmodifiableIterator<CFAEdge>(){
                    private int i;
                    {
                        this.i = node.getEnteringSummaryEdge() != null ? -1 : 0;
                    }

                    public boolean hasNext() {
                        return this.i < node.getNumEnteringEdges();
                    }

                    public CFAEdge next() {
                        if (this.i == -1) {
                            this.i = 0;
                            return node.getEnteringSummaryEdge();
                        }
                        return node.getEnteringEdge(this.i++);
                    }
                };
            }
        };
    }

    public static FluentIterable<CFAEdge> enteringEdges(final CFANode node) {
        Preconditions.checkNotNull((Object)node);
        return new FluentIterable<CFAEdge>(){

            public Iterator<CFAEdge> iterator() {
                return new UnmodifiableIterator<CFAEdge>(){
                    private int i = 0;

                    public boolean hasNext() {
                        return this.i < node.getNumEnteringEdges();
                    }

                    public CFAEdge next() {
                        return node.getEnteringEdge(this.i++);
                    }
                };
            }
        };
    }

    public static FluentIterable<CFAEdge> allLeavingEdges(final CFANode node) {
        Preconditions.checkNotNull((Object)node);
        return new FluentIterable<CFAEdge>(){

            public Iterator<CFAEdge> iterator() {
                return new UnmodifiableIterator<CFAEdge>(){
                    private int i;
                    {
                        this.i = node.getLeavingSummaryEdge() != null ? -1 : 0;
                    }

                    public boolean hasNext() {
                        return this.i < node.getNumLeavingEdges();
                    }

                    public CFAEdge next() {
                        if (this.i == -1) {
                            this.i = 0;
                            return node.getLeavingSummaryEdge();
                        }
                        return node.getLeavingEdge(this.i++);
                    }
                };
            }
        };
    }

    public static FluentIterable<CFAEdge> leavingEdges(final CFANode node) {
        Preconditions.checkNotNull((Object)node);
        return new FluentIterable<CFAEdge>(){

            public Iterator<CFAEdge> iterator() {
                return new UnmodifiableIterator<CFAEdge>(){
                    private int i = 0;

                    public boolean hasNext() {
                        return this.i < node.getNumLeavingEdges();
                    }

                    public CFAEdge next() {
                        return node.getLeavingEdge(this.i++);
                    }
                };
            }
        };
    }

    public static FluentIterable<CFANode> predecessorsOf(CFANode node) {
        return CFAUtils.enteringEdges(node).transform(CFAEdge::getPredecessor);
    }

    public static FluentIterable<CFANode> allPredecessorsOf(CFANode node) {
        return CFAUtils.allEnteringEdges(node).transform(CFAEdge::getPredecessor);
    }

    public static FluentIterable<CFANode> successorsOf(CFANode node) {
        return CFAUtils.leavingEdges(node).transform(CFAEdge::getSuccessor);
    }

    public static FluentIterable<CFANode> allSuccessorsOf(CFANode node) {
        return CFAUtils.allLeavingEdges(node).transform(CFAEdge::getSuccessor);
    }

    public static AssumeEdge getComplimentaryAssumeEdge(AssumeEdge edge) {
        Preconditions.checkArgument((edge.getPredecessor().getNumLeavingEdges() == 2 ? 1 : 0) != 0);
        return (AssumeEdge)Iterables.getOnlyElement((Iterable)CFAUtils.leavingEdges(edge.getPredecessor()).filter(Predicates.not((Predicate)Predicates.equalTo((Object)edge))));
    }

    public static boolean existsPath(CFANode pSource, CFANode pTarget, Function<CFANode, Iterable<CFAEdge>> pGetLeavingEdges, ShutdownNotifier pShutdownNotifier) throws InterruptedException {
        HashSet<CFANode> visited = new HashSet<CFANode>();
        ArrayDeque<CFANode> waitlist = new ArrayDeque<CFANode>();
        waitlist.offer(pSource);
        while (!waitlist.isEmpty()) {
            pShutdownNotifier.shutdownIfNecessary();
            CFANode current = (CFANode)waitlist.poll();
            if (current.equals(pTarget)) {
                return true;
            }
            if (!visited.add(current)) continue;
            for (CFAEdge leavingEdge : pGetLeavingEdges.apply(current)) {
                CFANode succ = leavingEdge.getSuccessor();
                waitlist.offer(succ);
            }
        }
        return false;
    }

    public static Collection<CFANode> getEndlessLoopHeads(LoopStructure pLoopStructure) {
        ImmutableCollection<LoopStructure.Loop> loops = pLoopStructure.getAllLoops();
        HashSet<CFANode> loopHeads = new HashSet<CFANode>();
        for (LoopStructure.Loop l : loops) {
            if (!l.getOutgoingEdges().isEmpty() && !l.getOutgoingEdges().stream().allMatch(x -> x.getSuccessor() instanceof CFATerminationNode)) continue;
            loopHeads.addAll((Collection<CFANode>)l.getLoopHeads());
        }
        return loopHeads;
    }

    public static Collection<CFANode> getProgramSinks(CFA pCfa, LoopStructure pLoopStructure, FunctionEntryNode pCfaEntryNode) {
        HashSet<CFANode> sinks = new HashSet<CFANode>();
        FunctionExitNode cfaExitNode = pCfaEntryNode.getExitNode();
        if (pCfa.getAllNodes().contains(cfaExitNode)) {
            sinks.add(cfaExitNode);
        }
        sinks.addAll(CFAUtils.getEndlessLoopHeads(pLoopStructure));
        return sinks;
    }

    public static Map<Integer, CFANode> getMappingFromNodeIDsToCFANodes(CFA pCfa) {
        return Maps.uniqueIndex(pCfa.getAllNodes(), CFANode::getNodeNumber);
    }

    static boolean hasBackWardsEdges(CFANode rootNode) {
        FindBackwardsEdgesVisitor visitor = new FindBackwardsEdgesVisitor();
        CFATraversal.dfs().ignoreSummaryEdges().traverseOnce(rootNode, visitor);
        return visitor.hasBackwardsEdges();
    }

    public static NavigableSet<String> filterVariablesOfFunction(NavigableSet<String> variables, String function) {
        String prefix = (String)Preconditions.checkNotNull((Object)function) + "::";
        return Collections3.subSetWithPrefix(variables, (String)prefix);
    }

    public static Iterable<List<CFANode>> getBlankPaths(CFANode pNode) {
        ImmutableList newPath;
        List currentPath;
        ArrayList<List<CFANode>> blankPaths = new ArrayList<List<CFANode>>();
        ArrayDeque<Object> waitlist = new ArrayDeque<Object>();
        waitlist.offer(ImmutableList.of((Object)pNode));
        while (!waitlist.isEmpty()) {
            currentPath = (List)waitlist.poll();
            CFANode pathSucc = (CFANode)currentPath.get(currentPath.size() - 1);
            ImmutableList leavingBlankEdges = CFAUtils.leavingEdges(pathSucc).filter(BlankEdge.class).toList();
            if (pathSucc.getNumLeavingEdges() <= 0 || leavingBlankEdges.size() < pathSucc.getNumLeavingEdges()) {
                blankPaths.add(currentPath);
                continue;
            }
            for (CFAEdge leavingEdge : leavingBlankEdges) {
                CFANode successor = leavingEdge.getSuccessor();
                if (currentPath.contains(successor)) continue;
                newPath = ImmutableList.builder().addAll((Iterable)currentPath).add((Object)successor).build();
                waitlist.offer(newPath);
            }
        }
        waitlist.addAll(blankPaths);
        blankPaths.clear();
        while (!waitlist.isEmpty()) {
            currentPath = (List)waitlist.poll();
            CFANode pathPred = (CFANode)currentPath.get(0);
            ImmutableList enteringBlankEdges = CFAUtils.enteringEdges(pathPred).filter(BlankEdge.class).toList();
            if (pathPred.getNumEnteringEdges() <= 0 || enteringBlankEdges.size() < pathPred.getNumEnteringEdges()) {
                blankPaths.add(currentPath);
                continue;
            }
            for (CFAEdge enteringEdge : enteringBlankEdges) {
                CFANode predecessor = enteringEdge.getPredecessor();
                if (currentPath.contains(predecessor)) continue;
                newPath = ImmutableList.builder().add((Object)predecessor).addAll((Iterable)currentPath).build();
                waitlist.offer(newPath);
            }
        }
        return blankPaths;
    }

    public static ImmutableSet<FileLocation> getFileLocationsFromCfaEdge(CFAEdge pEdge) {
        FunctionEntryNode functionEntryNode;
        ImmutableSet result = FluentIterable.from(CFAUtils.getAstNodesFromCfaEdge(pEdge)).transformAndConcat(node -> CFAUtils.traverseRecursively(node)).transform(AAstNode::getFileLocation).append((Object[])new FileLocation[]{pEdge.getFileLocation()}).filter(FileLocation::isRealLocation).toSet();
        if (result.isEmpty() && pEdge.getPredecessor() instanceof FunctionEntryNode && (functionEntryNode = (FunctionEntryNode)pEdge.getPredecessor()).getFileLocation().isRealLocation()) {
            return ImmutableSet.of((Object)functionEntryNode.getFileLocation());
        }
        return result;
    }

    public static Iterable<AAstNode> getAstNodesFromCfaEdge(CFAEdge edge) {
        switch (edge.getEdgeType()) {
            case CallToReturnEdge: {
                FunctionSummaryEdge fnSumEdge = (FunctionSummaryEdge)edge;
                return ImmutableSet.of((Object)fnSumEdge.getExpression());
            }
            case FunctionCallEdge: {
                FunctionCallEdge functionCallEdge = (FunctionCallEdge)edge;
                return Iterables.concat((Iterable)Optionals.asSet(edge.getRawAST()), CFAUtils.getAstNodesFromCfaEdge(functionCallEdge.getSummaryEdge()));
            }
        }
        return Optionals.asSet(edge.getRawAST());
    }

    public static FluentIterable<String> getVariableNamesOfExpression(CExpression expr) {
        return CFAUtils.getIdExpressionsOfExpression(expr).transform(id -> id.getDeclaration().getQualifiedName());
    }

    public static FluentIterable<CIdExpression> getIdExpressionsOfExpression(CExpression expr) {
        return CFAUtils.traverseRecursively(expr).filter(CIdExpression.class);
    }

    public static FluentIterable<AAstNode> traverseRecursively(AAstNode root) {
        return FluentIterable.from((Iterable)AST_TRAVERSER.depthFirstPreOrder((Object)root));
    }

    public static FluentIterable<CAstNode> traverseRecursively(CAstNode root) {
        return FluentIterable.from((Iterable)AST_TRAVERSER.depthFirstPreOrder((Object)root));
    }

    public static FluentIterable<JAstNode> traverseRecursively(JAstNode root) {
        return FluentIterable.from((Iterable)AST_TRAVERSER.depthFirstPreOrder((Object)root));
    }

    public static FluentIterable<CRightHandSide> traverseRecursively(CRightHandSide root) {
        return FluentIterable.from((Iterable)AST_TRAVERSER.depthFirstPreOrder((Object)root));
    }

    public static FluentIterable<CExpression> traverseRecursively(CExpression root) {
        return FluentIterable.from((Iterable)AST_TRAVERSER.depthFirstPreOrder((Object)root));
    }

    public static FluentIterable<AExpression> traverseLeftHandSideRecursively(ALeftHandSide root) {
        return FluentIterable.from((Iterable)AST_LHS_TRAVERSER.depthFirstPreOrder((Object)root));
    }

    private static class ChildExpressionVisitor
    extends AAstNodeVisitor<Iterable<? extends AAstNode>, NoException> {
        private static final ChildExpressionVisitor INSTANCE = new ChildExpressionVisitor();

        private ChildExpressionVisitor() {
        }

        @Override
        public Iterable<AAstNode> visit(AArraySubscriptExpression pE) {
            return ImmutableList.of((Object)pE.getArrayExpression(), (Object)pE.getSubscriptExpression());
        }

        @Override
        public Iterable<AAstNode> visit(ABinaryExpression pE) {
            return ImmutableList.of((Object)pE.getOperand1(), (Object)pE.getOperand2());
        }

        @Override
        public Iterable<AAstNode> visit(ACastExpression pE) {
            return ImmutableList.of((Object)pE.getOperand());
        }

        @Override
        public Iterable<CAstNode> visit(CComplexCastExpression pE) {
            return ImmutableList.of((Object)pE.getOperand());
        }

        @Override
        public Iterable<CAstNode> visit(CFieldReference pE) {
            return ImmutableList.of((Object)pE.getFieldOwner());
        }

        @Override
        public Iterable<CAstNode> visit(CPointerExpression pE) {
            return ImmutableList.of((Object)pE.getOperand());
        }

        @Override
        public Iterable<AAstNode> visit(AUnaryExpression pE) {
            return ImmutableList.of((Object)pE.getOperand());
        }

        @Override
        protected Iterable<? extends AAstNode> visit(AInitializerExpression pExp) {
            return ImmutableList.of((Object)pExp.getExpression());
        }

        @Override
        public Iterable<AAstNode> visit(AIdExpression pExp) {
            return ImmutableList.of();
        }

        @Override
        public Iterable<AAstNode> visit(ACharLiteralExpression pExp) {
            return ImmutableList.of();
        }

        @Override
        public Iterable<AAstNode> visit(AFloatLiteralExpression pExp) {
            return ImmutableList.of();
        }

        @Override
        public Iterable<AAstNode> visit(AIntegerLiteralExpression pExp) {
            return ImmutableList.of();
        }

        @Override
        public Iterable<AAstNode> visit(AStringLiteralExpression pExp) {
            return ImmutableList.of();
        }

        @Override
        public Iterable<AAstNode> visit(AFunctionCallExpression pE) {
            return Iterables.concat((Iterable)ImmutableList.of((Object)pE.getFunctionNameExpression()), pE.getParameterExpressions());
        }

        @Override
        public Iterable<AAstNode> visit(AExpressionAssignmentStatement pS) {
            return ImmutableList.of((Object)pS.getLeftHandSide(), (Object)pS.getRightHandSide());
        }

        @Override
        public Iterable<AAstNode> visit(AExpressionStatement pS) {
            return ImmutableList.of((Object)pS.getExpression());
        }

        @Override
        public Iterable<AAstNode> visit(AFunctionCallAssignmentStatement pS) {
            return ImmutableList.of((Object)pS.getLeftHandSide(), (Object)pS.getRightHandSide());
        }

        @Override
        public Iterable<AAstNode> visit(AFunctionCallStatement pS) {
            return ImmutableList.of((Object)pS.getFunctionCallExpression());
        }

        @Override
        public Iterable<? extends AAstNode> visit(AReturnStatement pNode) {
            return Optionals.asSet(pNode.getReturnValue());
        }

        @Override
        public Iterable<CAstNode> visit(CComplexTypeDeclaration pNode) {
            return ImmutableList.of();
        }

        @Override
        public Iterable<? extends CAstNode> visit(CEnumType.CEnumerator pNode) {
            return ImmutableList.of();
        }

        @Override
        public Iterable<? extends AAstNode> visit(AFunctionDeclaration pNode) {
            return pNode.getParameters();
        }

        @Override
        public Iterable<CAstNode> visit(AParameterDeclaration pNode) {
            return ImmutableList.of();
        }

        @Override
        public Iterable<AAstNode> visit(AVariableDeclaration pNode) {
            return pNode.getInitializer() == null ? ImmutableList.of() : ImmutableList.of((Object)pNode.getInitializer());
        }

        @Override
        public Iterable<CAstNode> visit(CTypeDefDeclaration pNode) {
            return ImmutableList.of();
        }

        @Override
        public Iterable<CAstNode> visit(CDesignatedInitializer pNode) {
            return Iterables.concat(pNode.getDesignators(), (Iterable)ImmutableList.of((Object)pNode.getRightHandSide()));
        }

        @Override
        public Iterable<CAstNode> visit(CInitializerExpression pNode) {
            return ImmutableList.of((Object)pNode.getExpression());
        }

        @Override
        public Iterable<CInitializer> visit(CInitializerList pNode) {
            return pNode.getInitializers();
        }

        @Override
        public Iterable<CAstNode> visit(CArrayDesignator pNode) {
            return ImmutableList.of((Object)pNode.getSubscriptExpression());
        }

        @Override
        public Iterable<CAstNode> visit(CArrayRangeDesignator pNode) {
            return ImmutableList.of((Object)pNode.getFloorExpression(), (Object)pNode.getCeilExpression());
        }

        @Override
        public Iterable<CAstNode> visit(CFieldDesignator pNode) {
            return ImmutableList.of();
        }

        @Override
        public Iterable<AAstNode> visit(CTypeIdExpression pExp) {
            return ImmutableList.of();
        }

        @Override
        public Iterable<AAstNode> visit(CImaginaryLiteralExpression pExp) {
            return ImmutableList.of();
        }

        @Override
        public Iterable<AAstNode> visit(CAddressOfLabelExpression pExp) {
            return ImmutableList.of();
        }

        @Override
        public Iterable<AAstNode> visit(JClassInstanceCreation pExp) {
            return ImmutableList.of((Object)pExp.getFunctionNameExpression());
        }

        @Override
        public Iterable<AAstNode> visit(JBooleanLiteralExpression pExp) {
            return ImmutableList.of();
        }

        @Override
        public Iterable<AAstNode> visit(JArrayCreationExpression pExp) {
            if (pExp.getInitializer() == null) {
                return ImmutableList.copyOf(pExp.getLength());
            }
            return Iterables.concat(pExp.getLength(), (Iterable)ImmutableList.of((Object)pExp.getInitializer()));
        }

        @Override
        public Iterable<? extends AAstNode> visit(JArrayInitializer pNode) {
            return pNode.getInitializerExpressions();
        }

        @Override
        public Iterable<AAstNode> visit(JArrayLengthExpression pExp) {
            return ImmutableList.of((Object)pExp.getQualifier());
        }

        @Override
        public Iterable<AAstNode> visit(JVariableRunTimeType pExp) {
            return ImmutableList.of((Object)pExp.getReferencedVariable());
        }

        @Override
        public Iterable<AAstNode> visit(JRunTimeTypeEqualsType pExp) {
            return ImmutableList.of((Object)pExp.getRunTimeTypeExpression());
        }

        @Override
        public Iterable<AAstNode> visit(JNullLiteralExpression pExp) {
            return ImmutableList.of();
        }

        @Override
        public Iterable<AAstNode> visit(JEnumConstantExpression pExp) {
            return ImmutableList.of();
        }

        @Override
        public Iterable<AAstNode> visit(JThisExpression pExp) {
            return ImmutableList.of();
        }

        @Override
        public Iterable<? extends AAstNode> visit(JClassLiteralExpression pJClassLiteralExpression) throws NoException {
            return ImmutableList.of();
        }
    }

    private static final class LeftHandSideVisitor
    extends ChildExpressionVisitor {
        private static final LeftHandSideVisitor INSTANCE = new LeftHandSideVisitor();

        private LeftHandSideVisitor() {
        }

        @Override
        public Iterable<AAstNode> visit(AArraySubscriptExpression pE) {
            return ImmutableList.of((Object)pE.getArrayExpression());
        }
    }

    private static class FindBackwardsEdgesVisitor
    extends CFATraversal.DefaultCFAVisitor {
        private boolean hasBackwardsEdges = false;

        private FindBackwardsEdgesVisitor() {
        }

        @Override
        public CFATraversal.TraversalProcess visitNode(CFANode pNode) {
            if (pNode.getNumLeavingEdges() == 0) {
                return CFATraversal.TraversalProcess.CONTINUE;
            }
            if (pNode.getNumLeavingEdges() == 1 && pNode.getLeavingEdge(0).getSuccessor().getReversePostorderId() >= pNode.getReversePostorderId()) {
                this.hasBackwardsEdges = true;
                return CFATraversal.TraversalProcess.ABORT;
            }
            if (pNode.getNumLeavingEdges() == 2 && (pNode.getLeavingEdge(0).getSuccessor().getReversePostorderId() >= pNode.getReversePostorderId() || pNode.getLeavingEdge(1).getSuccessor().getReversePostorderId() >= pNode.getReversePostorderId())) {
                this.hasBackwardsEdges = true;
                return CFATraversal.TraversalProcess.ABORT;
            }
            if (pNode.getNumLeavingEdges() > 2) {
                throw new AssertionError((Object)"forgotten case in traversing cfa with more than 2 leaving edges");
            }
            return CFATraversal.TraversalProcess.CONTINUE;
        }

        public boolean hasBackwardsEdges() {
            return this.hasBackwardsEdges;
        }
    }
}

