/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util;

import com.google.common.base.Throwables;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.graph.Traverser;
import java.util.logging.Level;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.WrapperCPA;

public class CPAs {
    private CPAs() {
    }

    public static <T extends ConfigurableProgramAnalysis> @Nullable T retrieveCPA(ConfigurableProgramAnalysis cpa, Class<T> cls) {
        if (cls.isInstance(cpa)) {
            return (T)((ConfigurableProgramAnalysis)cls.cast(cpa));
        }
        if (cpa instanceof WrapperCPA) {
            return ((WrapperCPA)((Object)cpa)).retrieveWrappedCpa(cls);
        }
        return null;
    }

    public static <T extends ConfigurableProgramAnalysis, C> @NonNull T retrieveCPAOrFail(ConfigurableProgramAnalysis cpa, Class<T> cls, Class<C> callee) throws InvalidConfigurationException {
        T result = CPAs.retrieveCPA(cpa, cls);
        if (result == null) {
            throw new InvalidConfigurationException(callee.getSimpleName() + " needs a " + cls.getSimpleName());
        }
        return result;
    }

    public static FluentIterable<ConfigurableProgramAnalysis> asIterable(ConfigurableProgramAnalysis pCpa) {
        return FluentIterable.from((Iterable)Traverser.forTree(cpa -> cpa instanceof WrapperCPA ? ((WrapperCPA)((Object)cpa)).getWrappedCPAs() : ImmutableList.of()).depthFirstPreOrder((Object)pCpa));
    }

    public static void closeCpaIfPossible(ConfigurableProgramAnalysis cpa, LogManager logger) {
        for (ConfigurableProgramAnalysis currentCpa : CPAs.asIterable(cpa)) {
            CPAs.closeIfPossible(currentCpa, logger);
        }
    }

    public static void closeIfPossible(Object obj, LogManager logger) {
        if (obj instanceof AutoCloseable) {
            try {
                ((AutoCloseable)obj).close();
            }
            catch (Exception e) {
                Throwables.throwIfUnchecked((Throwable)e);
                logger.logUserException(Level.WARNING, (Throwable)e, "Failed to close " + obj.getClass().getSimpleName());
            }
        }
    }
}

