/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util;

import com.google.common.base.Function;
import com.google.common.base.Predicates;
import com.google.common.base.Splitter;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.math.BigInteger;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import org.sosy_lab.common.collect.Collections3;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CParser;
import org.sosy_lab.cpachecker.cfa.CProgramScope;
import org.sosy_lab.cpachecker.cfa.CSourceOriginMapping;
import org.sosy_lab.cpachecker.cfa.ParseResult;
import org.sosy_lab.cpachecker.cfa.ast.AExpression;
import org.sosy_lab.cpachecker.cfa.ast.AExpressionAssignmentStatement;
import org.sosy_lab.cpachecker.cfa.ast.AIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.AIntegerLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.ALeftHandSide;
import org.sosy_lab.cpachecker.cfa.ast.AStatement;
import org.sosy_lab.cpachecker.cfa.ast.FileLocation;
import org.sosy_lab.cpachecker.cfa.ast.c.CAssignment;
import org.sosy_lab.cpachecker.cfa.ast.c.CAstNode;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpressionBuilder;
import org.sosy_lab.cpachecker.cfa.ast.c.CCastExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpressionAssignmentStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpressionStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCall;
import org.sosy_lab.cpachecker.cfa.ast.c.CIntegerLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CLeftHandSide;
import org.sosy_lab.cpachecker.cfa.ast.c.CSimpleDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CUnaryExpression;
import org.sosy_lab.cpachecker.cfa.model.AReturnStatementEdge;
import org.sosy_lab.cpachecker.cfa.model.AStatementEdge;
import org.sosy_lab.cpachecker.cfa.model.AssumeEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.FunctionEntryNode;
import org.sosy_lab.cpachecker.cfa.parser.Scope;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.cfa.types.c.CBasicType;
import org.sosy_lab.cpachecker.cfa.types.c.CNumericTypes;
import org.sosy_lab.cpachecker.cfa.types.c.CSimpleType;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.cpa.automaton.InvalidAutomatonException;
import org.sosy_lab.cpachecker.exceptions.CParserException;
import org.sosy_lab.cpachecker.exceptions.ParserException;
import org.sosy_lab.cpachecker.util.CFAUtils;
import org.sosy_lab.cpachecker.util.expressions.And;
import org.sosy_lab.cpachecker.util.expressions.ExpressionTree;
import org.sosy_lab.cpachecker.util.expressions.ExpressionTreeFactory;
import org.sosy_lab.cpachecker.util.expressions.ExpressionTrees;
import org.sosy_lab.cpachecker.util.expressions.LeafExpression;
import org.sosy_lab.cpachecker.util.expressions.Simplifier;

public class CParserUtils {
    private static final String CPACHECKER_TMP_PREFIX = "__CPAchecker_TMP";

    public static CStatement parseSingleStatement(String pSource, CParser parser, Scope scope) throws InvalidAutomatonException, InterruptedException {
        return CParserUtils.parse(CParserUtils.addFunctionDeclaration(pSource), parser, scope);
    }

    public static List<CStatement> parseListOfStatements(String pSource, CParser parser, Scope scope) throws InvalidAutomatonException, InterruptedException {
        return CParserUtils.parseBlockOfStatements(CParserUtils.addFunctionDeclaration(pSource), parser, scope);
    }

    public static List<AExpression> convertStatementsToAssumptions(Iterable<CStatement> assumptions, MachineModel machineModel, LogManager logger) throws InvalidAutomatonException {
        ImmutableList.Builder result = ImmutableList.builder();
        CBinaryExpressionBuilder expressionBuilder = new CBinaryExpressionBuilder(machineModel, logger);
        for (CStatement statement : assumptions) {
            if (statement instanceof CAssignment) {
                CAssignment assignment = (CAssignment)statement;
                if (assignment.getRightHandSide() instanceof CExpression) {
                    CExpression expression = (CExpression)assignment.getRightHandSide();
                    CBinaryExpression assumeExp = expressionBuilder.buildBinaryExpressionUnchecked(assignment.getLeftHandSide(), expression, CBinaryExpression.BinaryOperator.EQUALS);
                    result.add((Object)assumeExp);
                    continue;
                }
                if (!(assignment.getRightHandSide() instanceof CFunctionCall)) continue;
                throw new InvalidAutomatonException("Function call '" + assignment.getRightHandSide().toASTString() + "' is not supported in automaton assumption");
            }
            if (statement instanceof CExpressionStatement) {
                result.add((Object)((CExpressionStatement)statement).getExpression());
                continue;
            }
            throw new InvalidAutomatonException("Statement '" + statement.toASTString() + "' is not supported in automaton assumption");
        }
        return result.build();
    }

    private static String addFunctionDeclaration(String pBody) {
        if (pBody.trim().endsWith(";")) {
            return "void test() { " + pBody + "}";
        }
        return "void test() { " + pBody + ";}";
    }

    private static CStatement parse(String code, CParser parser, Scope scope) throws InvalidAutomatonException, InterruptedException {
        try {
            CAstNode statement = parser.parseSingleStatement(code, scope);
            if (!(statement instanceof CStatement)) {
                throw new InvalidAutomatonException("Not a valid statement: " + statement.toASTString());
            }
            return (CStatement)statement;
        }
        catch (ParserException e) {
            throw new InvalidAutomatonException("Error during parsing C code \"" + code + "\": " + e.getMessage());
        }
    }

    private static List<CStatement> parseBlockOfStatements(String code, CParser parser, Scope scope) throws InvalidAutomatonException, InterruptedException {
        List<CAstNode> statements;
        try {
            statements = parser.parseStatements(code, scope);
        }
        catch (CParserException e) {
            throw new InvalidAutomatonException("Code cannot be parsed: <" + code + ">", e);
        }
        for (CAstNode statement2 : statements) {
            if (statement2 instanceof CStatement) continue;
            throw new InvalidAutomatonException("Code in assumption: <" + statement2.toASTString() + "> is not a valid assumption.");
        }
        return Collections3.transformedImmutableListCopy(statements, statement -> (CStatement)statement);
    }

    public static Collection<CStatement> parseStatements(Set<String> pStatements, Optional<String> pResultFunction, CParser pCParser, Scope pScope, ParserTools pParserTools) throws InvalidAutomatonException, InterruptedException {
        if (!pStatements.isEmpty()) {
            HashSet<CStatement> result = new HashSet<CStatement>();
            for (String assumeCode : pStatements) {
                Collection<CStatement> statements = CParserUtils.parseAsCStatements(assumeCode, pResultFunction, pCParser, pScope, pParserTools);
                result.addAll(CParserUtils.removeDuplicates((Iterable<? extends CStatement>)FluentIterable.from(statements).transform(CParserUtils::adjustCharAssignmentSignedness)));
            }
            return result;
        }
        return ImmutableSet.of();
    }

    private static Collection<CStatement> parseAsCStatements(String pCode, Optional<String> pResultFunction, CParser pCParser, Scope pScope, ParserTools pParserTools) throws InvalidAutomatonException, InterruptedException {
        HashSet<CStatement> result = new HashSet<CStatement>();
        boolean fallBack = false;
        ExpressionTree<AExpression> tree = CParserUtils.parseStatement(pCode, pResultFunction, pCParser, pScope, pParserTools);
        if (!tree.equals(ExpressionTrees.getTrue())) {
            if (tree.equals(ExpressionTrees.getFalse())) {
                return ImmutableSet.of((Object)new CExpressionStatement(FileLocation.DUMMY, new CIntegerLiteralExpression(FileLocation.DUMMY, CNumericTypes.INT, BigInteger.ZERO)));
            }
            if (tree instanceof LeafExpression) {
                LeafExpression leaf = (LeafExpression)tree;
                AExpression expression = (AExpression)leaf.getExpression();
                if (expression instanceof CExpression) {
                    result.add(new CExpressionStatement(FileLocation.DUMMY, (CExpression)expression));
                } else {
                    fallBack = true;
                }
            } else if (ExpressionTrees.isAnd(tree)) {
                for (ExpressionTree child : ExpressionTrees.getChildren(tree)) {
                    if (child instanceof LeafExpression) {
                        AExpression expression = (AExpression)((LeafExpression)child).getExpression();
                        if (expression instanceof CExpression) {
                            result.add(new CExpressionStatement(FileLocation.DUMMY, (CExpression)expression));
                            continue;
                        }
                        fallBack = true;
                        continue;
                    }
                    fallBack = true;
                }
            } else {
                fallBack = true;
            }
        }
        if (fallBack) {
            String code = CParserUtils.tryFixACSL(CParserUtils.tryFixArrayInitializers(pCode), pResultFunction, pScope);
            return CParserUtils.parseListOfStatements(code, pCParser, pScope);
        }
        return result;
    }

    public static ExpressionTree<AExpression> parseStatementsAsExpressionTree(Set<String> pStatements, Optional<String> pResultFunction, CParser pCParser, Scope pScope, ParserTools pParserTools) throws InterruptedException {
        ExpressionTree<AExpression> result = ExpressionTrees.getTrue();
        for (String assumeCode : pStatements) {
            try {
                ExpressionTree<AExpression> expressionTree = CParserUtils.parseStatement(assumeCode, pResultFunction, pCParser, pScope, pParserTools);
                result = And.of(result, expressionTree);
            }
            catch (InvalidAutomatonException e) {
                pParserTools.logger.log(Level.WARNING, new Object[]{"Cannot interpret code as C statement(s): <" + assumeCode + ">"});
            }
        }
        return result;
    }

    private static ExpressionTree<AExpression> parseStatement(String pAssumeCode, Optional<String> pResultFunction, CParser pCParser, Scope pScope, ParserTools pParserTools) throws InvalidAutomatonException, InterruptedException {
        String assumeCode = CParserUtils.tryFixArrayInitializers(pAssumeCode);
        Collection<CStatement> statements = null;
        try {
            statements = CParserUtils.parseListOfStatements(assumeCode, pCParser, pScope);
        }
        catch (RuntimeException e) {
            if (e.getMessage() != null && e.getMessage().contains("Syntax error:")) {
                statements = CParserUtils.parseListOfStatements(CParserUtils.tryFixACSL(assumeCode, pResultFunction, pScope), pCParser, pScope);
            }
            throw e;
        }
        catch (InvalidAutomatonException e) {
            statements = CParserUtils.parseListOfStatements(CParserUtils.tryFixACSL(assumeCode, pResultFunction, pScope), pCParser, pScope);
        }
        statements = CParserUtils.removeDuplicates((Iterable<? extends CStatement>)FluentIterable.from(statements).transform(CParserUtils::adjustCharAssignmentSignedness));
        CBinaryExpressionBuilder binaryExpressionBuilder = new CBinaryExpressionBuilder(pParserTools.machineModel, pParserTools.logger);
        Function fromStatement = pStatement -> LeafExpression.fromStatement(pStatement, binaryExpressionBuilder);
        if (!FluentIterable.from(statements).anyMatch(statement -> statement.toString().toUpperCase().contains("__CPACHECKER_TMP"))) {
            return And.of(FluentIterable.from(statements).transform(fromStatement));
        }
        ExpressionTree<Object> result = ExpressionTrees.getTrue();
        try {
            result = CParserUtils.parseExpression(pAssumeCode, pResultFunction, pScope, pCParser, pParserTools);
        }
        catch (InvalidAutomatonException e) {
            Splitter semicolonSplitter = Splitter.on((char)';').omitEmptyStrings().trimResults();
            List clausesStrings = semicolonSplitter.splitToList((CharSequence)pAssumeCode);
            if (clausesStrings.isEmpty()) {
                throw e;
            }
            ArrayList clauses = new ArrayList(clausesStrings.size());
            for (String statement2 : clausesStrings) {
                clauses.add(CParserUtils.parseExpression(statement2, pResultFunction, pScope, pCParser, pParserTools));
            }
            result = And.of(clauses);
        }
        return result;
    }

    private static String tryFixACSL(String pAssumeCode, Optional<String> pResultFunction, Scope pScope) {
        String assumeCode = pAssumeCode.trim();
        if (assumeCode.endsWith(";")) {
            assumeCode = assumeCode.substring(0, assumeCode.length() - 1);
        }
        assumeCode = CParserUtils.replaceResultVar(pResultFunction, pScope, assumeCode);
        Splitter splitter = Splitter.on((String)"==>").limit(2);
        while (assumeCode.contains("==>")) {
            Iterator partIterator = splitter.split((CharSequence)assumeCode).iterator();
            assumeCode = String.format("!(%s) || (%s)", ((String)partIterator.next()).trim(), ((String)partIterator.next()).trim());
        }
        return assumeCode;
    }

    private static String replaceResultVar(Optional<String> pResultFunction, Scope pScope, String assumeCode) {
        if (pResultFunction.isPresent()) {
            CProgramScope scope;
            String resultFunctionName = pResultFunction.orElseThrow();
            if (pScope instanceof CProgramScope && (scope = (CProgramScope)pScope).hasFunctionReturnVariable(resultFunctionName)) {
                CSimpleDeclaration functionReturnVariable = scope.getFunctionReturnVariable(resultFunctionName);
                return assumeCode.replace("\\result", " " + functionReturnVariable.getName());
            }
            return assumeCode.replace("\\result", String.format(" %s() ", resultFunctionName));
        }
        return assumeCode.replace("\\result", " __CPAchecker_ACSL_result() ");
    }

    private static ExpressionTree<AExpression> parseExpression(String pAssumeCode, Optional<String> pResultFunction, Scope pScope, CParser pCParser, ParserTools pParserTools) throws InvalidAutomatonException, InterruptedException {
        ParseResult parseResult;
        String assumeCode = pAssumeCode.trim();
        while (assumeCode.endsWith(";")) {
            assumeCode = assumeCode.substring(0, assumeCode.length() - 1).trim();
        }
        String formatString = "int test() { if (%s) { return 1; } else { return 0; } ; }";
        String testCode = String.format(formatString, assumeCode);
        try {
            parseResult = pCParser.parseString(Path.of("#expr#", new String[0]), testCode, new CSourceOriginMapping(), pScope);
        }
        catch (CParserException e) {
            assumeCode = CParserUtils.tryFixACSL(assumeCode, pResultFunction, pScope);
            testCode = String.format(formatString, assumeCode);
            try {
                parseResult = pCParser.parseString(Path.of("#expr#", new String[0]), testCode, new CSourceOriginMapping(), pScope);
            }
            catch (CParserException e2) {
                throw new InvalidAutomatonException("Cannot interpret code as C expression: <" + pAssumeCode + ">", e);
            }
        }
        FunctionEntryNode entryNode = (FunctionEntryNode)parseResult.getFunctions().values().iterator().next();
        return CParserUtils.asExpressionTree(entryNode, pParserTools);
    }

    private static ExpressionTree<AExpression> asExpressionTree(FunctionEntryNode pEntry, ParserTools pParserTools) {
        ExpressionTreeFactory<AExpression> factory = pParserTools.expressionTreeFactory;
        HashMap memo = new HashMap();
        memo.put(pEntry, ExpressionTrees.getTrue());
        HashSet<CFANode> ready = new HashSet<CFANode>();
        ready.add(pEntry);
        ArrayDeque<CFANode> waitlist = new ArrayDeque<CFANode>();
        waitlist.offer(pEntry);
        while (!waitlist.isEmpty()) {
            CFANode current = (CFANode)waitlist.poll();
            ExpressionTree<AExpression> currentTree = (ExpressionTree<AExpression>)memo.get(current);
            for (CFAEdge leavingEdge : CFAUtils.leavingEdges(current)) {
                CFANode succ = leavingEdge.getSuccessor();
                ExpressionTree<Object> succTree = (ExpressionTree)memo.get(succ);
                if (succTree == null) {
                    succTree = ExpressionTrees.getFalse();
                }
                if (leavingEdge instanceof AReturnStatementEdge) {
                    AReturnStatementEdge returnStatementEdge = (AReturnStatementEdge)leavingEdge;
                    Optional<? extends AExpression> optExpression = returnStatementEdge.getExpression();
                    assert (optExpression.isPresent());
                    if (!optExpression.isPresent()) {
                        return ExpressionTrees.getTrue();
                    }
                    AExpression expression = optExpression.get();
                    if (!(expression instanceof AIntegerLiteralExpression)) {
                        return ExpressionTrees.getTrue();
                    }
                    AIntegerLiteralExpression literal = (AIntegerLiteralExpression)expression;
                    if (!literal.getValue().equals(BigInteger.ZERO)) {
                        succTree = factory.or(succTree, currentTree);
                    }
                } else if (leavingEdge instanceof AssumeEdge) {
                    AssumeEdge assumeEdge = (AssumeEdge)leavingEdge;
                    AExpression expression = assumeEdge.getExpression();
                    if (expression.toString().contains(CPACHECKER_TMP_PREFIX)) {
                        for (CFAEdge enteringEdge : CFAUtils.enteringEdges(current)) {
                            Map<AExpression, AExpression> tmpVariableValues = CParserUtils.collectCPAcheckerTMPValues(enteringEdge);
                            if (!tmpVariableValues.isEmpty()) {
                                expression = CParserUtils.replaceCPAcheckerTMPVariables(assumeEdge.getExpression(), tmpVariableValues);
                            }
                            ExpressionTree<AExpression> newPath = !expression.toString().contains(CPACHECKER_TMP_PREFIX) ? factory.and(currentTree, factory.leaf(expression, assumeEdge.getTruthAssumption())) : currentTree;
                            succTree = factory.or(succTree, newPath);
                        }
                    } else {
                        ExpressionTree<AExpression> newPath = factory.and(currentTree, factory.leaf(expression, assumeEdge.getTruthAssumption()));
                        succTree = factory.or(succTree, newPath);
                    }
                } else {
                    succTree = factory.or(succTree, currentTree);
                }
                memo.put(succ, succTree);
            }
            for (CFANode successor : CFAUtils.successorsOf(current)) {
                if (!CFAUtils.predecessorsOf(successor).allMatch(Predicates.in(ready)) || !ready.add(successor)) continue;
                waitlist.offer(successor);
            }
        }
        return pParserTools.expressionTreeSimplifier.simplify((ExpressionTree)memo.get(pEntry.getExitNode()));
    }

    private static AExpression replaceCPAcheckerTMPVariables(AExpression pExpression, Map<AExpression, AExpression> pTmpValues) {
        if (pTmpValues.isEmpty()) {
            return pExpression;
        }
        AExpression directMatch = pTmpValues.get(pExpression);
        if (directMatch != null) {
            return directMatch;
        }
        if (pExpression instanceof CBinaryExpression) {
            CBinaryExpression binaryExpression = (CBinaryExpression)pExpression;
            CExpression op1 = (CExpression)CParserUtils.replaceCPAcheckerTMPVariables(binaryExpression.getOperand1(), pTmpValues);
            CExpression op2 = (CExpression)CParserUtils.replaceCPAcheckerTMPVariables(binaryExpression.getOperand2(), pTmpValues);
            return new CBinaryExpression(binaryExpression.getFileLocation(), binaryExpression.getExpressionType(), binaryExpression.getCalculationType(), op1, op2, binaryExpression.getOperator());
        }
        if (pExpression instanceof CUnaryExpression) {
            CUnaryExpression unaryExpression = (CUnaryExpression)pExpression;
            CExpression op = (CExpression)CParserUtils.replaceCPAcheckerTMPVariables(unaryExpression.getOperand(), pTmpValues);
            return new CUnaryExpression(unaryExpression.getFileLocation(), unaryExpression.getExpressionType(), op, unaryExpression.getOperator());
        }
        return pExpression;
    }

    private static Map<AExpression, AExpression> collectCPAcheckerTMPValues(CFAEdge pEdge) {
        AExpressionAssignmentStatement expAssignStmt;
        ALeftHandSide lhs;
        AStatement statement;
        if (pEdge instanceof AStatementEdge && (statement = ((AStatementEdge)pEdge).getStatement()) instanceof AExpressionAssignmentStatement && (lhs = (expAssignStmt = (AExpressionAssignmentStatement)statement).getLeftHandSide()) instanceof AIdExpression && ((AIdExpression)lhs).getName().contains(CPACHECKER_TMP_PREFIX)) {
            AExpression rhs = expAssignStmt.getRightHandSide();
            return ImmutableMap.of((Object)lhs, (Object)rhs);
        }
        return ImmutableMap.of();
    }

    private static Collection<CStatement> removeDuplicates(Iterable<? extends CStatement> pStatements) {
        HashMap<CAstNode, CStatement> result = new HashMap<CAstNode, CStatement>();
        for (CStatement cStatement : pStatements) {
            if (cStatement instanceof CExpressionAssignmentStatement) {
                CExpressionAssignmentStatement assignmentStatement = (CExpressionAssignmentStatement)cStatement;
                result.put(assignmentStatement.getLeftHandSide(), assignmentStatement);
                continue;
            }
            result.put(cStatement, cStatement);
        }
        return result.values();
    }

    private static CStatement adjustCharAssignmentSignedness(CStatement pStatement) {
        CSimpleType simpleType;
        CBasicType basicType;
        CExpressionAssignmentStatement statement;
        CLeftHandSide leftHandSide;
        CType canonicalType;
        if (pStatement instanceof CExpressionAssignmentStatement && (canonicalType = (leftHandSide = (statement = (CExpressionAssignmentStatement)pStatement).getLeftHandSide()).getExpressionType().getCanonicalType()) instanceof CSimpleType && (basicType = (simpleType = (CSimpleType)canonicalType).getType()).equals((Object)CBasicType.CHAR) && !simpleType.isSigned() && !simpleType.isUnsigned()) {
            CExpression rightHandSide = statement.getRightHandSide();
            CCastExpression castedRightHandSide = new CCastExpression(rightHandSide.getFileLocation(), canonicalType, rightHandSide);
            return new CExpressionAssignmentStatement(statement.getFileLocation(), leftHandSide, castedRightHandSide);
        }
        return pStatement;
    }

    private static String tryFixArrayInitializers(String pAssumeCode) {
        String C_INTEGER = "([\\+\\-])?(0[xX])?[0-9a-fA-F]+";
        String assumeCode = pAssumeCode.trim();
        if (assumeCode.endsWith(";")) {
            assumeCode = assumeCode.substring(0, assumeCode.length() - 1);
        }
        if (assumeCode.matches(".+=\\s*\\{\\s*(" + C_INTEGER + "\\s*(,\\s*" + C_INTEGER + "\\s*)*)?\\}\\s*")) {
            Iterable assignmentParts = Splitter.on((char)'=').trimResults().split((CharSequence)assumeCode);
            Iterator assignmentPartIterator = assignmentParts.iterator();
            if (!assignmentPartIterator.hasNext()) {
                return pAssumeCode;
            }
            String leftHandSide = (String)assignmentPartIterator.next();
            if (!assignmentPartIterator.hasNext()) {
                return pAssumeCode;
            }
            String rightHandSide = ((String)assignmentPartIterator.next()).trim();
            if (assignmentPartIterator.hasNext()) {
                return pAssumeCode;
            }
            assert (rightHandSide.startsWith("{") && rightHandSide.endsWith("}"));
            rightHandSide = rightHandSide.substring(1, rightHandSide.length() - 1).trim();
            Iterable elements = Splitter.on((char)',').trimResults().split((CharSequence)rightHandSide);
            StringBuilder resultBuilder = new StringBuilder();
            int index = 0;
            for (String element : elements) {
                resultBuilder.append(String.format("%s[%d] = %s; ", leftHandSide, index, element));
                ++index;
            }
            return resultBuilder.toString();
        }
        return pAssumeCode;
    }

    public static class ParserTools {
        private final ExpressionTreeFactory<AExpression> expressionTreeFactory;
        private final Simplifier<AExpression> expressionTreeSimplifier;
        private final MachineModel machineModel;
        private final LogManager logger;

        private ParserTools(ExpressionTreeFactory<AExpression> pExpressionTreeFactory, MachineModel pMachineModel, LogManager pLogger) {
            this.expressionTreeFactory = Objects.requireNonNull(pExpressionTreeFactory);
            this.expressionTreeSimplifier = Objects.requireNonNull(ExpressionTrees.newSimplifier(pExpressionTreeFactory));
            this.machineModel = Objects.requireNonNull(pMachineModel);
            this.logger = Objects.requireNonNull(pLogger);
        }

        public static ParserTools create(ExpressionTreeFactory<AExpression> pExpressionTreeFactory, MachineModel pMachineModel, LogManager pLogger) {
            return new ParserTools(pExpressionTreeFactory, pMachineModel, pLogger);
        }
    }
}

