/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.SetMultimap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import org.sosy_lab.common.collect.Collections3;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.arg.StronglyConnectedComponent;
import org.sosy_lab.cpachecker.util.Pair;

public class GraphUtils {
    private GraphUtils() {
    }

    public static <N> SetMultimap<N, N> projectARG(N root, Function<? super N, ? extends Iterable<N>> successorFunction, Predicate<? super N> isRelevant) {
        Preconditions.checkNotNull(root);
        isRelevant = Predicates.or((Predicate)Predicates.equalTo(root), isRelevant);
        LinkedHashMultimap successors = LinkedHashMultimap.create();
        ArrayDeque<Pair<Object, N>> todo = new ArrayDeque<Pair<Object, N>>();
        HashSet visited = new HashSet();
        todo.push(Pair.of(root, root));
        while (!todo.isEmpty()) {
            Pair currentPair = (Pair)todo.pop();
            Object currentPredecessor = currentPair.getFirst();
            Object currentState = currentPair.getSecond();
            if (!visited.add(currentState)) continue;
            for (N child : successorFunction.apply(currentState)) {
                if (isRelevant.apply(child)) {
                    successors.put(currentPredecessor, child);
                    todo.push(Pair.of(child, child));
                    continue;
                }
                todo.push(Pair.of(currentPredecessor, child));
            }
        }
        return successors;
    }

    public static List<List<ARGState>> retrieveSimpleCycles(List<ARGState> pStates, ReachedSet pReached) {
        HashSet<ARGState> filteredStates = new HashSet<ARGState>(Collections2.transform((Collection)pReached.asCollection(), s -> (ARGState)s));
        filteredStates.removeAll(pStates);
        return GraphUtils.retrieveSimpleCycles(pStates, filteredStates);
    }

    public static List<List<ARGState>> retrieveSimpleCycles(List<ARGState> pStates, Set<ARGState> pExcludeStates) {
        HashSet<ARGState> blockedSet = new HashSet<ARGState>();
        HashMultimap blockedMap = HashMultimap.create();
        ArrayDeque<ARGState> stack = new ArrayDeque<ARGState>();
        ArrayList<List<ARGState>> allCycles = new ArrayList<List<ARGState>>();
        int startIndex = 0;
        while (startIndex < pStates.size() - 1) {
            List<ARGState> subList = pStates.subList(startIndex, pStates.size());
            HashSet<ARGState> excludeSet = new HashSet<ARGState>(pStates);
            excludeSet.addAll(pExcludeStates);
            excludeSet.removeAll(subList);
            ImmutableSet SCCs = (ImmutableSet)GraphUtils.retrieveSCCs(subList, excludeSet).stream().filter(x -> x.getNodes().size() > 1).collect(ImmutableSet.toImmutableSet());
            if (SCCs.isEmpty()) break;
            ARGState s = SCCs.stream().map(x -> pStates.indexOf(x.getRootNode())).reduce((x, y) -> x.compareTo((Integer)y) <= 0 ? x : y).map(pStates::get).orElseThrow();
            blockedSet.clear();
            blockedMap.clear();
            GraphUtils.findCyclesInSCC(s, s, blockedSet, (SetMultimap<ARGState, ARGState>)blockedMap, stack, allCycles, excludeSet);
            startIndex = pStates.indexOf(s) + 1;
        }
        return allCycles;
    }

    private static boolean findCyclesInSCC(ARGState pStartState, ARGState pCurrentState, Set<ARGState> pBlockedSet, SetMultimap<ARGState, ARGState> pBlockedMap, Deque<ARGState> pStack, List<List<ARGState>> pAllCycles, Set<ARGState> pExcludeSet) {
        if (pExcludeSet.contains(pCurrentState)) {
            return false;
        }
        boolean foundCycle = false;
        pStack.push(pCurrentState);
        pBlockedSet.add(pCurrentState);
        for (ARGState successor : pCurrentState.getChildren()) {
            if (successor.equals(pStartState)) {
                ArrayList<ARGState> cycle = new ArrayList<ARGState>();
                pStack.push(pStartState);
                cycle.addAll(pStack);
                Collections.reverse(cycle);
                pStack.pop();
                pAllCycles.add(cycle);
                foundCycle = true;
                continue;
            }
            if (pBlockedSet.contains(successor)) continue;
            boolean gotCycle = GraphUtils.findCyclesInSCC(pStartState, successor, pBlockedSet, pBlockedMap, pStack, pAllCycles, pExcludeSet);
            foundCycle = foundCycle || gotCycle;
        }
        if (foundCycle) {
            GraphUtils.unblock(pCurrentState, pBlockedSet, pBlockedMap);
        } else {
            for (ARGState s : pCurrentState.getChildren()) {
                pBlockedMap.put((Object)s, (Object)pCurrentState);
            }
        }
        pStack.pop();
        return foundCycle;
    }

    private static void unblock(ARGState pCurrentState, Set<ARGState> pBlockedSet, SetMultimap<ARGState, ARGState> pBlockedMap) {
        pBlockedSet.remove(pCurrentState);
        pBlockedMap.get((Object)pCurrentState).forEach(state -> {
            if (pBlockedSet.contains(state)) {
                GraphUtils.unblock(state, pBlockedSet, pBlockedMap);
            }
        });
    }

    public static ImmutableSet<StronglyConnectedComponent> retrieveSCCs(ReachedSet pReached) {
        Preconditions.checkNotNull((Object)pReached);
        ImmutableList argStates = Collections3.transformedImmutableListCopy((Collection)pReached.asCollection(), x -> (ARGState)x);
        return GraphUtils.retrieveSCCs((List<ARGState>)argStates, (Collection<ARGState>)ImmutableSet.of());
    }

    private static ImmutableSet<StronglyConnectedComponent> retrieveSCCs(List<ARGState> pARGStates, Collection<ARGState> pExcludeStates) {
        Preconditions.checkNotNull(pARGStates);
        ArrayList<StronglyConnectedComponent> SCCs = new ArrayList<StronglyConnectedComponent>();
        int index = 0;
        ArrayDeque<ARGState> dfsStack = new ArrayDeque<ARGState>();
        HashMap<ARGState, Integer> stateIndex = new HashMap<ARGState, Integer>();
        HashMap<ARGState, Integer> stateLowLink = new HashMap<ARGState, Integer>();
        for (ARGState state : pARGStates) {
            if (pExcludeStates.contains(state) || stateIndex.containsKey(state)) continue;
            GraphUtils.strongConnect(state, index, stateIndex, stateLowLink, dfsStack, SCCs, pExcludeStates);
        }
        Collections.reverse(SCCs);
        return ImmutableSet.copyOf(SCCs);
    }

    private static void strongConnect(ARGState pState, int pIndex, Map<ARGState, Integer> pStateIndex, Map<ARGState, Integer> pStateLowLink, Deque<ARGState> pDfsStack, List<StronglyConnectedComponent> pSCCs, Collection<ARGState> pExcludeStates) {
        pStateIndex.put(pState, pIndex);
        pStateLowLink.put(pState, pIndex);
        ++pIndex;
        pDfsStack.push(pState);
        for (ARGState sucessorState : pState.getChildren()) {
            if (pExcludeStates.contains(sucessorState)) continue;
            if (!pStateIndex.containsKey(sucessorState)) {
                GraphUtils.strongConnect(sucessorState, pIndex, pStateIndex, pStateLowLink, pDfsStack, pSCCs, pExcludeStates);
                pStateLowLink.put(pState, Math.min(pStateLowLink.get(pState), pStateLowLink.get(sucessorState)));
                continue;
            }
            if (!pDfsStack.contains(sucessorState)) continue;
            pStateLowLink.put(pState, Math.min(pStateLowLink.get(pState), pStateIndex.get(sucessorState)));
        }
        if (pStateIndex.get(pState).intValue() == pStateLowLink.get(pState).intValue()) {
            ARGState s;
            StronglyConnectedComponent scc = new StronglyConnectedComponent(pState);
            do {
                s = pDfsStack.pop();
                scc.addNode(s);
            } while (!Objects.equals(pState, s));
            pSCCs.add(scc);
        }
    }
}

