/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util;

import com.google.common.base.Equivalence;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.TreeMultimap;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.ShutdownManager;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.configuration.TimeSpanOption;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.common.time.TimeSpan;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.ImmutableCFA;
import org.sosy_lab.cpachecker.cfa.Language;
import org.sosy_lab.cpachecker.cfa.MutableCFA;
import org.sosy_lab.cpachecker.cfa.ast.ADeclaration;
import org.sosy_lab.cpachecker.cfa.ast.ASimpleDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CTypeDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.model.ADeclarationEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.FunctionCallEdge;
import org.sosy_lab.cpachecker.cfa.model.FunctionEntryNode;
import org.sosy_lab.cpachecker.cfa.model.FunctionExitNode;
import org.sosy_lab.cpachecker.core.CPABuilder;
import org.sosy_lab.cpachecker.core.algorithm.Algorithm;
import org.sosy_lab.cpachecker.core.algorithm.CPAAlgorithm;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.StateSpacePartition;
import org.sosy_lab.cpachecker.core.interfaces.WrapperCPA;
import org.sosy_lab.cpachecker.core.reachedset.AggregatedReachedSets;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSetFactory;
import org.sosy_lab.cpachecker.core.specification.Specification;
import org.sosy_lab.cpachecker.cpa.livevar.LiveVariablesCPA;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.util.CFATraversal;
import org.sosy_lab.cpachecker.util.LoopStructure;
import org.sosy_lab.cpachecker.util.Pair;
import org.sosy_lab.cpachecker.util.resources.ResourceLimit;
import org.sosy_lab.cpachecker.util.resources.ResourceLimitChecker;
import org.sosy_lab.cpachecker.util.resources.WalltimeLimit;
import org.sosy_lab.cpachecker.util.variableclassification.VariableClassification;

public class LiveVariables {
    public static final Equivalence<ASimpleDeclaration> LIVE_DECL_EQUIVALENCE = new Equivalence<ASimpleDeclaration>(){

        protected boolean doEquivalent(ASimpleDeclaration pA, ASimpleDeclaration pB) {
            if (pA instanceof CVariableDeclaration && pB instanceof CVariableDeclaration) {
                return ((CVariableDeclaration)pA).equalsWithoutStorageClass(pB);
            }
            return pA.equals(pB);
        }

        protected int doHash(ASimpleDeclaration pT) {
            if (pT instanceof CVariableDeclaration) {
                return ((CVariableDeclaration)pT).hashCodeWithOutStorageClass();
            }
            return pT.hashCode();
        }
    };
    private final ImmutableSetMultimap<CFANode, Equivalence.Wrapper<ASimpleDeclaration>> liveVariables;
    private final ImmutableSortedSet<Equivalence.Wrapper<ASimpleDeclaration>> globalVariables;
    private final VariableClassification variableClassification;
    private final EvaluationStrategy evaluationStrategy;
    private final Language language;
    private final ImmutableSetMultimap<CFANode, String> liveVariablesStrings;
    private final ImmutableSortedSet<String> globalVariablesStrings;
    public static final Function<ASimpleDeclaration, Equivalence.Wrapper<ASimpleDeclaration>> TO_EQUIV_WRAPPER = arg_0 -> LIVE_DECL_EQUIVALENCE.wrap(arg_0);
    private static final Function<Equivalence.Wrapper<ASimpleDeclaration>, ASimpleDeclaration> FROM_EQUIV_WRAPPER = Equivalence.Wrapper::get;
    public static final Function<Equivalence.Wrapper<ASimpleDeclaration>, String> FROM_EQUIV_WRAPPER_TO_STRING = Functions.compose(ASimpleDeclaration::getQualifiedName, FROM_EQUIV_WRAPPER);

    private LiveVariables() {
        this.variableClassification = null;
        this.liveVariablesStrings = null;
        this.globalVariables = null;
        this.evaluationStrategy = null;
        this.language = null;
        this.liveVariables = null;
        this.globalVariablesStrings = null;
    }

    private LiveVariables(Multimap<CFANode, Equivalence.Wrapper<ASimpleDeclaration>> pLiveVariables, VariableClassification pVariableClassification, Set<Equivalence.Wrapper<ASimpleDeclaration>> pGlobalVariables, EvaluationStrategy pEvaluationStrategy, Language pLanguage) {
        Comparator<Equivalence.Wrapper<ASimpleDeclaration>> declarationOrdering = Comparator.comparing(FROM_EQUIV_WRAPPER_TO_STRING);
        TreeMultimap sortedLiveVariables = TreeMultimap.create(Comparator.naturalOrder(), declarationOrdering);
        sortedLiveVariables.putAll(pLiveVariables);
        this.liveVariables = ImmutableSetMultimap.copyOf((Multimap)sortedLiveVariables);
        assert (pLiveVariables.size() == this.liveVariables.size()) : "ASimpleDeclarations with identical qualified names";
        this.globalVariables = ImmutableSortedSet.copyOf(declarationOrdering, pGlobalVariables);
        assert (pGlobalVariables.size() == this.globalVariables.size()) : "Global ASimpleDeclarations with identical qualified names";
        this.variableClassification = pVariableClassification;
        this.evaluationStrategy = pEvaluationStrategy;
        this.language = pLanguage;
        this.globalVariablesStrings = ImmutableSortedSet.copyOf((Collection)Collections2.transform(this.globalVariables, FROM_EQUIV_WRAPPER_TO_STRING));
        this.liveVariablesStrings = ImmutableSetMultimap.copyOf((Multimap)Multimaps.transformValues(this.liveVariables, FROM_EQUIV_WRAPPER_TO_STRING));
    }

    public boolean isVariableLive(ASimpleDeclaration variable, CFANode location) {
        String varName = variable.getQualifiedName();
        Equivalence.Wrapper wrappedDecl = LIVE_DECL_EQUIVALENCE.wrap((Object)variable);
        if (this.globalVariables.contains((Object)wrappedDecl) || this.language == Language.C && this.variableClassification.getAddressedVariables().contains(varName) || this.evaluationStrategy == EvaluationStrategy.FUNCTION_WISE && !varName.startsWith(location.getFunctionName())) {
            return true;
        }
        return this.liveVariables.containsEntry((Object)location, (Object)wrappedDecl);
    }

    public boolean isVariableLive(String varName, CFANode location) {
        if (this.globalVariablesStrings.contains((Object)varName) || this.language == Language.C && this.variableClassification.getAddressedVariables().contains(varName) || this.evaluationStrategy == EvaluationStrategy.FUNCTION_WISE && !varName.startsWith(location.getFunctionName())) {
            return true;
        }
        return this.liveVariablesStrings.containsEntry((Object)location, (Object)varName);
    }

    public Set<ASimpleDeclaration> getLiveVariablesForNode(CFANode pNode) {
        return FluentIterable.from((Iterable)this.liveVariables.get((Object)pNode)).append(this.globalVariables).transform(FROM_EQUIV_WRAPPER).toSet();
    }

    public Set<ASimpleDeclaration> getAllLiveVariables() {
        return FluentIterable.from((Iterable)this.liveVariables.values()).append(this.globalVariables).transform(FROM_EQUIV_WRAPPER).toSet();
    }

    public static Optional<LiveVariables> createWithAllVariablesAsLive(List<Pair<ADeclaration, String>> globalsList, MutableCFA pCFA) {
        return Optional.of(new AllVariablesAsLiveVariables(pCFA, globalsList));
    }

    public static LiveVariables create(Optional<VariableClassification> variableClassification, List<Pair<ADeclaration, String>> globalsList, MutableCFA pCFA, LogManager logger, ShutdownNotifier pShutdownNotifier, Configuration config) throws InvalidConfigurationException, IllegalArgumentException, AssertionError, InterruptedException {
        ResourceLimitChecker limitChecker;
        ShutdownNotifier shutdownNotifier;
        Preconditions.checkNotNull(variableClassification);
        Preconditions.checkNotNull(globalsList);
        Preconditions.checkNotNull((Object)pCFA);
        Preconditions.checkNotNull((Object)logger);
        Preconditions.checkNotNull((Object)pShutdownNotifier);
        if (pCFA.getLanguage() == Language.C && !variableClassification.isPresent()) {
            return new AllVariablesAsLiveVariables(pCFA, globalsList);
        }
        ImmutableCFA cfa = pCFA.makeImmutableCFA(variableClassification);
        LiveVariablesConfiguration liveVarConfig = new LiveVariablesConfiguration(config);
        if (!liveVarConfig.overallLivenessCheckTime.isEmpty()) {
            ShutdownManager liveVarsShutdown = ShutdownManager.createWithParent((ShutdownNotifier)pShutdownNotifier);
            shutdownNotifier = liveVarsShutdown.getNotifier();
            WalltimeLimit limit = WalltimeLimit.fromNowOn(liveVarConfig.overallLivenessCheckTime);
            limitChecker = new ResourceLimitChecker(liveVarsShutdown, (List<ResourceLimit>)ImmutableList.of((Object)limit));
            limitChecker.start();
        } else {
            shutdownNotifier = pShutdownNotifier;
            limitChecker = null;
        }
        LiveVariables liveVarObject = LiveVariables.create0(variableClassification.orElse(null), globalsList, logger, shutdownNotifier, cfa, liveVarConfig);
        if (limitChecker != null) {
            limitChecker.cancel();
        }
        return liveVarObject;
    }

    private static LiveVariables create0(VariableClassification variableClassification, List<Pair<ADeclaration, String>> globalsList, LogManager logger, ShutdownNotifier pShutdownNotifier, CFA cfa, LiveVariablesConfiguration config) throws AssertionError, IllegalArgumentException, InterruptedException {
        ResourceLimitChecker limitChecker;
        ShutdownNotifier shutdownNotifier;
        ImmutableSet globalVariables;
        switch (config.evaluationStrategy) {
            case FUNCTION_WISE: {
                globalVariables = FluentIterable.from(globalsList).transform(Pair::getFirst).filter(Predicates.notNull()).filter(Predicates.not((Predicate)Predicates.or((Predicate)Predicates.instanceOf(CTypeDeclaration.class), (Predicate)Predicates.instanceOf(CFunctionDeclaration.class)))).transform(TO_EQUIV_WRAPPER).toSet();
                break;
            }
            case GLOBAL: {
                globalVariables = ImmutableSet.of();
                break;
            }
            default: {
                throw new AssertionError((Object)("Unhandled case statement: " + config.evaluationStrategy));
            }
        }
        if (!config.partwiseLivenessCheckTime.isEmpty()) {
            ShutdownManager liveVarsShutdown = ShutdownManager.createWithParent((ShutdownNotifier)pShutdownNotifier);
            shutdownNotifier = liveVarsShutdown.getNotifier();
            WalltimeLimit limit = WalltimeLimit.fromNowOn(config.partwiseLivenessCheckTime);
            limitChecker = new ResourceLimitChecker(liveVarsShutdown, (List<ResourceLimit>)ImmutableList.of((Object)limit));
            limitChecker.start();
        } else {
            shutdownNotifier = pShutdownNotifier;
            limitChecker = null;
        }
        Optional<AnalysisParts> parts = LiveVariables.getNecessaryAnalysisComponents(cfa, logger, shutdownNotifier, config.evaluationStrategy);
        Multimap<CFANode, Equivalence.Wrapper<ASimpleDeclaration>> liveVariables = null;
        if (parts.isPresent()) {
            liveVariables = LiveVariables.addLiveVariablesFromCFA(cfa, logger, parts.orElseThrow(), config.evaluationStrategy);
        }
        if (limitChecker != null) {
            limitChecker.cancel();
        }
        if (liveVariables == null && config.evaluationStrategy != EvaluationStrategy.FUNCTION_WISE) {
            logger.log(Level.INFO, new Object[]{"Global live variables collection failed, fallback to function-wise analysis."});
            config.evaluationStrategy = EvaluationStrategy.FUNCTION_WISE;
            return LiveVariables.create0(variableClassification, globalsList, logger, pShutdownNotifier, cfa, config);
        }
        if (liveVariables == null) {
            return new AllVariablesAsLiveVariables(cfa, globalsList);
        }
        return new LiveVariables(liveVariables, variableClassification, (Set<Equivalence.Wrapper<ASimpleDeclaration>>)globalVariables, config.evaluationStrategy, cfa.getLanguage());
    }

    private static @Nullable Multimap<CFANode, // Could not load outer class - annotation placement on inner may be incorrect
    Equivalence.Wrapper<ASimpleDeclaration>> addLiveVariablesFromCFA(CFA pCfa, LogManager logger, AnalysisParts analysisParts, EvaluationStrategy evaluationStrategy) throws IllegalArgumentException, InterruptedException {
        Collection<FunctionEntryNode> functionHeads;
        Optional<LoopStructure> loopStructure = pCfa.getLoopStructure();
        switch (evaluationStrategy) {
            case FUNCTION_WISE: {
                functionHeads = pCfa.getAllFunctionHeads();
                break;
            }
            case GLOBAL: {
                functionHeads = Collections.singleton(pCfa.getMainFunction());
                break;
            }
            default: {
                throw new AssertionError((Object)("Unhandled case statement: " + evaluationStrategy));
            }
        }
        for (FunctionEntryNode node : functionHeads) {
            FunctionExitNode exitNode = node.getExitNode();
            if (!pCfa.getAllNodes().contains(exitNode)) continue;
            analysisParts.reachedSet.add(analysisParts.cpa.getInitialState(exitNode, StateSpacePartition.getDefaultPartition()), analysisParts.cpa.getInitialPrecision(exitNode, StateSpacePartition.getDefaultPartition()));
        }
        if (loopStructure.isPresent()) {
            LoopStructure structure = loopStructure.orElseThrow();
            ImmutableCollection<LoopStructure.Loop> loops = structure.getAllLoops();
            for (LoopStructure.Loop l : loops) {
                if (!FluentIterable.from(l.getOutgoingEdges()).filter(Predicates.not((Predicate)Predicates.instanceOf(FunctionCallEdge.class))).isEmpty()) continue;
                CFANode functionHead = (CFANode)l.getLoopHeads().iterator().next();
                analysisParts.reachedSet.add(analysisParts.cpa.getInitialState(functionHead, StateSpacePartition.getDefaultPartition()), analysisParts.cpa.getInitialPrecision(functionHead, StateSpacePartition.getDefaultPartition()));
            }
        }
        logger.log(Level.INFO, new Object[]{"Starting live variables collection ..."});
        try {
            do {
                analysisParts.algorithm.run(analysisParts.reachedSet);
            } while (analysisParts.reachedSet.hasWaitingState());
        }
        catch (InterruptedException | CPAException e) {
            logger.logUserException(Level.WARNING, (Throwable)e, "Could not compute live variables.");
            return null;
        }
        logger.log(Level.INFO, new Object[]{"Stopping live variables collection ..."});
        LiveVariablesCPA liveVarCPA = ((WrapperCPA)((Object)analysisParts.cpa)).retrieveWrappedCpa(LiveVariablesCPA.class);
        return liveVarCPA.getLiveVariables();
    }

    private static Optional<AnalysisParts> getNecessaryAnalysisComponents(CFA cfa, LogManager logger, ShutdownNotifier shutdownNotifier, EvaluationStrategy evaluationStrategy) throws InterruptedException {
        try {
            String configFile;
            switch (evaluationStrategy) {
                case FUNCTION_WISE: {
                    configFile = "liveVariables-intraprocedural.properties";
                    break;
                }
                case GLOBAL: {
                    configFile = "liveVariables-interprocedural.properties";
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Unhandled case statement: " + evaluationStrategy));
                }
            }
            Configuration config = Configuration.builder().loadFromResource(LiveVariables.class, configFile).build();
            ReachedSetFactory reachedFactory = new ReachedSetFactory(config, logger);
            ConfigurableProgramAnalysis cpa = new CPABuilder(config, logger, shutdownNotifier, reachedFactory).buildCPAs(cfa, Specification.alwaysSatisfied(), AggregatedReachedSets.empty());
            CPAAlgorithm algorithm = CPAAlgorithm.create(cpa, logger, config, shutdownNotifier);
            ReachedSet reached = reachedFactory.create(cpa);
            return Optional.of(new AnalysisParts(cpa, algorithm, reached));
        }
        catch (InvalidConfigurationException | CPAException e) {
            logger.logUserException(Level.WARNING, e, "An error occurred during the creation of the necessary CPA parts for the live variables analysis.");
            return Optional.empty();
        }
    }

    private static class AnalysisParts {
        private final ConfigurableProgramAnalysis cpa;
        private final Algorithm algorithm;
        private final ReachedSet reachedSet;

        private AnalysisParts(ConfigurableProgramAnalysis pCPA, Algorithm pAlgorithm, ReachedSet pReachedSet) {
            this.cpa = pCPA;
            this.algorithm = pAlgorithm;
            this.reachedSet = pReachedSet;
        }
    }

    private static class AllVariablesAsLiveVariables
    extends LiveVariables {
        private final ImmutableSet<ASimpleDeclaration> allVariables;

        private AllVariablesAsLiveVariables(CFA cfa, List<Pair<ADeclaration, String>> globalsList) {
            Preconditions.checkNotNull((Object)cfa);
            Preconditions.checkNotNull(globalsList);
            ImmutableSet globalVars = FluentIterable.from(globalsList).transform(Pair::getFirst).filter(Predicates.notNull()).filter(Predicates.not((Predicate)Predicates.or((Predicate)Predicates.instanceOf(CTypeDeclaration.class), (Predicate)Predicates.instanceOf(CFunctionDeclaration.class)))).toSet();
            CFATraversal.EdgeCollectingCFAVisitor edgeCollectingVisitor = new CFATraversal.EdgeCollectingCFAVisitor();
            CFATraversal.dfs().traverseOnce(cfa.getMainFunction(), edgeCollectingVisitor);
            FluentIterable edges = FluentIterable.from(edgeCollectingVisitor.getVisitedEdges()).filter(ADeclarationEdge.class);
            this.allVariables = edges.transform(ADeclarationEdge::getDeclaration).append((Iterable)globalVars).toSet();
        }

        @Override
        public boolean isVariableLive(ASimpleDeclaration pVariable, CFANode pLocation) {
            return true;
        }

        @Override
        public boolean isVariableLive(String pVarName, CFANode pLocation) {
            return true;
        }

        @Override
        public Set<ASimpleDeclaration> getLiveVariablesForNode(CFANode pNode) {
            return this.allVariables;
        }

        @Override
        public Set<ASimpleDeclaration> getAllLiveVariables() {
            return this.allVariables;
        }
    }

    @Options(prefix="liveVar")
    private static class LiveVariablesConfiguration {
        @Option(toUppercase=true, description="By changing this option one can adjust the way how live variables are created. Function-wise means that each function is handled separately, global means that the whole cfa is used for the computation.", secure=true)
        private EvaluationStrategy evaluationStrategy = EvaluationStrategy.FUNCTION_WISE;
        @Option(secure=true, description="Overall timelimit for collecting the liveness information.(use seconds or specify a unit; 0 for infinite)")
        @TimeSpanOption(codeUnit=TimeUnit.NANOSECONDS, defaultUserUnit=TimeUnit.SECONDS, min=0L)
        private TimeSpan overallLivenessCheckTime = TimeSpan.ofNanos((long)0L);
        @Option(secure=true, description="Timelimit for collecting the liveness information with one approach, (p.e. if global analysis is selected and fails in the specified timelimit the function wise approach will have the same time-limit afterwards to compute the live variables).(use seconds or specify a unit; 0 for infinite)")
        @TimeSpanOption(codeUnit=TimeUnit.NANOSECONDS, defaultUserUnit=TimeUnit.SECONDS, min=0L)
        private TimeSpan partwiseLivenessCheckTime = TimeSpan.ofSeconds((long)20L);

        public LiveVariablesConfiguration(Configuration config) throws InvalidConfigurationException {
            config.inject((Object)this);
        }
    }

    public static enum EvaluationStrategy {
        FUNCTION_WISE,
        GLOBAL;

    }
}

