/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.Comparators;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.lang.invoke.CallSite;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.Function;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.Language;
import org.sosy_lab.cpachecker.cfa.MutableCFA;
import org.sosy_lab.cpachecker.cfa.ast.c.CAssignment;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CLiteralExpression;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdgeType;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.FunctionEntryNode;
import org.sosy_lab.cpachecker.cfa.model.FunctionExitNode;
import org.sosy_lab.cpachecker.cfa.model.c.CAssumeEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CStatementEdge;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.exceptions.CParserException;
import org.sosy_lab.cpachecker.exceptions.JParserException;
import org.sosy_lab.cpachecker.exceptions.ParserException;
import org.sosy_lab.cpachecker.util.CFATraversal;
import org.sosy_lab.cpachecker.util.CFAUtils;
import org.sosy_lab.cpachecker.util.Pair;

public final class LoopStructure
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final ImmutableListMultimap<String, Loop> loops;
    private transient @Nullable ImmutableSet<CFANode> loopHeads = null;
    private transient @Nullable ImmutableSet<String> loopExitConditionVariables;
    private transient @Nullable ImmutableSet<String> loopIncDecVariables;

    private LoopStructure(ImmutableListMultimap<String, Loop> pLoops) {
        this.loops = pLoops;
    }

    public int getCount() {
        return this.loops.size();
    }

    public ImmutableCollection<Loop> getLoopsForFunction(String function) {
        return this.loops.get((Object)((String)Preconditions.checkNotNull((Object)function)));
    }

    public ImmutableCollection<Loop> getAllLoops() {
        return this.loops.values();
    }

    public ImmutableSet<CFANode> getAllLoopHeads() {
        if (this.loopHeads == null) {
            this.loopHeads = FluentIterable.from((Iterable)this.loops.values()).transformAndConcat(Loop::getLoopHeads).toSet();
        }
        return this.loopHeads;
    }

    public ImmutableSet<Loop> getLoopsForLoopHead(CFANode loopHead) {
        return FluentIterable.from((Iterable)this.loops.values()).filter(loop -> loop.getLoopHeads().contains((Object)loopHead)).toSet();
    }

    public Set<String> getLoopExitConditionVariables() {
        if (this.loopExitConditionVariables == null) {
            this.loopExitConditionVariables = this.collectLoopCondVars();
        }
        return this.loopExitConditionVariables;
    }

    private ImmutableSet<String> collectLoopCondVars() {
        return FluentIterable.from((Iterable)this.loops.values()).transform(Loop::getOutgoingEdges).filter(CAssumeEdge.class).transform(CAssumeEdge::getExpression).transformAndConcat(CFAUtils::getVariableNamesOfExpression).toSet();
    }

    public Set<String> getLoopIncDecVariables() {
        if (this.loopIncDecVariables == null) {
            this.loopIncDecVariables = this.collectLoopIncDecVariables();
        }
        return this.loopIncDecVariables;
    }

    private ImmutableSet<String> collectLoopIncDecVariables() {
        ImmutableSet.Builder result = ImmutableSet.builder();
        for (Loop l : this.loops.values()) {
            for (CFAEdge e : l.getInnerLoopEdges()) {
                String var = LoopStructure.obtainIncDecVariable(e);
                if (var == null) continue;
                result.add((Object)var);
            }
        }
        return result.build();
    }

    private static @Nullable String obtainIncDecVariable(CFAEdge e) {
        CAssignment assign;
        CStatementEdge stmtEdge;
        if (e instanceof CStatementEdge && (stmtEdge = (CStatementEdge)e).getStatement() instanceof CAssignment && (assign = (CAssignment)stmtEdge.getStatement()).getLeftHandSide() instanceof CIdExpression) {
            CBinaryExpression binExpr;
            CBinaryExpression.BinaryOperator op;
            CIdExpression assignementToId = (CIdExpression)assign.getLeftHandSide();
            String assignToVar = assignementToId.getDeclaration().getQualifiedName();
            if (assign.getRightHandSide() instanceof CBinaryExpression && ((op = (binExpr = (CBinaryExpression)assign.getRightHandSide()).getOperator()) == CBinaryExpression.BinaryOperator.PLUS || op == CBinaryExpression.BinaryOperator.MINUS) && (binExpr.getOperand1() instanceof CLiteralExpression || binExpr.getOperand2() instanceof CLiteralExpression)) {
                String operandVar;
                CIdExpression operandId = null;
                if (binExpr.getOperand1() instanceof CIdExpression) {
                    operandId = (CIdExpression)binExpr.getOperand1();
                }
                if (binExpr.getOperand2() instanceof CIdExpression) {
                    operandId = (CIdExpression)binExpr.getOperand2();
                }
                if (operandId != null && assignToVar.equals(operandVar = operandId.getDeclaration().getQualifiedName())) {
                    return assignToVar;
                }
            }
        }
        return null;
    }

    public static LoopStructure getLoopStructure(MutableCFA cfa) throws ParserException {
        ImmutableListMultimap.Builder loops = ImmutableListMultimap.builder();
        for (String functionName : cfa.getAllFunctionNames()) {
            NavigableSet<CFANode> nodes = cfa.getFunctionNodes(functionName);
            loops.putAll((Object)functionName, LoopStructure.findLoops(nodes, cfa.getLanguage()));
        }
        return new LoopStructure((ImmutableListMultimap<String, Loop>)loops.build());
    }

    private static Collection<Loop> findLoops(NavigableSet<CFANode> nodes, Language language) throws ParserException {
        boolean changed;
        ArrayList<FunctionEntryNode> initialChain = new ArrayList<FunctionEntryNode>();
        CFANode functionExitNode = (CFANode)nodes.first();
        if (functionExitNode instanceof FunctionExitNode) {
            CFANode startNode = ((FunctionExitNode)functionExitNode).getEntryNode();
            while (startNode.getNumLeavingEdges() == 1 && startNode.getNumEnteringEdges() <= 1) {
                initialChain.add((FunctionEntryNode)startNode);
                startNode = startNode.getLeavingEdge(0).getSuccessor();
            }
            if (!initialChain.isEmpty()) {
                initialChain.remove(initialChain.size() - 1);
            }
            if (!CFAUtils.hasBackWardsEdges(startNode)) {
                return ImmutableList.of();
            }
        }
        nodes = new TreeSet<CFANode>((SortedSet<CFANode>)nodes);
        nodes.removeAll(initialChain);
        Function<CFANode, Integer> arrayIndexForNode = CFANode::getReversePostorderId;
        int size = nodes.size();
        CFANode[] nodesArray = new CFANode[size];
        Edge[][] edges = new Edge[size][size];
        ArrayList<Loop> loops = new ArrayList<Loop>();
        for (CFANode n : nodes) {
            int i = arrayIndexForNode.apply(n);
            assert (nodesArray[i] == null) : "reverse post-order id is not unique, " + i + " occurs twice in function " + n.getFunctionName() + " at " + n + " and " + nodesArray[i];
            nodesArray[i] = n;
            for (CFAEdge edge : CFAUtils.leavingEdges(n)) {
                CFANode succ = edge.getSuccessor();
                int j = arrayIndexForNode.apply(succ);
                edges[i][j] = new Edge();
                if (i != j) continue;
                LoopStructure.handleLoop(succ, i, edges, loops);
            }
        }
        do {
            if (!(changed = LoopStructure.identifyLoops(false, nodes, arrayIndexForNode, nodesArray, edges, loops)) && !nodes.isEmpty()) {
                changed = LoopStructure.identifyLoops(true, nodes, arrayIndexForNode, nodesArray, edges, loops);
            }
            if (changed || nodes.isEmpty()) continue;
            CFANode currentNode = (CFANode)nodes.last();
            int current = arrayIndexForNode.apply(currentNode);
            if (edges[current][current] == null) {
                edges[current][current] = new Edge();
            }
            LoopStructure.handleLoop(currentNode, current, edges, loops);
            LoopStructure.mergeNodeIntoSuccessors(currentNode, current, nodesArray, edges, loops);
            nodes.remove(currentNode);
            changed = true;
        } while (changed && !nodes.isEmpty());
        if (!nodes.isEmpty()) {
            switch (language) {
                case C: {
                    throw new CParserException("Code structure is too complex, could not detect all loops!");
                }
                case JAVA: {
                    throw new JParserException("Code structure is too complex, could not detect all loops!");
                }
            }
            throw new AssertionError((Object)"unknown language");
        }
        TreeSet<Integer> toRemove = new TreeSet<Integer>();
        do {
            toRemove.clear();
            for (int i1 = 0; i1 < loops.size(); ++i1) {
                Loop l1 = (Loop)loops.get(i1);
                for (int i2 = i1 + 1; i2 < loops.size(); ++i2) {
                    Loop l2 = (Loop)loops.get(i2);
                    if (!l1.intersectsWith(l2)) continue;
                    if (l1.isOuterLoopOf(l2)) {
                        l1.addNodes(l2);
                        continue;
                    }
                    if (l2.isOuterLoopOf(l1)) {
                        l2.addNodes(l1);
                        continue;
                    }
                    l1.mergeWith(l2);
                    toRemove.add(i2);
                }
            }
            Iterator iterator = toRemove.descendingSet().iterator();
            while (iterator.hasNext()) {
                int i = (Integer)iterator.next();
                loops.remove(i);
            }
        } while (!toRemove.isEmpty());
        return ImmutableList.copyOf(loops);
    }

    private static boolean identifyLoops(boolean reverseMerge, NavigableSet<CFANode> nodes, Function<CFANode, Integer> arrayIndexForNode, CFANode[] nodesArray, Edge[][] edges, List<Loop> loops) {
        boolean changed = false;
        Iterator<CFANode> it = nodes.iterator();
        while (it.hasNext()) {
            CFANode currentNode = it.next();
            int current = arrayIndexForNode.apply(currentNode);
            int predecessor = LoopStructure.findSingleIncomingEdgeOfNode(current, edges);
            int successor = LoopStructure.findSingleOutgoingEdgeOfNode(current, edges);
            if (predecessor == -1 && successor == -1) {
                it.remove();
                continue;
            }
            if (predecessor == -1 && successor > -1) {
                int successor2 = LoopStructure.findSingleOutgoingEdgeOfNode(successor, edges);
                if (successor2 != -1) continue;
                edges[current][successor] = null;
                it.remove();
                continue;
            }
            if (successor == -1 && predecessor > -1) {
                int predecessor2 = LoopStructure.findSingleIncomingEdgeOfNode(predecessor, edges);
                if (predecessor2 != -1) continue;
                edges[predecessor][current] = null;
                it.remove();
                continue;
            }
            if (predecessor > -1 && successor != -1) {
                changed = true;
                LoopStructure.moveOutgoingEdges(currentNode, current, predecessor, edges);
                edges[predecessor][current] = null;
                it.remove();
                if (edges[predecessor][predecessor] == null) continue;
                CFANode pred = nodesArray[predecessor];
                LoopStructure.handleLoop(pred, predecessor, edges, loops);
                continue;
            }
            if (!reverseMerge || successor <= -1 || predecessor == -1) continue;
            changed = true;
            LoopStructure.moveIncomingEdges(currentNode, current, successor, edges);
            edges[current][successor] = null;
            it.remove();
            if (edges[successor][successor] == null) continue;
            CFANode succ = nodesArray[successor];
            LoopStructure.handleLoop(succ, successor, edges, loops);
        }
        return changed;
    }

    private static void moveIncomingEdges(CFANode fromNode, int from, int to, Edge[][] edges) {
        Edge edgeFromTo = edges[from][to];
        for (int j = 0; j < edges.length; ++j) {
            if (edges[j][from] == null) continue;
            Edge targetEdge = LoopStructure.getEdge(j, to, edges);
            targetEdge.add(edges[j][from]);
            if (edgeFromTo != null) {
                targetEdge.add(edgeFromTo);
            }
            targetEdge.add(fromNode);
            edges[j][from] = null;
        }
    }

    private static void moveOutgoingEdges(CFANode fromNode, int from, int to, Edge[][] edges) {
        Edge edgeToFrom = edges[to][from];
        for (int j = 0; j < edges.length; ++j) {
            if (edges[from][j] == null) continue;
            Edge targetEdge = LoopStructure.getEdge(to, j, edges);
            targetEdge.add(edges[from][j]);
            if (edgeToFrom != null) {
                targetEdge.add(edgeToFrom);
            }
            targetEdge.add(fromNode);
            edges[from][j] = null;
        }
    }

    private static void mergeNodeIntoSuccessors(CFANode currentNode, int current, CFANode[] nodesArray, Edge[][] edges, List<Loop> loops) {
        int successor;
        ArrayList<Integer> predecessors = new ArrayList<Integer>();
        ArrayList<Integer> successors = new ArrayList<Integer>();
        for (int i = 0; i < edges.length; ++i) {
            if (edges[i][current] != null) {
                predecessors.add(i);
            }
            if (edges[current][i] == null) continue;
            successors.add(i);
        }
        Iterator iterator = successors.iterator();
        while (iterator.hasNext()) {
            successor = (Integer)iterator.next();
            Iterator iterator2 = predecessors.iterator();
            while (iterator2.hasNext()) {
                int predecessor = (Integer)iterator2.next();
                Edge targetEdge = LoopStructure.getEdge(predecessor, successor, edges);
                targetEdge.add(edges[predecessor][current]);
                targetEdge.add(edges[current][successor]);
                targetEdge.add(currentNode);
            }
            if (edges[successor][successor] == null) continue;
            CFANode succ = nodesArray[successor];
            LoopStructure.handleLoop(succ, successor, edges, loops);
        }
        iterator = predecessors.iterator();
        while (iterator.hasNext()) {
            int predecessor = (Integer)iterator.next();
            edges[predecessor][current] = null;
        }
        iterator = successors.iterator();
        while (iterator.hasNext()) {
            successor = (Integer)iterator.next();
            edges[current][successor] = null;
        }
    }

    private static Edge getEdge(int i, int j, Edge[][] edges) {
        Edge result = edges[i][j];
        if (edges[i][j] == null) {
            edges[i][j] = result = new Edge();
        }
        return result;
    }

    private static void handleLoop(CFANode loopHead, int loopHeadIndex, Edge[][] edges, Collection<Loop> loops) {
        assert (loopHead != null);
        Loop loop = new Loop(loopHead, edges[loopHeadIndex][loopHeadIndex].asNodeSet());
        loops.add(loop);
        edges[loopHeadIndex][loopHeadIndex] = null;
    }

    private static int findSingleIncomingEdgeOfNode(int i, Edge[][] edges) {
        int size = edges.length;
        int predecessor = -1;
        for (int j = 0; j < size; ++j) {
            if (edges[j][i] == null) continue;
            if (predecessor > -1) {
                return -2;
            }
            predecessor = j;
        }
        return predecessor;
    }

    private static int findSingleOutgoingEdgeOfNode(int i, Edge[][] edges) {
        int size = edges.length;
        int successor = -1;
        for (int j = 0; j < size; ++j) {
            if (edges[i][j] == null) continue;
            if (successor > -1) {
                return -2;
            }
            successor = j;
        }
        return successor;
    }

    public static Collection<Loop> getRecursions(CFA cfa) {
        FunctionEntryNode initialLocation = cfa.getMainFunction();
        HashMap funNameToEntry = Maps.newHashMapWithExpectedSize((int)cfa.getAllFunctionHeads().size());
        for (FunctionEntryNode funNode : cfa.getAllFunctionHeads()) {
            funNameToEntry.put(funNode.getFunctionName(), funNode);
        }
        HashMap callGraph = Maps.newHashMapWithExpectedSize((int)cfa.getAllFunctionHeads().size());
        for (FunctionEntryNode funNode : cfa.getAllFunctionHeads()) {
            if (!callGraph.containsKey(funNode)) {
                callGraph.put(funNode, new ARGState(null, null));
            }
            ARGState successor = (ARGState)callGraph.get(funNode);
            for (CFANode pred : CFAUtils.predecessorsOf(funNode)) {
                FunctionEntryNode callee = (FunctionEntryNode)funNameToEntry.get(pred.getFunctionName());
                if (!callGraph.containsKey(callee)) {
                    callGraph.put(callee, new ARGState(null, null));
                }
                successor.addParent((ARGState)callGraph.get(callee));
            }
        }
        HashSet<CallSite> seen = new HashSet<CallSite>();
        HashSet<Object> recHeadsCallGraph = new HashSet<Object>();
        ArrayDeque<Pair<Object, CallSite>> waitlist = new ArrayDeque<Pair<Object, CallSite>>();
        waitlist.add(Pair.of((ARGState)callGraph.get(initialLocation), "," + ((ARGState)callGraph.get(initialLocation)).getStateId() + ","));
        while (!waitlist.isEmpty()) {
            ARGState parent = (ARGState)((Pair)waitlist.getFirst()).getFirst();
            String path = (String)((Pair)waitlist.removeFirst()).getSecond();
            for (Object child : parent.getChildren()) {
                String childSuffix = ((ARGState)child).getStateId() + ",";
                if (path.contains("," + childSuffix)) {
                    recHeadsCallGraph.add(child);
                    continue;
                }
                if (!seen.add((CallSite)((Object)(path + childSuffix)))) continue;
                waitlist.addLast(Pair.of(child, path + childSuffix));
            }
        }
        ArrayList<FunctionEntryNode> recHeads = new ArrayList<FunctionEntryNode>(recHeadsCallGraph.size());
        for (Map.Entry mapEntry : callGraph.entrySet()) {
            if (!recHeadsCallGraph.contains(mapEntry.getValue())) continue;
            recHeads.add((FunctionEntryNode)mapEntry.getKey());
        }
        ArrayList<Loop> result = new ArrayList<Loop>(recHeads.size());
        for (FunctionEntryNode recHead : recHeads) {
            Set<CFANode> forward = CFATraversal.dfs().ignoreEdgeType(CFAEdgeType.FunctionReturnEdge).collectNodesReachableFrom(recHead);
            Set<CFANode> backward = CFATraversal.dfs().backwards().collectNodesReachableFrom(recHead);
            Sets.SetView nodes = forward.size() <= backward.size() ? Sets.intersection(forward, backward) : Sets.intersection(backward, forward);
            Loop l = new Loop(recHead, (Set<CFANode>)nodes);
            for (FunctionEntryNode entry2 : FluentIterable.from((Iterable)nodes).filter(FunctionEntryNode.class).filter(entry -> entry.getNumEnteringEdges() > 1)) {
                l.mergeWith(new Loop(entry2, (Set<CFANode>)nodes));
            }
            result.add(l);
        }
        return result;
    }

    private static class Edge {
        private final Set<CFANode> nodes = Sets.newHashSetWithExpectedSize((int)1);

        private Edge() {
        }

        private void add(Edge n) {
            this.nodes.addAll(n.nodes);
        }

        private void add(CFANode n) {
            this.nodes.add(n);
        }

        private Set<CFANode> asNodeSet() {
            return this.nodes;
        }
    }

    public static class Loop
    implements Serializable,
    Comparable<Loop> {
        private static final long serialVersionUID = 1L;
        private static final Comparator<Iterable<CFANode>> NODES_COMPARATOR = Comparators.lexicographical(Comparator.naturalOrder());
        private ImmutableSet<CFANode> loopHeads;
        private ImmutableSortedSet<CFANode> nodes;
        private ImmutableSet<CFAEdge> innerLoopEdges;
        private ImmutableSet<CFAEdge> incomingEdges;
        private ImmutableSet<CFAEdge> outgoingEdges;

        private Loop(CFANode loopHead, Set<CFANode> pNodes) {
            this.loopHeads = ImmutableSet.of((Object)loopHead);
            this.nodes = ImmutableSortedSet.naturalOrder().addAll(pNodes).add((Object)loopHead).build();
        }

        private void computeSets() {
            if (this.innerLoopEdges != null) {
                assert (this.incomingEdges != null);
                assert (this.outgoingEdges != null);
                return;
            }
            HashSet<CFAEdge> newIncomingEdges = new HashSet<CFAEdge>();
            HashSet<CFAEdge> newOutgoingEdges = new HashSet<CFAEdge>();
            for (CFANode n : this.nodes) {
                CFAUtils.enteringEdges(n).copyInto(newIncomingEdges);
                CFAUtils.leavingEdges(n).copyInto(newOutgoingEdges);
            }
            this.innerLoopEdges = Sets.intersection(newIncomingEdges, newOutgoingEdges).immutableCopy();
            newIncomingEdges.removeAll((Collection<?>)this.innerLoopEdges);
            newIncomingEdges.removeIf(e -> e.getEdgeType().equals((Object)CFAEdgeType.FunctionReturnEdge));
            newOutgoingEdges.removeAll((Collection<?>)this.innerLoopEdges);
            newOutgoingEdges.removeIf(e -> e.getEdgeType().equals((Object)CFAEdgeType.FunctionCallEdge));
            assert (!newIncomingEdges.isEmpty()) : "Unreachable loop?";
            this.incomingEdges = ImmutableSet.copyOf(newIncomingEdges);
            this.outgoingEdges = ImmutableSet.copyOf(newOutgoingEdges);
        }

        private void addNodes(Loop l) {
            this.nodes = ImmutableSortedSet.naturalOrder().addAll(this.nodes).addAll(l.nodes).build();
            this.innerLoopEdges = null;
            this.incomingEdges = null;
            this.outgoingEdges = null;
        }

        private void mergeWith(Loop l) {
            this.loopHeads = Sets.union(this.loopHeads, l.loopHeads).immutableCopy();
            this.addNodes(l);
        }

        private boolean intersectsWith(Loop l) {
            return !Sets.intersection(this.nodes, l.nodes).isEmpty();
        }

        public boolean isOuterLoopOf(Loop other) {
            this.computeSets();
            other.computeSets();
            return this.innerLoopEdges.containsAll(other.incomingEdges) && this.innerLoopEdges.containsAll(other.outgoingEdges);
        }

        public ImmutableSortedSet<CFANode> getLoopNodes() {
            return this.nodes;
        }

        public ImmutableSet<CFAEdge> getInnerLoopEdges() {
            this.computeSets();
            return this.innerLoopEdges;
        }

        public ImmutableSet<CFANode> getLoopHeads() {
            return this.loopHeads;
        }

        public ImmutableSet<CFAEdge> getIncomingEdges() {
            this.computeSets();
            return this.incomingEdges;
        }

        public ImmutableSet<CFAEdge> getOutgoingEdges() {
            this.computeSets();
            return this.outgoingEdges;
        }

        public String toString() {
            this.computeSets();
            return "Loop with heads " + this.loopHeads + "\n  incoming: " + this.incomingEdges + "\n  outgoing: " + this.outgoingEdges + "\n  nodes:    " + this.nodes + "\n";
        }

        public boolean equals(Object pObj) {
            if (this == pObj) {
                return true;
            }
            if (pObj instanceof Loop) {
                Loop other = (Loop)pObj;
                return this.loopHeads.equals(other.loopHeads) && this.nodes.equals(other.nodes);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.loopHeads);
        }

        @Override
        public int compareTo(Loop pOther) {
            return ComparisonChain.start().compare(this.nodes.size(), pOther.nodes.size()).compare(this.nodes, pOther.nodes, NODES_COMPARATOR).result();
        }
    }
}

