/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util;

import com.google.common.collect.ContiguousSet;
import com.google.common.collect.DiscreteDomain;
import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import com.google.common.collect.TreeRangeSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class NumericIdProvider {
    private final boolean attemptParsing;
    private final TreeRangeSet<Integer> usedIds = TreeRangeSet.create(Collections.singleton(Range.lessThan((Comparable)Integer.valueOf(0))));
    private final Map<String, Integer> mappedIds = new HashMap<String, Integer>();

    private NumericIdProvider(boolean pAttemptParsing) {
        this.attemptParsing = pAttemptParsing;
    }

    public int provideNumericId(String pId) {
        Integer id = this.mappedIds.get(pId);
        if (id != null) {
            return id;
        }
        if (this.attemptParsing) {
            try {
                id = Integer.parseInt(pId);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (id == null || this.usedIds.contains((Comparable)id)) {
            RangeSet remainingIds = this.usedIds.complement();
            for (Range range : remainingIds.asRanges()) {
                ContiguousSet contiguousRange = ContiguousSet.create((Range)range, (DiscreteDomain)DiscreteDomain.integers());
                if (contiguousRange.isEmpty()) continue;
                id = (Integer)contiguousRange.first();
                break;
            }
        }
        assert (id != null && !this.usedIds.contains((Comparable)id));
        this.mappedIds.put(pId, id);
        this.usedIds.add(Range.open((Comparable)Integer.valueOf(id - 1), (Comparable)Integer.valueOf(id + 1)));
        return id;
    }

    public static NumericIdProvider create() {
        return new NumericIdProvider(true);
    }
}

