/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util;

import com.google.common.collect.ForwardingNavigableMap;
import com.google.common.collect.Maps;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Map;
import java.util.NavigableMap;
import org.sosy_lab.cpachecker.util.OrderStatisticSet;

public interface OrderStatisticMap<K, V>
extends NavigableMap<K, V> {
    public K getKeyByRank(int var1);

    public Map.Entry<K, V> getEntryByRank(int var1);

    @CanIgnoreReturnValue
    public K removeByRank(int var1);

    public int rankOf(K var1);

    @Override
    public OrderStatisticMap<K, V> descendingMap();

    @Override
    public OrderStatisticSet<K> navigableKeySet();

    @Override
    public OrderStatisticSet<K> descendingKeySet();

    @Override
    public OrderStatisticMap<K, V> subMap(K var1, boolean var2, K var3, boolean var4);

    @Override
    public OrderStatisticMap<K, V> headMap(K var1, boolean var2);

    @Override
    public OrderStatisticMap<K, V> tailMap(K var1, boolean var2);

    @Override
    public OrderStatisticMap<K, V> subMap(K var1, K var2);

    @Override
    public OrderStatisticMap<K, V> headMap(K var1);

    @Override
    public OrderStatisticMap<K, V> tailMap(K var1);

    public static class OrderStatisticsMapProxy<K, V>
    extends ForwardingNavigableMap<K, V>
    implements OrderStatisticMap<K, V> {
        private final NavigableMap<K, V> delegate;

        public OrderStatisticsMapProxy(NavigableMap<K, V> pDelegate) {
            this.delegate = pDelegate;
        }

        protected NavigableMap<K, V> delegate() {
            return this.delegate;
        }

        @Override
        public K getKeyByRank(int pIndex) {
            return new OrderStatisticSet.OrderStatisticsSetProxy<K>(this.delegate.navigableKeySet()).getByRank(pIndex);
        }

        @Override
        public Map.Entry<K, V> getEntryByRank(int pIndex) {
            K key = this.getKeyByRank(pIndex);
            return Maps.immutableEntry(key, (Object)this.get(key));
        }

        @Override
        @CanIgnoreReturnValue
        public K removeByRank(int pIndex) {
            K key = this.getKeyByRank(pIndex);
            Object val = this.remove(key);
            assert (val != null) : "Key could be retrieved by rank, but no (or null) value associated";
            return key;
        }

        @Override
        public int rankOf(K pObj) {
            return new OrderStatisticSet.OrderStatisticsSetProxy<K>(this.delegate.navigableKeySet()).rankOf(pObj);
        }

        @Override
        public OrderStatisticSet<K> navigableKeySet() {
            return new OrderStatisticSet.OrderStatisticsSetProxy(super.navigableKeySet());
        }

        @Override
        public OrderStatisticSet<K> descendingKeySet() {
            return new OrderStatisticSet.OrderStatisticsSetProxy(super.descendingKeySet());
        }

        @Override
        public OrderStatisticMap<K, V> descendingMap() {
            return new OrderStatisticsMapProxy<K, V>(super.descendingMap());
        }

        @Override
        public OrderStatisticMap<K, V> subMap(K fromKey, boolean fromInclusive, K toKey, boolean toInclusive) {
            return new OrderStatisticsMapProxy<K, V>(super.subMap(fromKey, fromInclusive, toKey, toInclusive));
        }

        @Override
        public OrderStatisticMap<K, V> headMap(K toKey, boolean inclusive) {
            return new OrderStatisticsMapProxy<K, V>(super.headMap(toKey, inclusive));
        }

        @Override
        public OrderStatisticMap<K, V> tailMap(K fromKey, boolean inclusive) {
            return new OrderStatisticsMapProxy<K, V>(super.tailMap(fromKey, inclusive));
        }

        @Override
        public OrderStatisticMap<K, V> headMap(K toKey) {
            return this.headMap((Object)toKey, false);
        }

        @Override
        public OrderStatisticMap<K, V> subMap(K fromKey, K toKey) {
            return this.subMap((Object)fromKey, true, (Object)toKey, false);
        }

        @Override
        public OrderStatisticMap<K, V> tailMap(K fromKey) {
            return this.tailMap((Object)fromKey, true);
        }
    }
}

