/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.ForwardingNavigableSet;
import com.google.common.collect.Iterables;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Comparator;
import java.util.NavigableSet;

public interface OrderStatisticSet<T>
extends NavigableSet<T> {
    public T getByRank(int var1);

    @CanIgnoreReturnValue
    public T removeByRank(int var1);

    public int rankOf(T var1);

    @Override
    public OrderStatisticSet<T> descendingSet();

    @Override
    public OrderStatisticSet<T> subSet(T var1, boolean var2, T var3, boolean var4);

    @Override
    public OrderStatisticSet<T> headSet(T var1, boolean var2);

    @Override
    public OrderStatisticSet<T> tailSet(T var1, boolean var2);

    @Override
    public OrderStatisticSet<T> subSet(T var1, T var2);

    @Override
    public OrderStatisticSet<T> headSet(T var1);

    @Override
    public OrderStatisticSet<T> tailSet(T var1);

    public static class OrderStatisticsSetProxy<E>
    extends ForwardingNavigableSet<E>
    implements OrderStatisticSet<E> {
        private final NavigableSet<E> delegate;

        OrderStatisticsSetProxy(NavigableSet<E> pDelegate) {
            this.delegate = pDelegate;
        }

        protected NavigableSet<E> delegate() {
            return this.delegate;
        }

        @Override
        public E getByRank(int pIndex) {
            return (E)Iterables.get(this.delegate, (int)pIndex);
        }

        @Override
        @CanIgnoreReturnValue
        public E removeByRank(int pIndex) {
            E elem = this.getByRank(pIndex);
            Preconditions.checkState((boolean)this.delegate.remove(elem), (Object)"Element could be retrieved, but not deleted");
            return elem;
        }

        @Override
        public int rankOf(E pObj) {
            return Iterables.indexOf(this.delegate, o -> this.compare(o, pObj) == 0);
        }

        private int compare(E pO1, E pO2) {
            Comparator comparator = this.comparator();
            if (comparator != null) {
                return comparator.compare(pO1, pO2);
            }
            return ((Comparable)pO1).compareTo(pO2);
        }

        @Override
        public OrderStatisticSet<E> descendingSet() {
            return new OrderStatisticsSetProxy<E>(super.descendingSet());
        }

        @Override
        public OrderStatisticSet<E> subSet(E fromElement, boolean fromInclusive, E toElement, boolean toInclusive) {
            return new OrderStatisticsSetProxy<E>(super.subSet(fromElement, fromInclusive, toElement, toInclusive));
        }

        @Override
        public OrderStatisticSet<E> headSet(E toElement, boolean inclusive) {
            return new OrderStatisticsSetProxy<E>(super.headSet(toElement, inclusive));
        }

        @Override
        public OrderStatisticSet<E> tailSet(E fromElement, boolean inclusive) {
            return new OrderStatisticsSetProxy<E>(super.tailSet(fromElement, inclusive));
        }

        @Override
        public OrderStatisticSet<E> headSet(E toElement) {
            return this.headSet((Object)toElement, false);
        }

        @Override
        public OrderStatisticSet<E> subSet(E fromElement, E toElement) {
            return this.subSet((Object)fromElement, true, (Object)toElement, false);
        }

        @Override
        public OrderStatisticSet<E> tailSet(E fromElement) {
            return this.tailSet((Object)fromElement, true);
        }
    }
}

