/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import java.math.BigInteger;
import java.util.Set;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.ast.FileLocation;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpressionBuilder;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CIntegerLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CUnaryExpression;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.cfa.types.c.CNumericTypes;
import org.sosy_lab.cpachecker.cfa.types.c.CSimpleType;
import org.sosy_lab.cpachecker.exceptions.UnrecognizedCodeException;

public class OverflowAssumptionManager {
    private final CBinaryExpressionBuilder cBinaryExpressionBuilder;
    private final MachineModel machineModel;

    public OverflowAssumptionManager(MachineModel pMachineModel, LogManager pLogger) {
        this.cBinaryExpressionBuilder = new CBinaryExpressionBuilder(pMachineModel, pLogger);
        this.machineModel = pMachineModel;
    }

    public CExpression getUpperAssumption(CExpression operand1, CExpression operand2, CBinaryExpression.BinaryOperator operator, CLiteralExpression max) throws UnrecognizedCodeException {
        return this.getAdditiveAssumption(operand1, operand2, operator, max, true);
    }

    public CExpression getLowerAssumption(CExpression operand1, CExpression operand2, CBinaryExpression.BinaryOperator operator, CLiteralExpression min) throws UnrecognizedCodeException {
        return this.getAdditiveAssumption(operand1, operand2, operator, min, false);
    }

    public CExpression getConjunctionOfAdditiveAssumptions(CExpression operand1, CExpression operand2, CBinaryExpression.BinaryOperator operator, CSimpleType type, boolean negate) throws UnrecognizedCodeException {
        CBinaryExpression assumption = this.cBinaryExpressionBuilder.buildBinaryExpression(this.getLowerAssumption(operand1, operand2, operator, this.getLowerBound(type)), this.getUpperAssumption(operand1, operand2, operator, this.getUpperBound(type)), CBinaryExpression.BinaryOperator.BINARY_AND);
        if (negate) {
            assumption = this.cBinaryExpressionBuilder.buildBinaryExpression(assumption, CIntegerLiteralExpression.ZERO, CBinaryExpression.BinaryOperator.EQUALS);
        }
        return assumption;
    }

    public CExpression getConjunctionOfMultiplicationAssumptions(CExpression operand1, CExpression operand2, CSimpleType type, boolean negate) throws UnrecognizedCodeException {
        Set<CExpression> assumptions = this.addMultiplicationAssumptions(operand1, operand2, this.getLowerBound(type), this.getUpperBound(type));
        CExpression result = (CExpression)FluentIterable.from(assumptions).get(0);
        for (CExpression assumption : FluentIterable.from(assumptions).skip(1)) {
            result = this.cBinaryExpressionBuilder.buildBinaryExpression(assumption, result, CBinaryExpression.BinaryOperator.BINARY_AND);
        }
        if (negate) {
            result = this.cBinaryExpressionBuilder.buildBinaryExpression(result, CIntegerLiteralExpression.ZERO, CBinaryExpression.BinaryOperator.EQUALS);
        }
        return result;
    }

    public CExpression getResultOfOperation(CExpression operand1, CExpression operand2, CBinaryExpression.BinaryOperator operator) throws UnrecognizedCodeException {
        return this.cBinaryExpressionBuilder.buildBinaryExpression(operand1, operand2, operator);
    }

    public CExpression getAdditiveAssumption(CExpression operand1, CExpression operand2, CBinaryExpression.BinaryOperator operator, CLiteralExpression limit, boolean isUpperLimit) throws UnrecognizedCodeException {
        boolean isMinusMode;
        boolean bl = isMinusMode = operator == CBinaryExpression.BinaryOperator.MINUS;
        assert (isMinusMode || operator == CBinaryExpression.BinaryOperator.PLUS) : "operator has to be either BinaryOperator.PLUS or BinaryOperator.MINUS!";
        CBinaryExpression.BinaryOperator term1Operator = isUpperLimit ^ isMinusMode ? CBinaryExpression.BinaryOperator.LESS_EQUAL : CBinaryExpression.BinaryOperator.GREATER_EQUAL;
        CBinaryExpression term1 = this.cBinaryExpressionBuilder.buildBinaryExpression(operand2, CIntegerLiteralExpression.ZERO, term1Operator);
        CBinaryExpression.BinaryOperator term2Operator = isMinusMode ? CBinaryExpression.BinaryOperator.PLUS : CBinaryExpression.BinaryOperator.MINUS;
        CBinaryExpression term2 = this.cBinaryExpressionBuilder.buildBinaryExpression(limit, operand2, term2Operator);
        CBinaryExpression.BinaryOperator term3Operator = isUpperLimit ? CBinaryExpression.BinaryOperator.LESS_EQUAL : CBinaryExpression.BinaryOperator.GREATER_EQUAL;
        CBinaryExpression term3 = this.cBinaryExpressionBuilder.buildBinaryExpression(operand1, term2, term3Operator);
        CBinaryExpression assumption = this.cBinaryExpressionBuilder.buildBinaryExpression(term1, term3, CBinaryExpression.BinaryOperator.BINARY_OR);
        return assumption;
    }

    public Set<CExpression> addMultiplicationAssumptions(CExpression operand1, CExpression operand2, CLiteralExpression pLowerLimit, CLiteralExpression pUpperLimit) throws UnrecognizedCodeException {
        ImmutableSet.Builder result = ImmutableSet.builder();
        for (boolean operand1isFirstOperand : new boolean[]{false, true}) {
            CExpression firstOperand = operand1isFirstOperand ? operand1 : operand2;
            CExpression secondOperand = operand1isFirstOperand ? operand2 : operand1;
            for (boolean usesUpperLimit : new boolean[]{false, true}) {
                CLiteralExpression limit = usesUpperLimit ? pUpperLimit : pLowerLimit;
                CBinaryExpression.BinaryOperator term1Operator = usesUpperLimit && operand1isFirstOperand ? CBinaryExpression.BinaryOperator.GREATER_EQUAL : CBinaryExpression.BinaryOperator.LESS_EQUAL;
                CBinaryExpression term1 = this.cBinaryExpressionBuilder.buildBinaryExpression(firstOperand, CIntegerLiteralExpression.ZERO, term1Operator);
                CBinaryExpression term2 = this.cBinaryExpressionBuilder.buildBinaryExpression(limit, firstOperand, CBinaryExpression.BinaryOperator.DIVIDE);
                CBinaryExpression.BinaryOperator term3Operator = usesUpperLimit && !operand1isFirstOperand ? CBinaryExpression.BinaryOperator.LESS_EQUAL : CBinaryExpression.BinaryOperator.GREATER_EQUAL;
                CBinaryExpression term3 = this.cBinaryExpressionBuilder.buildBinaryExpression(secondOperand, term2, term3Operator);
                CBinaryExpression assumption = this.cBinaryExpressionBuilder.buildBinaryExpression(term1, term3, CBinaryExpression.BinaryOperator.BINARY_OR);
                result.add((Object)assumption);
            }
        }
        return result.build();
    }

    public void addDivisionAssumption(CExpression operand1, CExpression operand2, CLiteralExpression limit, Set<CExpression> result) throws UnrecognizedCodeException {
        CBinaryExpression term1 = this.cBinaryExpressionBuilder.buildBinaryExpression(operand1, limit, CBinaryExpression.BinaryOperator.NOT_EQUALS);
        CUnaryExpression term2 = new CUnaryExpression(FileLocation.DUMMY, CNumericTypes.INT, CIntegerLiteralExpression.ZERO, CUnaryExpression.UnaryOperator.MINUS);
        CBinaryExpression term3 = this.cBinaryExpressionBuilder.buildBinaryExpression(operand2, term2, CBinaryExpression.BinaryOperator.NOT_EQUALS);
        CBinaryExpression assumption = this.cBinaryExpressionBuilder.buildBinaryExpression(term1, term3, CBinaryExpression.BinaryOperator.BINARY_OR);
        result.add(assumption);
    }

    public void addLeftShiftAssumptions(CExpression operand1, CExpression operand2, CLiteralExpression limit, Set<CExpression> result) throws UnrecognizedCodeException {
        CBinaryExpression term1 = this.cBinaryExpressionBuilder.buildBinaryExpression(limit, operand2, CBinaryExpression.BinaryOperator.SHIFT_RIGHT);
        result.add(this.cBinaryExpressionBuilder.buildBinaryExpression(operand1, term1, CBinaryExpression.BinaryOperator.LESS_EQUAL));
    }

    public static BigInteger getWidthForMaxOf(BigInteger pMax) {
        return BigInteger.valueOf(pMax.bitLength() + 1);
    }

    public CExpression getNegationAssumption(CExpression operand, CLiteralExpression limit) throws UnrecognizedCodeException {
        return this.cBinaryExpressionBuilder.buildBinaryExpression(operand, limit, CBinaryExpression.BinaryOperator.NOT_EQUALS);
    }

    public CLiteralExpression getUpperBound(CSimpleType type) {
        return new CIntegerLiteralExpression(FileLocation.DUMMY, type, this.machineModel.getMaximalIntegerValue(type));
    }

    public CLiteralExpression getLowerBound(CSimpleType type) {
        return new CIntegerLiteralExpression(FileLocation.DUMMY, type, this.machineModel.getMinimalIntegerValue(type));
    }
}

