/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;

public class Pair<A, B>
implements Serializable {
    private static final long serialVersionUID = -8410959888808077296L;
    private final @Nullable A first;
    private final @Nullable B second;

    private Pair(@Nullable A first, @Nullable B second) {
        this.first = first;
        this.second = second;
    }

    public static <A, B> Pair<A, B> of(@Nullable A first, @Nullable B second) {
        return new Pair<A, B>(first, second);
    }

    public @Nullable A getFirst() {
        return this.first;
    }

    public @Nullable B getSecond() {
        return this.second;
    }

    public A getFirstNotNull() {
        Preconditions.checkNotNull(this.first);
        return this.first;
    }

    public B getSecondNotNull() {
        Preconditions.checkNotNull(this.second);
        return this.second;
    }

    public String toString() {
        return "(" + this.first + ", " + this.second + ")";
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof Pair && Objects.equals(this.first, ((Pair)other).first) && Objects.equals(this.second, ((Pair)other).second);
    }

    public int hashCode() {
        if (this.first == null) {
            return this.second == null ? 0 : this.second.hashCode() + 1;
        }
        if (this.second == null) {
            return this.first.hashCode() + 2;
        }
        return this.first.hashCode() * 17 + this.second.hashCode();
    }

    public static <A, B> List<Pair<A, B>> zipList(Collection<? extends A> a, Collection<? extends B> b) {
        ArrayList<Pair<A, B>> result = new ArrayList<Pair<A, B>>(a.size());
        Iterator<A> iteratorA = a.iterator();
        Iterator<B> iteratorB = b.iterator();
        while (iteratorA.hasNext()) {
            Preconditions.checkArgument((boolean)iteratorB.hasNext(), (Object)"Second list is shorter");
            result.add(Pair.of(iteratorA.next(), iteratorB.next()));
        }
        Preconditions.checkArgument((!iteratorB.hasNext() ? 1 : 0) != 0, (Object)"Second list is longer");
        return result;
    }
}

