/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util;

import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.graph.Traverser;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.WrapperPrecision;

public class Precisions {
    private Precisions() {
    }

    public static <T extends Precision> T extractPrecisionByType(Precision pPrecision, Class<T> pType) {
        if (pType.isInstance(pPrecision)) {
            return (T)((Precision)pType.cast(pPrecision));
        }
        if (pPrecision instanceof WrapperPrecision) {
            return ((WrapperPrecision)pPrecision).retrieveWrappedPrecision(pType);
        }
        return null;
    }

    public static FluentIterable<Precision> asIterable(Precision prec) {
        return FluentIterable.from((Iterable)Traverser.forTree(precision -> precision instanceof WrapperPrecision ? ((WrapperPrecision)precision).getWrappedPrecisions() : ImmutableList.of()).depthFirstPreOrder((Object)prec));
    }

    public static Precision replaceByType(Precision pOldPrecision, Precision pNewPrecision, Predicate<? super Precision> pPrecisionType) {
        if (pOldPrecision instanceof WrapperPrecision) {
            return ((WrapperPrecision)pOldPrecision).replaceWrappedPrecision(pNewPrecision, pPrecisionType);
        }
        assert (pNewPrecision.getClass().isAssignableFrom(pOldPrecision.getClass()));
        return pNewPrecision;
    }
}

