/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.base.Verify;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.SetMultimap;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.stream.Stream;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.FileOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.io.IO;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.FunctionEntryNode;
import org.sosy_lab.cpachecker.cfa.model.FunctionExitNode;
import org.sosy_lab.cpachecker.core.CPAcheckerResult;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.FormulaReportingState;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.interfaces.StatisticsProvider;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.predicates.smt.BooleanFormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.smt.FormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.smt.Solver;
import org.sosy_lab.java_smt.api.BooleanFormula;

@Options(prefix="statesToFormulas")
public class StateToFormulaWriter
implements StatisticsProvider {
    @Option(secure=true, description="export abstract states as formula, e.g. for re-using them as PredicatePrecision.")
    @FileOption(value=FileOption.Type.OUTPUT_FILE)
    private Path exportFile = null;
    @Option(secure=true, description="instead of writing the exact state-representation as a single formula, write its atoms as a list of formulas. Therefore we ignore operators for conjunction and disjunction.")
    private FormulaSplitter splitFormulas = FormulaSplitter.LOCATION;
    @Option(secure=true, description="export formulas for all program locations or just the important locations,which include loop-heads, funtion-calls and function-exits.")
    private boolean exportOnlyImporantLocations = false;
    private static final Splitter LINE_SPLITTER = Splitter.on((char)'\n').omitEmptyStrings();
    private static final Joiner LINE_JOINER = Joiner.on((char)'\n');
    private final FormulaManagerView fmgr;
    private final LogManager logger;
    private final CFA cfa;

    public StateToFormulaWriter(Configuration config, LogManager pLogger, ShutdownNotifier shutdownNotifier, CFA pCfa) throws InvalidConfigurationException {
        config.inject((Object)this);
        this.logger = pLogger;
        this.cfa = pCfa;
        if (this.exportFile != null) {
            Solver solver = Solver.create(config, pLogger, shutdownNotifier);
            this.fmgr = solver.getFormulaManager();
        } else {
            this.fmgr = null;
        }
    }

    @Override
    public void collectStatistics(Collection<Statistics> pStatsCollection) {
        if (this.exportFile != null) {
            pStatsCollection.add(new Statistics(){

                @Override
                public void printStatistics(PrintStream pOut, CPAcheckerResult.Result pResult, UnmodifiableReachedSet pReached) {
                }

                @Override
                public void writeOutputFiles(CPAcheckerResult.Result pResult, UnmodifiableReachedSet pReached) {
                    Verify.verify((StateToFormulaWriter.this.fmgr != null ? 1 : 0) != 0);
                    try (Writer w = IO.openOutputFile((Path)StateToFormulaWriter.this.exportFile, (Charset)Charset.defaultCharset(), (OpenOption[])new OpenOption[0]);){
                        StateToFormulaWriter.this.write(pReached, (Appendable)w);
                    }
                    catch (IOException e) {
                        StateToFormulaWriter.this.logger.logUserException(Level.WARNING, (Throwable)e, "Could not write formulas to file");
                    }
                }

                @Override
                public String getName() {
                    return null;
                }
            });
        }
    }

    private void write(UnmodifiableReachedSet pReachedSet, Appendable pAppendable) throws IOException {
        HashMultimap locationPredicates = HashMultimap.create();
        for (AbstractState state : pReachedSet) {
            CFANode location = AbstractStates.extractLocation(state);
            if (location == null || !this.isImportantNode(location)) continue;
            FluentIterable formulaState = AbstractStates.asIterable(state).filter(FormulaReportingState.class);
            locationPredicates.putAll((Object)location, (Iterable)formulaState);
        }
        this.write((SetMultimap<CFANode, FormulaReportingState>)locationPredicates, pAppendable);
    }

    private boolean isImportantNode(CFANode location) {
        if (this.exportOnlyImporantLocations) {
            return this.cfa.getAllLoopHeads().isPresent() && this.cfa.getAllLoopHeads().orElseThrow().contains((Object)location) || location instanceof FunctionEntryNode || location instanceof FunctionExitNode || location.getLeavingSummaryEdge() != null || location.getEnteringSummaryEdge() != null;
        }
        return true;
    }

    private void write(CFANode pCfaNode, UnmodifiableReachedSet pReachedSet, Appendable pAppendable) throws IOException {
        HashMultimap statesToNode = HashMultimap.create();
        statesToNode.putAll((Object)pCfaNode, AbstractStates.projectToType(AbstractStates.filterLocation(pReachedSet, pCfaNode), FormulaReportingState.class));
        this.write((SetMultimap<CFANode, FormulaReportingState>)statesToNode, pAppendable);
    }

    private void write(SetMultimap<CFANode, FormulaReportingState> pStates, Appendable pAppendable) throws IOException {
        LinkedHashSet<String> definitions = new LinkedHashSet<String>();
        HashMultimap cfaNodeToPredicate = HashMultimap.create();
        for (CFANode cfaNode : pStates.keySet()) {
            this.getFormulasForNode(pStates.get((Object)cfaNode)).forEach(arg_0 -> this.lambda$write$0(cfaNode, definitions, (Multimap)cfaNodeToPredicate, arg_0));
        }
        this.writeFormulas(pAppendable, definitions, (Multimap<CFANode, String>)cfaNodeToPredicate);
    }

    private Stream<BooleanFormula> getFormulasForNode(Set<FormulaReportingState> states) {
        BooleanFormulaManagerView bfmgr = this.fmgr.getBooleanFormulaManager();
        Stream<Object> formulas = states.stream().map(state -> state.getFormulaApproximation(this.fmgr));
        switch (this.splitFormulas) {
            case LOCATION: {
                formulas = Stream.of(formulas.collect(bfmgr.toDisjunction()));
                break;
            }
            case STATE: {
                break;
            }
            case ATOM: {
                formulas = formulas.flatMap(f -> this.fmgr.extractAtoms((BooleanFormula)f, false).stream());
                break;
            }
            default: {
                throw new AssertionError((Object)"unknown option");
            }
        }
        return formulas.filter(f -> !bfmgr.isTrue((BooleanFormula)f) && !bfmgr.isFalse((BooleanFormula)f));
    }

    private void extractPredicatesAndDefinitions(CFANode cfaNode, Set<String> definitions, Multimap<CFANode, String> cfaNodeToPredicate, BooleanFormula predicate) {
        List lines = LINE_SPLITTER.splitToList((CharSequence)this.fmgr.dumpFormula(predicate).toString());
        String predString = (String)lines.get(lines.size() - 1);
        if (!predString.startsWith("(assert ") || !predString.endsWith(")")) {
            throw new AssertionError((Object)"Writing formulas is only supported for solvers that support the Smtlib2 format, please try using Mathsat5.");
        }
        definitions.addAll(lines.subList(0, lines.size() - 1));
        cfaNodeToPredicate.put((Object)cfaNode, (Object)predString);
    }

    private void writeFormulas(Appendable pAppendable, Set<String> definitions, Multimap<CFANode, String> cfaNodeToPredicate) throws IOException {
        LINE_JOINER.appendTo(pAppendable, definitions);
        pAppendable.append("\n\n");
        for (CFANode cfaNode : cfaNodeToPredicate.keySet()) {
            pAppendable.append(StateToFormulaWriter.toKey(cfaNode));
            pAppendable.append(":\n");
            LINE_JOINER.appendTo(pAppendable, (Iterable)cfaNodeToPredicate.get((Object)cfaNode));
            pAppendable.append("\n\n");
        }
    }

    private static String toKey(CFANode pCfaNode) {
        return pCfaNode.getFunctionName() + " " + pCfaNode;
    }

    private /* synthetic */ void lambda$write$0(CFANode cfaNode, Set definitions, Multimap cfaNodeToPredicate, BooleanFormula f) {
        this.extractPredicatesAndDefinitions(cfaNode, definitions, (Multimap<CFANode, String>)cfaNodeToPredicate, f);
    }

    public static enum FormulaSplitter {
        LOCATION,
        STATE,
        ATOM;

    }
}

