/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.HashSet;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.model.AssumeEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.util.CFAUtils;
import org.sosy_lab.cpachecker.util.Pair;

@Options(prefix="staticRefiner")
public abstract class StaticRefiner {
    @Option(secure=true, description="collect at most this number of assumes along a path, backwards from each target (= error) location")
    private int maxBackscanPathAssumes = 1;
    protected final LogManager logger;

    protected StaticRefiner(Configuration pConfig, LogManager pLogger) throws InvalidConfigurationException {
        this.logger = pLogger;
        pConfig.inject((Object)this, StaticRefiner.class);
    }

    protected ListMultimap<CFANode, AssumeEdge> getTargetLocationAssumes(Collection<CFANode> targetNodes) {
        ArrayListMultimap result = ArrayListMultimap.create();
        if (targetNodes.isEmpty()) {
            return result;
        }
        for (CFANode targetNode : targetNodes) {
            ArrayDeque<Pair<CFANode, Integer>> queue = new ArrayDeque<Pair<CFANode, Integer>>();
            queue.add(Pair.of(targetNode, 0));
            HashSet<CFANode> explored = new HashSet<CFANode>();
            while (!queue.isEmpty()) {
                Pair v = (Pair)queue.pop();
                for (CFAEdge e : CFAUtils.enteringEdges((CFANode)v.getFirst())) {
                    int depthIncrease;
                    CFANode u = e.getPredecessor();
                    boolean isAssumeEdge = e instanceof AssumeEdge;
                    int n = depthIncrease = isAssumeEdge ? 1 : 0;
                    if (isAssumeEdge) {
                        AssumeEdge assume = (AssumeEdge)e;
                        if ((Integer)v.getSecond() >= this.maxBackscanPathAssumes) continue;
                        result.put((Object)targetNode, (Object)assume);
                    }
                    if (explored.contains(u)) continue;
                    queue.add(Pair.of(u, (Integer)v.getSecond() + depthIncrease));
                }
                explored.add((CFANode)v.getFirst());
            }
        }
        return result;
    }
}

