/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util;

import com.google.common.base.Preconditions;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.cfa.types.Type;
import org.sosy_lab.cpachecker.cfa.types.c.CPointerType;
import org.sosy_lab.cpachecker.cfa.types.c.CSimpleType;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.cfa.types.java.JBasicType;
import org.sosy_lab.cpachecker.cfa.types.java.JSimpleType;
import org.sosy_lab.cpachecker.cfa.types.java.JType;

public class Types {
    public static boolean canHoldAllValues(Type pHoldingType, Type pInnerType, MachineModel pMachineModel) {
        if (pHoldingType instanceof CType) {
            CSimpleType fromType;
            CSimpleType toType;
            Preconditions.checkArgument((boolean)(pInnerType instanceof CType));
            if (pHoldingType instanceof CPointerType) {
                toType = pMachineModel.getPointerEquivalentSimpleType();
            } else if (pHoldingType instanceof CSimpleType) {
                toType = (CSimpleType)pHoldingType;
            } else {
                return pHoldingType.equals(pInnerType);
            }
            if (pInnerType instanceof CPointerType) {
                fromType = pMachineModel.getPointerEquivalentSimpleType();
            } else if (pInnerType instanceof CSimpleType) {
                fromType = (CSimpleType)pInnerType;
            } else {
                return pHoldingType.equals(pInnerType);
            }
            return Types.canHoldAllValues(toType, fromType, pMachineModel);
        }
        assert (pHoldingType instanceof JType && pInnerType instanceof JType);
        return Types.canHoldAllValues((JType)pHoldingType, (JType)pInnerType);
    }

    private static boolean canHoldAllValues(CSimpleType pHoldingType, CSimpleType pInnerType, MachineModel pMachineModel) {
        boolean isHoldingTypeSigned = pMachineModel.isSigned(pHoldingType);
        boolean isInnerTypeSigned = pMachineModel.isSigned(pInnerType);
        boolean isHoldingTypeFloat = pHoldingType.getType().isFloatingPointType();
        boolean isInnerTypeFloat = pInnerType.getType().isFloatingPointType();
        if (isInnerTypeSigned && !isHoldingTypeSigned) {
            return false;
        }
        if (isInnerTypeFloat && !isHoldingTypeFloat) {
            return false;
        }
        int holdingBitSize = pMachineModel.getSizeof(pHoldingType) * pMachineModel.getSizeofCharInBits();
        int innerBitSize = pMachineModel.getSizeof(pInnerType) * pMachineModel.getSizeofCharInBits();
        if (innerBitSize > holdingBitSize) {
            return false;
        }
        if (isHoldingTypeSigned && !isInnerTypeSigned) {
            ++innerBitSize;
        }
        if (isHoldingTypeFloat && !isInnerTypeFloat) {
            holdingBitSize /= 2;
        }
        return holdingBitSize >= innerBitSize;
    }

    public static boolean canHoldAllValues(JType pHoldingType, JType pInnerType) {
        if (pHoldingType instanceof JSimpleType) {
            Preconditions.checkArgument((boolean)(pInnerType instanceof JSimpleType));
            return Types.canHoldAllValues((JSimpleType)pHoldingType, (JSimpleType)pInnerType);
        }
        return pHoldingType.equals(pInnerType);
    }

    private static boolean canHoldAllValues(JSimpleType pHoldingType, JSimpleType pInnerType) {
        JBasicType holdingType = pHoldingType.getType();
        JBasicType innerType = pInnerType.getType();
        boolean canHold = false;
        switch (innerType) {
            case BOOLEAN: {
                return holdingType == JBasicType.BOOLEAN;
            }
            case CHAR: {
                return holdingType == JBasicType.CHAR;
            }
            case BYTE: {
                canHold |= holdingType == JBasicType.BYTE;
            }
            case SHORT: {
                canHold |= holdingType == JBasicType.SHORT;
                canHold |= holdingType == JBasicType.FLOAT;
            }
            case INT: {
                canHold |= holdingType == JBasicType.INT;
                canHold |= holdingType == JBasicType.DOUBLE;
            }
            case LONG: {
                canHold |= holdingType == JBasicType.LONG;
                break;
            }
            case FLOAT: {
                canHold |= holdingType == JBasicType.FLOAT;
            }
            case DOUBLE: {
                canHold |= holdingType == JBasicType.DOUBLE;
                break;
            }
            default: {
                throw new AssertionError((Object)("Unhandled type " + pInnerType.getType()));
            }
        }
        return canHold;
    }
}

