/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util;

import com.google.common.truth.Truth;
import org.junit.Test;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.cfa.types.Type;
import org.sosy_lab.cpachecker.cfa.types.c.CNumericTypes;
import org.sosy_lab.cpachecker.util.Types;

public class TypesTest {
    MachineModel machineModel = MachineModel.LINUX32;

    @Test
    public void shortHoldsChar() {
        Truth.assertThat((Boolean)Types.canHoldAllValues((Type)CNumericTypes.SHORT_INT, (Type)CNumericTypes.CHAR, this.machineModel)).isTrue();
    }

    @Test
    public void intHoldsShort() {
        Truth.assertThat((Boolean)Types.canHoldAllValues((Type)CNumericTypes.INT, (Type)CNumericTypes.SHORT_INT, this.machineModel)).isTrue();
    }

    @Test
    public void doubleHoldsInt() {
        Truth.assertThat((Boolean)Types.canHoldAllValues((Type)CNumericTypes.DOUBLE, (Type)CNumericTypes.INT, this.machineModel)).isTrue();
    }

    @Test
    public void doubleHoldsFloat() {
        Truth.assertThat((Boolean)Types.canHoldAllValues((Type)CNumericTypes.DOUBLE, (Type)CNumericTypes.FLOAT, this.machineModel)).isTrue();
    }

    @Test
    public void intHoldsFloat() {
        Truth.assertThat((Boolean)Types.canHoldAllValues((Type)CNumericTypes.INT, (Type)CNumericTypes.FLOAT, this.machineModel)).isFalse();
    }

    @Test
    public void charHoldsLongLong() {
        Truth.assertThat((Boolean)Types.canHoldAllValues((Type)CNumericTypes.CHAR, (Type)CNumericTypes.LONG_LONG_INT, this.machineModel)).isFalse();
    }

    @Test
    public void signedIntHoldsUnsignedShort() {
        Truth.assertThat((Boolean)Types.canHoldAllValues((Type)CNumericTypes.SIGNED_INT, (Type)CNumericTypes.UNSIGNED_SHORT_INT, this.machineModel)).isTrue();
    }

    @Test
    public void unsignedHoldsSignedInt() {
        Truth.assertThat((Boolean)Types.canHoldAllValues((Type)CNumericTypes.UNSIGNED_INT, (Type)CNumericTypes.SIGNED_INT, this.machineModel)).isFalse();
    }

    @Test
    public void unsignedCharHoldsInt() {
        Truth.assertThat((Boolean)Types.canHoldAllValues((Type)CNumericTypes.UNSIGNED_CHAR, (Type)CNumericTypes.INT, this.machineModel)).isFalse();
    }
}

