/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.ConfigurationBuilder;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.ast.AExpression;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.FunctionEntryNode;
import org.sosy_lab.cpachecker.cfa.model.FunctionReturnEdge;
import org.sosy_lab.cpachecker.core.CPABuilder;
import org.sosy_lab.cpachecker.core.algorithm.CPAAlgorithm;
import org.sosy_lab.cpachecker.core.algorithm.bmc.candidateinvariants.CandidateInvariant;
import org.sosy_lab.cpachecker.core.algorithm.bmc.candidateinvariants.ExpressionTreeLocationInvariant;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.StateSpacePartition;
import org.sosy_lab.cpachecker.core.reachedset.AggregatedReachedSets;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSetFactory;
import org.sosy_lab.cpachecker.core.specification.Specification;
import org.sosy_lab.cpachecker.cpa.automaton.Automaton;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonInvariantsUtils;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonState;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.CFAUtils;
import org.sosy_lab.cpachecker.util.expressions.And;
import org.sosy_lab.cpachecker.util.expressions.ExpressionTree;
import org.sosy_lab.cpachecker.util.expressions.ExpressionTrees;
import org.sosy_lab.cpachecker.util.expressions.Or;
import org.sosy_lab.cpachecker.util.expressions.ToFormulaVisitor;

@Options(prefix="witness")
public class WitnessInvariantsExtractor {
    private Configuration config;
    private LogManager logger;
    private CFA cfa;
    private ShutdownNotifier shutdownNotifier;
    private ReachedSet reachedSet;
    private Specification automatonAsSpec;
    @Option(secure=true, name="debug.checkForMissedInvariants", description="Fail-fast if invariants in the witness exist that would not be accounted for. There are cases where unaccounted invariants are perfectly fine, e.g. if those states in the witness automaton are actually unreachable in the program. This is however rarely the intention of the original producer of the witness, so this options can be used to debug those cases.")
    private boolean checkForMissedInvariants = false;

    public WitnessInvariantsExtractor(Configuration pConfig, LogManager pLogger, CFA pCFA, ShutdownNotifier pShutdownNotifier, Path pPathToWitnessFile) throws InvalidConfigurationException, CPAException, InterruptedException {
        this.config = pConfig;
        this.config.inject((Object)this);
        this.logger = pLogger;
        this.cfa = pCFA;
        this.shutdownNotifier = pShutdownNotifier;
        this.automatonAsSpec = this.buildSpecification(pPathToWitnessFile);
        this.analyzeWitness();
    }

    public WitnessInvariantsExtractor(Configuration pConfig, Automaton pAutomaton, LogManager pLogger, CFA pCFA, ShutdownNotifier pShutdownNotifier) throws InvalidConfigurationException, CPAException, InterruptedException {
        this.config = pConfig;
        this.logger = pLogger;
        this.cfa = pCFA;
        this.shutdownNotifier = pShutdownNotifier;
        this.automatonAsSpec = Specification.fromAutomata((List<Automaton>)ImmutableList.of((Object)pAutomaton));
        this.analyzeWitness();
    }

    private Configuration generateLocalConfiguration(Configuration pConfig) throws InvalidConfigurationException {
        ConfigurationBuilder configBuilder = Configuration.builder().loadFromResource(WitnessInvariantsExtractor.class, "witness-analysis.properties");
        List<String> copyOptions = Arrays.asList("analysis.machineModel", "analysis.programNames", "cpa.callstack.skipRecursion", "cpa.callstack.skipVoidRecursion", "cpa.callstack.skipFunctionPointerRecursion");
        for (String copyOption : copyOptions) {
            configBuilder.copyOptionFromIfPresent(pConfig, copyOption);
        }
        return configBuilder.build();
    }

    private Specification buildSpecification(Path pathToWitnessFile) throws InvalidConfigurationException, InterruptedException {
        return Specification.fromFiles((Iterable<Path>)ImmutableList.of((Object)pathToWitnessFile), this.cfa, this.config, this.logger, this.shutdownNotifier);
    }

    private void analyzeWitness() throws InvalidConfigurationException, CPAException, InterruptedException {
        Configuration localConfig = this.generateLocalConfiguration(this.config);
        ReachedSetFactory reachedSetFactory = new ReachedSetFactory(localConfig, this.logger);
        CPABuilder builder = new CPABuilder(localConfig, this.logger, this.shutdownNotifier, reachedSetFactory);
        ConfigurableProgramAnalysis cpa = builder.buildCPAs(this.cfa, this.automatonAsSpec, AggregatedReachedSets.empty());
        CPAAlgorithm algorithm = CPAAlgorithm.create(cpa, this.logger, localConfig, this.shutdownNotifier);
        FunctionEntryNode rootNode = this.cfa.getMainFunction();
        StateSpacePartition partition = StateSpacePartition.getDefaultPartition();
        try {
            this.reachedSet = reachedSetFactory.createAndInitialize(cpa, rootNode, partition);
            algorithm.run(this.reachedSet);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (this.checkForMissedInvariants) {
            AutomatonInvariantsUtils.checkForMissedInvariants(this.automatonAsSpec, this.reachedSet);
        }
    }

    public Set<ExpressionTreeLocationInvariant> extractInvariantsFromReachedSet() throws InterruptedException {
        LinkedHashSet<ExpressionTreeLocationInvariant> invariants = new LinkedHashSet<ExpressionTreeLocationInvariant>();
        ConcurrentHashMap<ExpressionTreeLocationInvariant.ManagerKey, ToFormulaVisitor> toCodeVisitorCache = new ConcurrentHashMap<ExpressionTreeLocationInvariant.ManagerKey, ToFormulaVisitor>();
        for (AbstractState abstractState : this.reachedSet) {
            this.shutdownNotifier.shutdownIfNecessary();
            CFANode location = AbstractStates.extractLocation(abstractState);
            for (AutomatonState automatonState : AbstractStates.asIterable(abstractState).filter(AutomatonState.class)) {
                ExpressionTree<AExpression> candidate = automatonState.getCandidateInvariants();
                String groupId = automatonState.getInternalStateName();
                ExpressionTreeLocationInvariant previousInv = null;
                if (candidate.equals(ExpressionTrees.getTrue())) continue;
                for (ExpressionTreeLocationInvariant inv : invariants) {
                    if (!inv.getLocation().equals(location)) continue;
                    previousInv = inv;
                }
                ExpressionTree<Object> previousExpression = ExpressionTrees.getTrue();
                if (previousInv != null) {
                    ExpressionTree<Object> expr = previousInv.asExpressionTree();
                    previousExpression = expr;
                    invariants.remove(previousInv);
                }
                if (previousExpression.equals(ExpressionTrees.getTrue())) {
                    invariants.add(new ExpressionTreeLocationInvariant(groupId, location, candidate, toCodeVisitorCache));
                    continue;
                }
                invariants.add(new ExpressionTreeLocationInvariant(groupId, location, Or.of(previousExpression, candidate), toCodeVisitorCache));
            }
        }
        return invariants;
    }

    public void extractCandidatesFromReachedSet(Set<CandidateInvariant> pCandidates, Multimap<String, CFANode> pCandidateGroupLocations) throws InterruptedException {
        HashSet<ExpressionTreeLocationInvariant> expressionTreeLocationInvariants = new HashSet<ExpressionTreeLocationInvariant>();
        HashMap<String, ExpressionTree<AExpression>> expressionTrees = new HashMap<String, ExpressionTree<AExpression>>();
        HashSet visited = new HashSet();
        HashMultimap potentialAdditionalCandidates = HashMultimap.create();
        ConcurrentHashMap<ExpressionTreeLocationInvariant.ManagerKey, ToFormulaVisitor> toCodeVisitorCache = new ConcurrentHashMap<ExpressionTreeLocationInvariant.ManagerKey, ToFormulaVisitor>();
        for (AbstractState abstractState : this.reachedSet) {
            this.shutdownNotifier.shutdownIfNecessary();
            Iterable<CFANode> locations = AbstractStates.extractLocations(abstractState);
            Iterables.addAll(visited, locations);
            for (AutomatonState automatonState : AbstractStates.asIterable(abstractState).filter(AutomatonState.class)) {
                ExpressionTree<AExpression> candidate = automatonState.getCandidateInvariants();
                String groupId = automatonState.getInternalStateName();
                pCandidateGroupLocations.putAll((Object)groupId, locations);
                if (candidate.equals(ExpressionTrees.getTrue())) continue;
                ExpressionTree previous = (ExpressionTree)expressionTrees.get(groupId);
                if (previous == null) {
                    previous = ExpressionTrees.getTrue();
                }
                expressionTrees.put(groupId, And.of(previous, candidate));
                for (CFANode location : locations) {
                    potentialAdditionalCandidates.removeAll((Object)location);
                    ExpressionTreeLocationInvariant candidateInvariant = new ExpressionTreeLocationInvariant(groupId, location, candidate, toCodeVisitorCache);
                    expressionTreeLocationInvariants.add(candidateInvariant);
                    for (FunctionReturnEdge returnEdge : CFAUtils.leavingEdges(location).filter(FunctionReturnEdge.class)) {
                        CFANode successor = returnEdge.getSuccessor();
                        if (pCandidateGroupLocations.containsEntry((Object)groupId, (Object)successor) || visited.contains(successor)) continue;
                        potentialAdditionalCandidates.put((Object)successor, (Object)new ExpressionTreeLocationInvariant(groupId, successor, candidate, toCodeVisitorCache));
                    }
                }
            }
        }
        for (Map.Entry entry : potentialAdditionalCandidates.asMap().entrySet()) {
            if (visited.contains(entry.getKey())) continue;
            for (ExpressionTreeLocationInvariant candidateInvariant : (Collection)entry.getValue()) {
                pCandidateGroupLocations.put((Object)candidateInvariant.getGroupId(), (Object)((CFANode)entry.getKey()));
                expressionTreeLocationInvariants.add(candidateInvariant);
            }
        }
        for (ExpressionTreeLocationInvariant expressionTreeLocationInvariant : expressionTreeLocationInvariants) {
            for (CFANode location : pCandidateGroupLocations.get((Object)expressionTreeLocationInvariant.getGroupId())) {
                pCandidates.add(new ExpressionTreeLocationInvariant(expressionTreeLocationInvariant.getGroupId(), location, (ExpressionTree)expressionTrees.get(expressionTreeLocationInvariant.getGroupId()), toCodeVisitorCache));
            }
        }
    }
}

