/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.arrayabstraction;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.graph.EndpointPair;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CCfaTransformer;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.CfaMutableNetwork;
import org.sosy_lab.cpachecker.cfa.ast.AFunctionDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.FileLocation;
import org.sosy_lab.cpachecker.cfa.ast.c.CAstNode;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpressionAssignmentStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CIntegerLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CSimpleDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.SubstitutingCAstNodeVisitor;
import org.sosy_lab.cpachecker.cfa.model.BlankEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.CFATerminationNode;
import org.sosy_lab.cpachecker.cfa.model.FunctionCallEdge;
import org.sosy_lab.cpachecker.cfa.model.FunctionSummaryEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CAssumeEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CDeclarationEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionCallEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CStatementEdge;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.cfa.types.c.CNumericTypes;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.cpa.value.ValueAnalysisState;
import org.sosy_lab.cpachecker.util.arrayabstraction.ArrayAbstractionResult;
import org.sosy_lab.cpachecker.util.arrayabstraction.ArrayAccess;
import org.sosy_lab.cpachecker.util.arrayabstraction.CAstNodeSubstitution;
import org.sosy_lab.cpachecker.util.arrayabstraction.CfaSimplifications;
import org.sosy_lab.cpachecker.util.arrayabstraction.SpecialOperation;
import org.sosy_lab.cpachecker.util.arrayabstraction.TransformableArray;
import org.sosy_lab.cpachecker.util.arrayabstraction.TransformableLoop;
import org.sosy_lab.cpachecker.util.arrayabstraction.VariableGenerator;
import org.sosy_lab.cpachecker.util.dependencegraph.EdgeDefUseData;
import org.sosy_lab.cpachecker.util.states.MemoryLocation;

public class ArrayAbstraction {
    private ArrayAbstraction() {
    }

    private static BlankEdge createBlankEdge(AFunctionDeclaration pFunction, String pDescription) {
        return new BlankEdge("", FileLocation.DUMMY, new CFANode(pFunction), new CFANode(pFunction), pDescription);
    }

    private static CAssumeEdge createAssumeEdge(AFunctionDeclaration pFunction, CExpression pCondition, boolean pTruthAssumption) {
        return new CAssumeEdge("", pCondition.getFileLocation(), new CFANode(pFunction), new CFANode(pFunction), pCondition, pTruthAssumption);
    }

    private static ImmutableSet<TransformableArray> getLoopTransformableArrays(TransformableLoop pLoop, ImmutableMap<CSimpleDeclaration, TransformableArray> pTransformableArrayMap) {
        return (ImmutableSet)pLoop.getInnerLoopEdges().stream().flatMap(edge -> ArrayAccess.findArrayAccesses(edge).stream()).map(arrayAccess -> ArrayAbstraction.getTransformableArray(arrayAccess, pTransformableArrayMap)).flatMap(Optional::stream).collect(ImmutableSet.toImmutableSet());
    }

    private static ImmutableSet<CFAEdge> getTransformableEdges(CfaMutableNetwork pGraph, TransformableLoop pLoop) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (CFAEdge edge : pLoop.getInnerLoopEdges()) {
            builder.add((Object)edge);
            if (!(edge instanceof FunctionSummaryEdge)) continue;
            CFANode summaryEdgeNodeU = (CFANode)pGraph.incidentNodes(edge).nodeU();
            for (CFAEdge callEdge : pGraph.outEdges(summaryEdgeNodeU)) {
                if (!(callEdge instanceof FunctionCallEdge)) continue;
                builder.add((Object)callEdge);
            }
        }
        return builder.build();
    }

    private static Optional<CExpression> createIndexStepCondition(TransformableLoop.Index pIndex) {
        BigInteger updateStepValue = pIndex.getUpdateOperation().getStepValue();
        if (!updateStepValue.equals(BigInteger.ONE)) {
            CType indexType = pIndex.getVariableDeclaration().getType();
            CIdExpression indexExpression = new CIdExpression(FileLocation.DUMMY, pIndex.getVariableDeclaration());
            CIntegerLiteralExpression updateStepExpression = new CIntegerLiteralExpression(FileLocation.DUMMY, indexType, updateStepValue);
            CBinaryExpression indexRemainderExpression = new CBinaryExpression(FileLocation.DUMMY, indexType, indexType, indexExpression, updateStepExpression, CBinaryExpression.BinaryOperator.MODULO);
            BigInteger startValue = pIndex.getInitializeOperation().getValue();
            BigInteger remainder = startValue.remainder(updateStepValue);
            CIntegerLiteralExpression remainderExpression = new CIntegerLiteralExpression(FileLocation.DUMMY, indexType, remainder);
            CBinaryExpression condition = new CBinaryExpression(FileLocation.DUMMY, CNumericTypes.INT, indexType, indexRemainderExpression, remainderExpression, CBinaryExpression.BinaryOperator.EQUALS);
            return Optional.of(condition);
        }
        return Optional.empty();
    }

    private static ImmutableMultimap<TransformableArray, CExpression> getTransformableArraySubscriptExpressions(ImmutableMap<CSimpleDeclaration, TransformableArray> pTransformableArrayMap, TransformableLoop pLoop) {
        ImmutableSetMultimap.Builder builder = ImmutableSetMultimap.builder();
        for (CFAEdge edge : pLoop.getInnerLoopEdges()) {
            for (ArrayAccess arrayAccess : ArrayAccess.findArrayAccesses(edge)) {
                Optional<TransformableArray> optTransformableArray = ArrayAbstraction.getTransformableArray(arrayAccess, pTransformableArrayMap);
                if (!optTransformableArray.isPresent()) continue;
                builder.put((Object)optTransformableArray.orElseThrow(), (Object)arrayAccess.getSubscriptExpression());
            }
        }
        return builder.build();
    }

    private static boolean onlySingleUseNothingElse(EdgeDefUseData pEdgeDefUseData) {
        return pEdgeDefUseData.getUses().size() == 1 && pEdgeDefUseData.getPointeeUses().isEmpty() && pEdgeDefUseData.getDefs().isEmpty() && pEdgeDefUseData.getPointeeDefs().isEmpty();
    }

    private static ImmutableMap<TransformableArray, CExpression> insertTransformableArrayAssumes(CfaMutableNetwork pGraph, ImmutableMap<CSimpleDeclaration, TransformableArray> pTransformableArrayMap, TransformableLoop pLoop, ImmutableSet<TransformableArray> pLoopTransformableArrays, CFANode pLoopBodyEntryNode) {
        ImmutableMap.Builder arrayPreciseSubscriptExpressionBuilder = ImmutableMap.builder();
        TransformableLoop.Index index = pLoop.getIndex();
        ImmutableMultimap<TransformableArray, CExpression> transformableArraySubscriptExpressions = ArrayAbstraction.getTransformableArraySubscriptExpressions(pTransformableArrayMap, pLoop);
        EdgeDefUseData.Extractor extractor = EdgeDefUseData.createExtractor(true);
        ArrayList<CBinaryExpression> conditions = new ArrayList<CBinaryExpression>();
        for (TransformableArray transformableArray : pLoopTransformableArrays) {
            MemoryLocation subscriptUse;
            CExpression subscriptExpression;
            EdgeDefUseData subscriptDefUseData;
            CIdExpression arrayIndexIdExpression = new CIdExpression(FileLocation.DUMMY, transformableArray.getIndexDeclaration());
            ImmutableCollection subscriptExpressions = transformableArraySubscriptExpressions.get((Object)transformableArray);
            CExpression conditionOperand = null;
            if (subscriptExpressions.size() == 1 && ArrayAbstraction.onlySingleUseNothingElse(subscriptDefUseData = extractor.extract(subscriptExpression = (CExpression)subscriptExpressions.stream().findFirst().orElseThrow())) && (subscriptUse = (MemoryLocation)subscriptDefUseData.getUses().stream().findFirst().orElseThrow()).equals(MemoryLocation.forDeclaration(index.getVariableDeclaration()))) {
                conditionOperand = subscriptExpression;
            }
            if (conditionOperand == null) {
                conditionOperand = new CIdExpression(FileLocation.DUMMY, index.getVariableDeclaration());
            }
            arrayPreciseSubscriptExpressionBuilder.put((Object)transformableArray, conditionOperand);
            CBinaryExpression conditionExpression = new CBinaryExpression(FileLocation.DUMMY, CNumericTypes.INT, index.getVariableDeclaration().getType(), arrayIndexIdExpression, conditionOperand, CBinaryExpression.BinaryOperator.EQUALS);
            conditions.add(conditionExpression);
        }
        AFunctionDeclaration function = pLoopBodyEntryNode.getFunction();
        for (CExpression condition : conditions) {
            CAssumeEdge enterBodyEdge = ArrayAbstraction.createAssumeEdge(function, condition, true);
            pGraph.insertSuccessor(pLoopBodyEntryNode, new CFANode(function), enterBodyEdge);
            CAssumeEdge falseEdge = ArrayAbstraction.createAssumeEdge(function, condition, false);
            pGraph.addEdge(pLoopBodyEntryNode, new CFATerminationNode(function), falseEdge);
        }
        return arrayPreciseSubscriptExpressionBuilder.buildOrThrow();
    }

    private static ArrayAbstractionResult.Status loopTransformable(ImmutableMap<CSimpleDeclaration, TransformableArray> pTransformableArrayMap, TransformableLoop pLoop) {
        ImmutableSet innerLoopDeclarations = (ImmutableSet)pLoop.getInnerLoopDeclarations().stream().map(MemoryLocation::forDeclaration).collect(ImmutableSet.toImmutableSet());
        MemoryLocation loopIndexMemLoc = MemoryLocation.forDeclaration(pLoop.getIndex().getVariableDeclaration());
        EdgeDefUseData.Extractor defUseDataExtractor = EdgeDefUseData.createExtractor(true);
        for (CFAEdge edge : pLoop.getInnerLoopEdges()) {
            HashSet<MemoryLocation> arrayMemoryLocations = new HashSet<MemoryLocation>();
            for (CSimpleDeclaration arrayDeclaration : ArrayAccess.findArrayOccurences(edge)) {
                if (!pTransformableArrayMap.containsKey((Object)arrayDeclaration)) {
                    return ArrayAbstractionResult.Status.UNCHANGED;
                }
                arrayMemoryLocations.add(MemoryLocation.forDeclaration(arrayDeclaration));
            }
            EdgeDefUseData edgeDefUseData = defUseDataExtractor.extract(edge);
            for (MemoryLocation def : edgeDefUseData.getDefs()) {
                if (innerLoopDeclarations.contains((Object)def) || arrayMemoryLocations.contains(def) || def.equals(loopIndexMemLoc)) continue;
                return ArrayAbstractionResult.Status.UNCHANGED;
            }
            if (edgeDefUseData.getPointeeDefs().isEmpty()) continue;
            return ArrayAbstractionResult.Status.UNCHANGED;
        }
        return ArrayAbstractionResult.Status.PRECISE;
    }

    private static void insertLoopConditions(CfaMutableNetwork pGraph, ImmutableSet<TransformableArray> pLoopTransformableArrays, TransformableLoop pLoop, CFANode pBodyEntryNode, CFANode pBodyExitNode) {
        CBinaryExpression.BinaryOperator endBinaryOperator;
        CBinaryExpression.BinaryOperator startBinaryOperator;
        AFunctionDeclaration function = pLoop.getLoopNode().getFunction();
        TransformableLoop.Index index = pLoop.getIndex();
        TransformableArray anyTransformableArray = (TransformableArray)pLoopTransformableArrays.stream().findFirst().orElseThrow();
        CIdExpression loopIndexIdExpression = new CIdExpression(FileLocation.DUMMY, index.getVariableDeclaration());
        CIdExpression anyTransformableArrayIndex = new CIdExpression(FileLocation.DUMMY, anyTransformableArray.getIndexDeclaration());
        CExpressionAssignmentStatement indexInitStatement = new CExpressionAssignmentStatement(FileLocation.DUMMY, loopIndexIdExpression, anyTransformableArrayIndex);
        CStatementEdge indexInitStatementEdge = new CStatementEdge("", indexInitStatement, FileLocation.DUMMY, new CFANode(function), new CFANode(function));
        pGraph.insertPredecessor(new CFANode(function), pBodyEntryNode, indexInitStatementEdge);
        ArrayList<CBinaryExpression> conditions = new ArrayList<CBinaryExpression>();
        CIntegerLiteralExpression indexStartValueExpression = new CIntegerLiteralExpression(FileLocation.DUMMY, index.getVariableDeclaration().getType(), index.getInitializeOperation().getValue());
        CIntegerLiteralExpression indexEndValueExpression = new CIntegerLiteralExpression(FileLocation.DUMMY, index.getVariableDeclaration().getType(), index.getComparisonOperation().getValue());
        if (index.isIncreasing()) {
            assert (index.getComparisonOperation().getOperator() == SpecialOperation.ConstantComparison.Operator.LESS_EQUAL);
            startBinaryOperator = CBinaryExpression.BinaryOperator.GREATER_EQUAL;
            endBinaryOperator = CBinaryExpression.BinaryOperator.LESS_EQUAL;
        } else {
            assert (index.isDecreasing());
            assert (index.getComparisonOperation().getOperator() == SpecialOperation.ConstantComparison.Operator.GREATER_EQUAL);
            startBinaryOperator = CBinaryExpression.BinaryOperator.LESS_EQUAL;
            endBinaryOperator = CBinaryExpression.BinaryOperator.GREATER_EQUAL;
        }
        conditions.add(new CBinaryExpression(FileLocation.DUMMY, CNumericTypes.INT, index.getVariableDeclaration().getType(), loopIndexIdExpression, indexStartValueExpression, startBinaryOperator));
        conditions.add(new CBinaryExpression(FileLocation.DUMMY, CNumericTypes.INT, index.getVariableDeclaration().getType(), loopIndexIdExpression, indexEndValueExpression, endBinaryOperator));
        ArrayAbstraction.createIndexStepCondition(index).ifPresent(conditions::add);
        Collections.reverse(conditions);
        for (CExpression cExpression : conditions) {
            CAssumeEdge enterBodyEdge = ArrayAbstraction.createAssumeEdge(function, cExpression, true);
            pGraph.insertSuccessor(pBodyEntryNode, new CFANode(function), enterBodyEdge);
            CAssumeEdge skipBodyEdge = ArrayAbstraction.createAssumeEdge(function, cExpression, false);
            pGraph.addEdge(pBodyEntryNode, pBodyExitNode, skipBodyEdge);
        }
    }

    private static ArrayAbstractionResult.Status transformLoop(CfaMutableNetwork pGraph, ImmutableMap<CSimpleDeclaration, TransformableArray> pTransformableArrayMap, CFA pCfa, LogManager pLogger, TransformableLoop pLoop) {
        ArrayAbstractionResult.Status status = ArrayAbstraction.loopTransformable(pTransformableArrayMap, pLoop);
        if (status == ArrayAbstractionResult.Status.UNCHANGED) {
            return status;
        }
        CFANode loopNode = pLoop.getLoopNode();
        CFAEdge loopIncomingEdge = pLoop.getIncomingEdge();
        CFAEdge loopOutgoingEdge = pLoop.getOutgoingEdge();
        CFAEdge loopBodyFirstEdge = null;
        CFAEdge loopBodyLastEdge = null;
        for (CFAEdge edge : pGraph.incidentEdges(loopNode)) {
            if (((CFANode)pGraph.incidentNodes(edge).nodeU()).equals(loopNode) && !edge.equals(loopOutgoingEdge)) {
                loopBodyFirstEdge = edge;
            }
            if (!((CFANode)pGraph.incidentNodes(edge).nodeV()).equals(loopNode) || edge.equals(loopIncomingEdge)) continue;
            loopBodyLastEdge = edge;
        }
        CFANode loopBodyFirstEdgeNodeV = (CFANode)pGraph.incidentNodes(loopBodyFirstEdge).nodeV();
        CFANode loopOutgoingEdgeNodeV = (CFANode)pGraph.incidentNodes(loopOutgoingEdge).nodeV();
        pGraph.removeEdge(loopBodyFirstEdge);
        pGraph.removeEdge(loopOutgoingEdge);
        CFANode loopIncomingEdgeNodeU = (CFANode)pGraph.incidentNodes(loopIncomingEdge).nodeU();
        pGraph.removeEdge(loopIncomingEdge);
        pGraph.addEdge(loopIncomingEdgeNodeU, loopBodyFirstEdgeNodeV, loopIncomingEdge);
        CFANode loopBodyLastEdgeNodeU = (CFANode)pGraph.incidentNodes(loopBodyLastEdge).nodeU();
        pGraph.removeEdge(loopBodyLastEdge);
        pGraph.addEdge(loopBodyLastEdgeNodeU, loopOutgoingEdgeNodeV, loopBodyLastEdge);
        ImmutableSet<TransformableArray> loopTransformableArrays = ArrayAbstraction.getLoopTransformableArrays(pLoop, pTransformableArrayMap);
        assert (loopTransformableArrays.size() >= 1);
        CFANode bodyEntryNode = loopBodyFirstEdgeNodeV;
        CFANode bodyExitNode = loopOutgoingEdgeNodeV;
        ImmutableMap<TransformableArray, CExpression> preciseArraySubscriptExpressions = ArrayAbstraction.insertTransformableArrayAssumes(pGraph, pTransformableArrayMap, pLoop, loopTransformableArrays, bodyEntryNode);
        for (CFAEdge edge : ArrayAbstraction.getTransformableEdges(pGraph, pLoop)) {
            ArrayAbstractionResult.Status edgeTransformationStatus = ArrayAbstraction.transformEdge(pGraph, pTransformableArrayMap, pCfa, pLogger, edge, Optional.of(pLoop), Optional.of(preciseArraySubscriptExpressions));
            if (edgeTransformationStatus == ArrayAbstractionResult.Status.UNCHANGED) {
                return ArrayAbstractionResult.Status.UNCHANGED;
            }
            if (edgeTransformationStatus != ArrayAbstractionResult.Status.IMPRECISE) continue;
            status = ArrayAbstractionResult.Status.IMPRECISE;
        }
        ArrayAbstraction.insertLoopConditions(pGraph, loopTransformableArrays, pLoop, bodyEntryNode, bodyExitNode);
        TransformableLoop.Index index = pLoop.getIndex();
        EndpointPair indexUpdateEdgeEndpoints = pGraph.incidentNodes(index.getUpdateEdge());
        pGraph.removeEdge(index.getUpdateEdge());
        pGraph.addEdge(indexUpdateEdgeEndpoints, ArrayAbstraction.createBlankEdge(((CFANode)indexUpdateEdgeEndpoints.nodeU()).getFunction(), ""));
        return status;
    }

    private static ImmutableMap<CSimpleDeclaration, TransformableArray> createTransformableArrayMap(ImmutableSet<TransformableArray> pTransformableArrays) {
        ImmutableMap.Builder builder = ImmutableMap.builderWithExpectedSize((int)pTransformableArrays.size());
        for (TransformableArray transformableArray : pTransformableArrays) {
            builder.put((Object)transformableArray.getArrayDeclaration(), (Object)transformableArray);
        }
        return builder.buildOrThrow();
    }

    private static ImmutableSet<CFAEdge> createInnerLoopEdgeSet(ImmutableSet<TransformableLoop> pTransformableLoops) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (TransformableLoop transformableLoop : pTransformableLoops) {
            builder.addAll(transformableLoop.getInnerLoopEdges());
        }
        return builder.build();
    }

    private static Optional<TransformableArray> getTransformableArray(ArrayAccess pArrayAccess, ImmutableMap<CSimpleDeclaration, TransformableArray> pTransformableArrayMap) {
        CExpression arrayExpression = pArrayAccess.getArrayExpression();
        if (arrayExpression instanceof CIdExpression) {
            CSimpleDeclaration declaration = ((CIdExpression)arrayExpression).getDeclaration();
            TransformableArray transformableArray = (TransformableArray)pTransformableArrayMap.get((Object)declaration);
            return Optional.ofNullable(transformableArray);
        }
        throw new AssertionError((Object)("Unknown array expression: " + arrayExpression));
    }

    private static ImmutableSet<TransformableLoop> findRelevantTransformableLoops(CFA pCfa, LogManager pLogger) {
        ImmutableMap<CSimpleDeclaration, TransformableArray> transformableArrayMap = ArrayAbstraction.createTransformableArrayMap(TransformableArray.findTransformableArrays(pCfa));
        return (ImmutableSet)TransformableLoop.findTransformableLoops(pCfa, pLogger).stream().filter(loop -> !ArrayAbstraction.getLoopTransformableArrays(loop, transformableArrayMap).isEmpty()).collect(ImmutableSet.toImmutableSet());
    }

    private static ImmutableSet<TransformableArray> findRelevantTransformableArrays(CFA pCfa, ImmutableSet<TransformableLoop> pTransformableLoops) {
        ImmutableSet<TransformableArray> transformableArrays = TransformableArray.findTransformableArrays(pCfa);
        ImmutableMap<CSimpleDeclaration, TransformableArray> transformableArrayMap = ArrayAbstraction.createTransformableArrayMap(transformableArrays);
        ImmutableSet.Builder relevantTransformableArraysBuilder = ImmutableSet.builder();
        for (CFAEdge edge : ArrayAbstraction.createInnerLoopEdgeSet(pTransformableLoops)) {
            for (ArrayAccess arrayAccess : ArrayAccess.findArrayAccesses(edge)) {
                Optional<TransformableArray> optTransformableArray = ArrayAbstraction.getTransformableArray(arrayAccess, transformableArrayMap);
                if (!optTransformableArray.isPresent()) continue;
                relevantTransformableArraysBuilder.add((Object)optTransformableArray.orElseThrow());
            }
        }
        return relevantTransformableArraysBuilder.build();
    }

    private static ArrayAbstractionResult.Status transformEdge(CfaMutableNetwork pGraph, ImmutableMap<CSimpleDeclaration, TransformableArray> pTransformableArrayMap, CFA pCfa, LogManager pLogger, CFAEdge pEdge, Optional<TransformableLoop> pLoop, Optional<ImmutableMap<TransformableArray, CExpression>> pPreciseArraySubscriptExpressions) {
        ImmutableSet<ArrayAccess> arrayAccesses = ArrayAccess.findArrayAccesses(pEdge);
        assert (arrayAccesses.size() <= 1);
        Optional optArrayAccess = arrayAccesses.stream().findFirst();
        if (optArrayAccess.isPresent()) {
            ArrayAccess arrayAccess = (ArrayAccess)optArrayAccess.orElseThrow();
            Optional<TransformableArray> optTransformableArray = ArrayAbstraction.getTransformableArray(arrayAccess, pTransformableArrayMap);
            if (optTransformableArray.isEmpty()) {
                return pLoop.isEmpty() ? ArrayAbstractionResult.Status.PRECISE : ArrayAbstractionResult.Status.UNCHANGED;
            }
            TransformableArray transformableArray = optTransformableArray.orElseThrow();
            CExpression subscriptExpression = arrayAccess.getSubscriptExpression();
            if (pPreciseArraySubscriptExpressions.isPresent() && pLoop.isPresent()) {
                CExpression preciseSubscriptExpression = (CExpression)pPreciseArraySubscriptExpressions.orElseThrow().get((Object)transformableArray);
                TransformableLoop loop = pLoop.orElseThrow();
                CFAEdge updateIndexEdge = loop.getIndex().getUpdateEdge();
                CFAEdge postDominatedEdge = pEdge;
                if (pEdge instanceof CFunctionCallEdge) {
                    postDominatedEdge = ((CFunctionCallEdge)pEdge).getSummaryEdge();
                }
                if (subscriptExpression.equals(preciseSubscriptExpression) && loop.getPostDominatedInnerLoopEdges(updateIndexEdge).contains((Object)postDominatedEdge)) {
                    return ArrayAbstractionResult.Status.PRECISE;
                }
            }
            String functionName = pEdge.getSuccessor().getFunctionName();
            MachineModel machineModel = pCfa.getMachineModel();
            Optional<BigInteger> optSubscriptValue = SpecialOperation.eval(subscriptExpression, functionName, machineModel, pLogger, new ValueAnalysisState(machineModel));
            if (arrayAccess.isRead()) {
                if (optSubscriptValue.isPresent()) {
                    return ArrayAbstractionResult.Status.UNCHANGED;
                }
                return ArrayAbstractionResult.Status.UNCHANGED;
            }
            assert (arrayAccess.isWrite());
            EndpointPair edgeEndpoints = pGraph.incidentNodes(pEdge);
            if (optSubscriptValue.isPresent()) {
                CIdExpression indexIdExpression = new CIdExpression(subscriptExpression.getFileLocation(), transformableArray.getIndexDeclaration());
                CBinaryExpression accessCondition = new CBinaryExpression(subscriptExpression.getFileLocation(), subscriptExpression.getExpressionType(), subscriptExpression.getExpressionType(), subscriptExpression, indexIdExpression, CBinaryExpression.BinaryOperator.EQUALS);
                AFunctionDeclaration function = ((CFANode)edgeEndpoints.nodeU()).getFunction();
                CFANode newPredecessor = new CFANode(function);
                pGraph.insertPredecessor(newPredecessor, (CFANode)edgeEndpoints.nodeU(), ArrayAbstraction.createAssumeEdge(function, accessCondition, true));
                pGraph.addEdge(newPredecessor, (CFANode)edgeEndpoints.nodeV(), ArrayAbstraction.createAssumeEdge(function, accessCondition, false));
                return ArrayAbstractionResult.Status.PRECISE;
            }
            pGraph.removeEdge(pEdge);
            pGraph.addEdge(edgeEndpoints, ArrayAbstraction.createBlankEdge(((CFANode)edgeEndpoints.nodeU()).getFunction(), "removed: " + pEdge.getRawStatement()));
            return ArrayAbstractionResult.Status.IMPRECISE;
        }
        return ArrayAbstractionResult.Status.PRECISE;
    }

    private static CFA createSimplifiedCfa(Configuration pConfiguration, LogManager pLogger, CFA pCfa) {
        CFA fstCfa = CfaSimplifications.simplifyArrayAccesses(pConfiguration, pLogger, pCfa, new VariableGenerator("__array_access_variable_"));
        CFA sndCfa = CfaSimplifications.simplifyIncDecLoopEdges(pConfiguration, pLogger, fstCfa);
        return sndCfa;
    }

    private static void transformArrayDeclarations(CfaMutableNetwork pGraph, ImmutableSet<TransformableArray> pTransformableArrays) {
        for (TransformableArray transformableArray : pTransformableArrays) {
            CDeclarationEdge arrayDeclarationEdge = transformableArray.getArrayDeclarationEdge();
            EndpointPair arrayDeclarationEdgeEndpoints = pGraph.incidentNodes(arrayDeclarationEdge);
            CFANode arrayDeclarationEdgeNodeV = (CFANode)arrayDeclarationEdgeEndpoints.nodeV();
            pGraph.removeEdge(arrayDeclarationEdge);
            pGraph.addEdge(arrayDeclarationEdgeEndpoints, ArrayAbstraction.createBlankEdge(arrayDeclarationEdgeNodeV.getFunction(), ""));
            AFunctionDeclaration function = arrayDeclarationEdgeNodeV.getFunction();
            pGraph.insertPredecessor(new CFANode(function), arrayDeclarationEdgeNodeV, transformableArray.getValueDeclarationEdge());
            pGraph.insertPredecessor(new CFANode(function), arrayDeclarationEdgeNodeV, transformableArray.getIndexDeclarationEdge());
            CType arrayIndexType = transformableArray.getIndexDeclaration().getType();
            CIdExpression arrayIndexExpression = new CIdExpression(arrayDeclarationEdge.getFileLocation(), transformableArray.getIndexDeclaration());
            CBinaryExpression minIndexCondition = new CBinaryExpression(arrayDeclarationEdge.getFileLocation(), CNumericTypes.INT, arrayIndexType, arrayIndexExpression, CIntegerLiteralExpression.ZERO, CBinaryExpression.BinaryOperator.GREATER_EQUAL);
            pGraph.insertSuccessor(arrayDeclarationEdgeNodeV, new CFANode(function), ArrayAbstraction.createAssumeEdge(function, minIndexCondition, true));
            pGraph.addEdge(arrayDeclarationEdgeNodeV, new CFATerminationNode(function), ArrayAbstraction.createAssumeEdge(function, minIndexCondition, false));
            CBinaryExpression maxIndexCondition = new CBinaryExpression(arrayDeclarationEdge.getFileLocation(), CNumericTypes.INT, arrayIndexType, arrayIndexExpression, transformableArray.getLengthExpression(), CBinaryExpression.BinaryOperator.LESS_THAN);
            pGraph.insertSuccessor(arrayDeclarationEdgeNodeV, new CFANode(function), ArrayAbstraction.createAssumeEdge(function, maxIndexCondition, true));
            pGraph.addEdge(arrayDeclarationEdgeNodeV, new CFATerminationNode(function), ArrayAbstraction.createAssumeEdge(function, maxIndexCondition, false));
        }
    }

    public static ArrayAbstractionResult transformCfa(Configuration pConfiguration, LogManager pLogger, CFA pCfa) {
        Preconditions.checkNotNull((Object)pConfiguration);
        Preconditions.checkNotNull((Object)pLogger);
        Preconditions.checkNotNull((Object)pCfa);
        CFA simplifiedCfa = ArrayAbstraction.createSimplifiedCfa(pConfiguration, pLogger, pCfa);
        ImmutableSet<TransformableLoop> transformableLoops = ArrayAbstraction.findRelevantTransformableLoops(simplifiedCfa, pLogger);
        ImmutableSet<TransformableArray> transformableArrays = ArrayAbstraction.findRelevantTransformableArrays(simplifiedCfa, transformableLoops);
        ImmutableMap<CSimpleDeclaration, TransformableArray> transformableArrayMap = ArrayAbstraction.createTransformableArrayMap(transformableArrays);
        if (transformableLoops.isEmpty() || transformableArrays.isEmpty()) {
            return ArrayAbstractionResult.createUnchanged(pCfa);
        }
        CfaMutableNetwork graph = CfaMutableNetwork.of(simplifiedCfa);
        ArrayAbstractionResult.Status status = ArrayAbstractionResult.Status.PRECISE;
        for (TransformableLoop transformableLoop : transformableLoops) {
            ArrayAbstractionResult.Status loopTransformationStatus = ArrayAbstraction.transformLoop(graph, transformableArrayMap, simplifiedCfa, pLogger, transformableLoop);
            if (loopTransformationStatus == ArrayAbstractionResult.Status.UNCHANGED) {
                return ArrayAbstractionResult.createUnchanged(pCfa);
            }
            if (loopTransformationStatus != ArrayAbstractionResult.Status.IMPRECISE) continue;
            status = ArrayAbstractionResult.Status.IMPRECISE;
        }
        ImmutableSet transformedEdges = (ImmutableSet)transformableLoops.stream().flatMap(loop -> ArrayAbstraction.getTransformableEdges(graph, loop).stream()).collect(ImmutableSet.toImmutableSet());
        for (Object edge2 : ImmutableSet.copyOf(graph.edges())) {
            if (transformedEdges.contains(edge2)) continue;
            ArrayAbstractionResult.Status edgeTransformationStatus = ArrayAbstraction.transformEdge(graph, transformableArrayMap, simplifiedCfa, pLogger, (CFAEdge)edge2, Optional.empty(), Optional.empty());
            if (edgeTransformationStatus == ArrayAbstractionResult.Status.UNCHANGED) {
                return ArrayAbstractionResult.createUnchanged(pCfa);
            }
            if (edgeTransformationStatus != ArrayAbstractionResult.Status.IMPRECISE) continue;
            status = ArrayAbstractionResult.Status.IMPRECISE;
        }
        ArrayAbstraction.transformArrayDeclarations(graph, transformableArrays);
        CAstNodeSubstitution substitution = new CAstNodeSubstitution();
        for (CFAEdge edge3 : graph.edges()) {
            for (ArrayAccess arrayAccess : ArrayAccess.findArrayAccesses(edge3)) {
                Optional<TransformableArray> optTransformableArray = ArrayAbstraction.getTransformableArray(arrayAccess, transformableArrayMap);
                if (!optTransformableArray.isPresent()) continue;
                TransformableArray transformableArray = optTransformableArray.orElseThrow();
                CExpression arrayAccessExpression = arrayAccess.getExpression();
                CSimpleDeclaration valueDeclaration = transformableArray.getValueDeclaration();
                CIdExpression valueIdExpression = new CIdExpression(arrayAccessExpression.getFileLocation(), valueDeclaration);
                substitution.insertSubstitute(edge3, arrayAccessExpression, valueIdExpression);
            }
        }
        CFA transformedCfa = CCfaTransformer.createCfa(pConfiguration, pLogger, simplifiedCfa, graph, (edge, originalAstNode) -> originalAstNode.accept(new SubstitutingCAstNodeVisitor(node -> substitution.getSubstitute((CFAEdge)edge, (CAstNode)node))));
        return new ArrayAbstractionResult(status, transformedCfa, transformableArrays, transformableLoops);
    }
}

