/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.arrayabstraction;

import com.google.common.collect.ImmutableSet;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.util.arrayabstraction.TransformableArray;
import org.sosy_lab.cpachecker.util.arrayabstraction.TransformableLoop;

public final class ArrayAbstractionResult {
    private final Status status;
    private final CFA transformedCfa;
    private final ImmutableSet<TransformableArray> transformedArrays;
    private final ImmutableSet<TransformableLoop> transformedLoops;

    ArrayAbstractionResult(Status pStatus, CFA pTransformedCfa, ImmutableSet<TransformableArray> pTransformedArrays, ImmutableSet<TransformableLoop> pTransformedLoops) {
        this.status = pStatus;
        this.transformedCfa = pTransformedCfa;
        this.transformedArrays = pTransformedArrays;
        this.transformedLoops = pTransformedLoops;
    }

    static ArrayAbstractionResult createUnchanged(CFA pCfa) {
        return new ArrayAbstractionResult(Status.UNCHANGED, pCfa, (ImmutableSet<TransformableArray>)ImmutableSet.of(), (ImmutableSet<TransformableLoop>)ImmutableSet.of());
    }

    public Status getStatus() {
        return this.status;
    }

    public CFA getTransformedCfa() {
        return this.transformedCfa;
    }

    public ImmutableSet<TransformableArray> getTransformedArrays() {
        return this.transformedArrays;
    }

    public ImmutableSet<TransformableLoop> getTransformedLoops() {
        return this.transformedLoops;
    }

    public static enum Status {
        PRECISE,
        IMPRECISE,
        UNCHANGED;

    }
}

