/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.arrayabstraction;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import org.sosy_lab.cpachecker.cfa.ast.AAstNode;
import org.sosy_lab.cpachecker.cfa.ast.c.CAddressOfLabelExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CArrayDesignator;
import org.sosy_lab.cpachecker.cfa.ast.c.CArrayRangeDesignator;
import org.sosy_lab.cpachecker.cfa.ast.c.CArraySubscriptExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CAstNode;
import org.sosy_lab.cpachecker.cfa.ast.c.CAstNodeVisitor;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CCastExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CCharLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CComplexCastExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CComplexTypeDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CDesignatedInitializer;
import org.sosy_lab.cpachecker.cfa.ast.c.CDesignator;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpressionAssignmentStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpressionStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CFieldDesignator;
import org.sosy_lab.cpachecker.cfa.ast.c.CFieldReference;
import org.sosy_lab.cpachecker.cfa.ast.c.CFloatLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallAssignmentStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CImaginaryLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializer;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializerExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializerList;
import org.sosy_lab.cpachecker.cfa.ast.c.CIntegerLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CParameterDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CPointerExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CReturnStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CSimpleDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CStringLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CTypeDefDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CTypeIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CUnaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionSummaryEdge;
import org.sosy_lab.cpachecker.cfa.types.c.CArrayType;
import org.sosy_lab.cpachecker.cfa.types.c.CEnumType;
import org.sosy_lab.cpachecker.cfa.types.c.CPointerType;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.exceptions.NoException;

final class ArrayAccess {
    private final Type type;
    private final CExpression expression;

    private ArrayAccess(Type pType, CExpression pExpression) {
        this.type = pType;
        this.expression = pExpression;
    }

    private static Optional<CArraySubscriptExpression> toArraySubscriptExpression(CExpression pExpression) {
        if (pExpression instanceof CArraySubscriptExpression) {
            return Optional.of((CArraySubscriptExpression)pExpression);
        }
        if (pExpression instanceof CPointerExpression) {
            CPointerExpression pointerExpression = (CPointerExpression)pExpression;
            CExpression operand = pointerExpression.getOperand();
            if (operand instanceof CIdExpression) {
                CArraySubscriptExpression arraySubscriptExpression = new CArraySubscriptExpression(pExpression.getFileLocation(), pExpression.getExpressionType(), operand, CIntegerLiteralExpression.ZERO);
                return Optional.of(arraySubscriptExpression);
            }
            if (operand instanceof CBinaryExpression) {
                CBinaryExpression binaryExpression = (CBinaryExpression)operand;
                CBinaryExpression.BinaryOperator operator = binaryExpression.getOperator();
                CExpression operand1 = binaryExpression.getOperand1();
                CExpression operand2 = binaryExpression.getOperand2();
                if (operator == CBinaryExpression.BinaryOperator.PLUS) {
                    CArraySubscriptExpression arraySubscriptExpression = new CArraySubscriptExpression(pExpression.getFileLocation(), pExpression.getExpressionType(), operand1, operand2);
                    return Optional.of(arraySubscriptExpression);
                }
            }
        }
        return Optional.empty();
    }

    private static void analyseAstNode(CAstNode pCAstNode, Consumer<CExpression> pReadingArrayAccessConsumer, Consumer<CExpression> pWritingArrayAccessConsumer, Consumer<CSimpleDeclaration> pArrayDeclarationConsumer) {
        ArrayUsageAnalyser arrayUsageAnalyser = new ArrayUsageAnalyser(pReadingArrayAccessConsumer, pWritingArrayAccessConsumer, pArrayDeclarationConsumer);
        pCAstNode.accept(arrayUsageAnalyser);
    }

    private static void analyseCfaEdge(CFAEdge pEdge, Consumer<CExpression> pReadingArrayAccessConsumer, Consumer<CExpression> pWritingArrayAccessConsumer, Consumer<CSimpleDeclaration> pArrayDeclarationConsumer) {
        AAstNode astNode;
        Optional<AAstNode> optAstNode;
        if (pEdge instanceof CFunctionSummaryEdge) {
            ArrayAccess.analyseAstNode(((CFunctionSummaryEdge)pEdge).getExpression(), pReadingArrayAccessConsumer, pWritingArrayAccessConsumer, pArrayDeclarationConsumer);
        }
        if ((optAstNode = pEdge.getRawAST()).isPresent() && (astNode = optAstNode.get()) instanceof CAstNode) {
            ArrayAccess.analyseAstNode((CAstNode)astNode, pReadingArrayAccessConsumer, pWritingArrayAccessConsumer, pArrayDeclarationConsumer);
        }
    }

    public static ImmutableSet<ArrayAccess> findArrayAccesses(CAstNode pCAstNode) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        Consumer<CExpression> readingArrayAccessConsumer = arrayAccessExpression -> builder.add((Object)new ArrayAccess(Type.READ, (CExpression)arrayAccessExpression));
        Consumer<CExpression> writingArrayAccessConsumer = arrayAccessExpression -> builder.add((Object)new ArrayAccess(Type.WRITE, (CExpression)arrayAccessExpression));
        ArrayAccess.analyseAstNode(pCAstNode, readingArrayAccessConsumer, writingArrayAccessConsumer, arrayDeclaration -> {});
        return builder.build();
    }

    public static ImmutableSet<ArrayAccess> findArrayAccesses(CFAEdge pEdge) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        Consumer<CExpression> readingArrayAccessConsumer = arrayAccessExpression -> builder.add((Object)new ArrayAccess(Type.READ, (CExpression)arrayAccessExpression));
        Consumer<CExpression> writingArrayAccessConsumer = arrayAccessExpression -> builder.add((Object)new ArrayAccess(Type.WRITE, (CExpression)arrayAccessExpression));
        ArrayAccess.analyseCfaEdge(pEdge, readingArrayAccessConsumer, writingArrayAccessConsumer, arrayDeclaration -> {});
        return builder.build();
    }

    public static ImmutableSet<CSimpleDeclaration> findArrayOccurences(CFAEdge pEdge) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        Consumer<CSimpleDeclaration> arrayDeclarationConsumer = arrayDeclaration -> builder.add(arrayDeclaration);
        ArrayAccess.analyseCfaEdge(pEdge, arrayAccess -> {}, arrayAccess -> {}, arrayDeclarationConsumer);
        return builder.build();
    }

    public Type getType() {
        return this.type;
    }

    public boolean isRead() {
        return this.type == Type.READ;
    }

    public boolean isWrite() {
        return this.type == Type.WRITE;
    }

    public CExpression getExpression() {
        return this.expression;
    }

    public CExpression getArrayExpression() {
        return ArrayAccess.toArraySubscriptExpression(this.expression).orElseThrow().getArrayExpression();
    }

    public CExpression getSubscriptExpression() {
        return ArrayAccess.toArraySubscriptExpression(this.expression).orElseThrow().getSubscriptExpression();
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.expression});
    }

    public boolean equals(Object pObject) {
        if (this == pObject) {
            return true;
        }
        if (!(pObject instanceof ArrayAccess)) {
            return false;
        }
        ArrayAccess other = (ArrayAccess)pObject;
        return this.type == other.type && Objects.equals(this.expression, other.expression);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("type", (Object)this.type).add("expression", (Object)this.expression).toString();
    }

    private static final class ArrayUsageAnalyser
    implements CAstNodeVisitor<Void, NoException> {
        private final Consumer<CExpression> readingArrayAccessConsumer;
        private final Consumer<CExpression> writingArrayAccessConsumer;
        private final Consumer<CSimpleDeclaration> arrayDeclarationConsumer;
        private Mode mode;

        private ArrayUsageAnalyser(Consumer<CExpression> pReadingArrayAccessConsumer, Consumer<CExpression> pWritingArrayAccessConsumer, Consumer<CSimpleDeclaration> pArrayDeclarationConsumer) {
            this.readingArrayAccessConsumer = pReadingArrayAccessConsumer;
            this.writingArrayAccessConsumer = pWritingArrayAccessConsumer;
            this.arrayDeclarationConsumer = pArrayDeclarationConsumer;
            this.mode = Mode.USE;
        }

        @Override
        public Void visit(CArraySubscriptExpression pIastArraySubscriptExpression) {
            if (this.mode == Mode.DEF) {
                this.writingArrayAccessConsumer.accept(pIastArraySubscriptExpression);
            } else {
                assert (this.mode == Mode.USE);
                this.readingArrayAccessConsumer.accept(pIastArraySubscriptExpression);
            }
            Mode prevMode = this.mode;
            this.mode = Mode.USE;
            pIastArraySubscriptExpression.getArrayExpression().accept(this);
            pIastArraySubscriptExpression.getSubscriptExpression().accept(this);
            this.mode = prevMode;
            return null;
        }

        @Override
        public Void visit(CArrayDesignator pArrayDesignator) {
            pArrayDesignator.getSubscriptExpression().accept(this);
            return null;
        }

        @Override
        public Void visit(CArrayRangeDesignator pArrayRangeDesignator) {
            pArrayRangeDesignator.getFloorExpression().accept(this);
            pArrayRangeDesignator.getCeilExpression().accept(this);
            return null;
        }

        @Override
        public Void visit(CFieldDesignator pFieldDesignator) {
            return null;
        }

        @Override
        public Void visit(CInitializerExpression pInitializerExpression) {
            pInitializerExpression.getExpression().accept(this);
            return null;
        }

        @Override
        public Void visit(CInitializerList pInitializerList) {
            for (CInitializer initializer : pInitializerList.getInitializers()) {
                initializer.accept(this);
            }
            return null;
        }

        @Override
        public Void visit(CDesignatedInitializer pCStructInitializerPart) {
            pCStructInitializerPart.getRightHandSide().accept(this);
            for (CDesignator designator : pCStructInitializerPart.getDesignators()) {
                designator.accept(this);
            }
            return null;
        }

        @Override
        public Void visit(CFunctionCallExpression pIastFunctionCallExpression) {
            pIastFunctionCallExpression.getFunctionNameExpression().accept(this);
            for (CExpression expression : pIastFunctionCallExpression.getParameterExpressions()) {
                expression.accept(this);
            }
            return null;
        }

        @Override
        public Void visit(CBinaryExpression pIastBinaryExpression) {
            pIastBinaryExpression.getOperand1().accept(this);
            pIastBinaryExpression.getOperand2().accept(this);
            return null;
        }

        @Override
        public Void visit(CCastExpression pIastCastExpression) {
            pIastCastExpression.getOperand().accept(this);
            return null;
        }

        @Override
        public Void visit(CCharLiteralExpression pIastCharLiteralExpression) {
            return null;
        }

        @Override
        public Void visit(CFloatLiteralExpression pIastFloatLiteralExpression) {
            return null;
        }

        @Override
        public Void visit(CIntegerLiteralExpression pIastIntegerLiteralExpression) {
            return null;
        }

        @Override
        public Void visit(CStringLiteralExpression pIastStringLiteralExpression) {
            return null;
        }

        @Override
        public Void visit(CTypeIdExpression pIastTypeIdExpression) {
            return null;
        }

        @Override
        public Void visit(CUnaryExpression pIastUnaryExpression) {
            pIastUnaryExpression.getOperand().accept(this);
            return null;
        }

        @Override
        public Void visit(CImaginaryLiteralExpression PIastLiteralExpression) {
            return null;
        }

        @Override
        public Void visit(CAddressOfLabelExpression pAddressOfLabelExpression) {
            return null;
        }

        @Override
        public Void visit(CFieldReference pIastFieldReference) {
            if (pIastFieldReference.isPointerDereference()) {
                Mode prevMode = this.mode;
                this.mode = Mode.USE;
                pIastFieldReference.getFieldOwner().accept(this);
                this.mode = prevMode;
            } else {
                pIastFieldReference.getFieldOwner().accept(this);
            }
            return null;
        }

        @Override
        public Void visit(CIdExpression pIastIdExpression) {
            CSimpleDeclaration declaration = pIastIdExpression.getDeclaration();
            CType type = declaration.getType();
            if (type instanceof CArrayType || type instanceof CPointerType) {
                this.arrayDeclarationConsumer.accept(pIastIdExpression.getDeclaration());
            }
            return null;
        }

        @Override
        public Void visit(CPointerExpression pPointerExpression) {
            if (ArrayAccess.toArraySubscriptExpression(pPointerExpression).isPresent()) {
                if (this.mode == Mode.DEF) {
                    this.writingArrayAccessConsumer.accept(pPointerExpression);
                } else {
                    assert (this.mode == Mode.USE);
                    this.readingArrayAccessConsumer.accept(pPointerExpression);
                }
            }
            Mode prevMode = this.mode;
            this.mode = Mode.USE;
            pPointerExpression.getOperand().accept(this);
            this.mode = prevMode;
            return null;
        }

        @Override
        public Void visit(CComplexCastExpression pComplexCastExpression) {
            pComplexCastExpression.getOperand().accept(this);
            return null;
        }

        @Override
        public Void visit(CFunctionDeclaration pDecl) {
            for (CParameterDeclaration declaration : pDecl.getParameters()) {
                declaration.accept(this);
            }
            return null;
        }

        @Override
        public Void visit(CComplexTypeDeclaration pDecl) {
            return null;
        }

        @Override
        public Void visit(CTypeDefDeclaration pDecl) {
            return null;
        }

        @Override
        public Void visit(CVariableDeclaration pDecl) {
            CInitializer initializer = pDecl.getInitializer();
            if (initializer != null) {
                this.mode = Mode.USE;
                initializer.accept(this);
            }
            return null;
        }

        @Override
        public Void visit(CParameterDeclaration pDecl) {
            pDecl.asVariableDeclaration().accept(this);
            return null;
        }

        @Override
        public Void visit(CEnumType.CEnumerator pDecl) {
            return null;
        }

        @Override
        public Void visit(CExpressionStatement pIastExpressionStatement) {
            pIastExpressionStatement.getExpression().accept(this);
            return null;
        }

        @Override
        public Void visit(CExpressionAssignmentStatement pIastExpressionAssignmentStatement) {
            this.mode = Mode.DEF;
            pIastExpressionAssignmentStatement.getLeftHandSide().accept(this);
            this.mode = Mode.USE;
            pIastExpressionAssignmentStatement.getRightHandSide().accept(this);
            return null;
        }

        @Override
        public Void visit(CFunctionCallAssignmentStatement pIastFunctionCallAssignmentStatement) {
            this.mode = Mode.DEF;
            pIastFunctionCallAssignmentStatement.getLeftHandSide().accept(this);
            this.mode = Mode.USE;
            pIastFunctionCallAssignmentStatement.getRightHandSide().accept(this);
            return null;
        }

        @Override
        public Void visit(CFunctionCallStatement pIastFunctionCallStatement) {
            List<CExpression> paramExpressions = pIastFunctionCallStatement.getFunctionCallExpression().getParameterExpressions();
            for (CExpression expression : paramExpressions) {
                expression.accept(this);
            }
            CFunctionDeclaration declaration = pIastFunctionCallStatement.getFunctionCallExpression().getDeclaration();
            if (declaration != null) {
                declaration.accept(this);
            }
            return null;
        }

        @Override
        public Void visit(CReturnStatement pNode) {
            Optional<CExpression> optExpression = pNode.getReturnValue();
            if (optExpression.isPresent()) {
                return optExpression.orElseThrow().accept(this);
            }
            return null;
        }

        private static enum Mode {
            USE,
            DEF;

        }
    }

    public static enum Type {
        WRITE,
        READ;

    }
}

