/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.arrayabstraction;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.common.graph.EndpointPair;
import java.math.BigInteger;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CCfaTransformer;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.CfaMutableNetwork;
import org.sosy_lab.cpachecker.cfa.ast.AbstractExpression;
import org.sosy_lab.cpachecker.cfa.ast.FileLocation;
import org.sosy_lab.cpachecker.cfa.ast.c.AbstractTransformingCAstNodeVisitor;
import org.sosy_lab.cpachecker.cfa.ast.c.CAstNode;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpressionAssignmentStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializerExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CIntegerLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CSimpleDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.SubstitutingCAstNodeVisitor;
import org.sosy_lab.cpachecker.cfa.model.BlankEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.FunctionCallEdge;
import org.sosy_lab.cpachecker.cfa.model.FunctionSummaryEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CDeclarationEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CStatementEdge;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.cfa.types.c.CStorageClass;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.cpa.value.ValueAnalysisState;
import org.sosy_lab.cpachecker.exceptions.NoException;
import org.sosy_lab.cpachecker.util.arrayabstraction.ArrayAccess;
import org.sosy_lab.cpachecker.util.arrayabstraction.SpecialOperation;
import org.sosy_lab.cpachecker.util.arrayabstraction.TransformableLoop;
import org.sosy_lab.cpachecker.util.arrayabstraction.VariableGenerator;
import org.sosy_lab.cpachecker.util.states.MemoryLocation;
import org.sosy_lab.cpachecker.util.variableclassification.VariableClassification;

final class CfaSimplifications {
    private CfaSimplifications() {
    }

    static CFA simplifyArrayAccesses(Configuration pConfiguration, LogManager pLogger, CFA pCfa, VariableGenerator pVariableGenerator) {
        CfaMutableNetwork graph = CfaMutableNetwork.of(pCfa);
        HashMap<CFAEdge, Map> substitution = new HashMap<CFAEdge, Map>();
        for (CFAEdge edge2 : ImmutableSet.copyOf(graph.edges())) {
            if (edge2 instanceof FunctionSummaryEdge) continue;
            LinkedHashSet<ArrayAccess> remainingArrayAccesses = new LinkedHashSet<ArrayAccess>((Collection<ArrayAccess>)ArrayAccess.findArrayAccesses(edge2));
            HashMap<ArrayAccess, CIdExpression> finished = new HashMap<ArrayAccess, CIdExpression>();
            assert (remainingArrayAccesses.stream().filter(ArrayAccess::isWrite).count() <= 1L);
            while (remainingArrayAccesses.size() > 1) {
                Iterator remainingArrayAccessesIterator = remainingArrayAccesses.iterator();
                while (remainingArrayAccessesIterator.hasNext()) {
                    ArrayAccess current = (ArrayAccess)remainingArrayAccessesIterator.next();
                    ImmutableSet<ArrayAccess> currentArrayAccesses = ArrayAccess.findArrayAccesses(current.getExpression());
                    if (Sets.difference(currentArrayAccesses, finished.keySet()).size() != 1) continue;
                    remainingArrayAccessesIterator.remove();
                    if (!current.isRead()) continue;
                    FileLocation fileLocation = edge2.getFileLocation();
                    CFANode predecessor = (CFANode)graph.incidentNodes(edge2).nodeU();
                    CInitializerExpression initializerExpression = new CInitializerExpression(fileLocation, current.getExpression());
                    String newVarName = pVariableGenerator.createNewVariableName();
                    String newVarQualifiedName = MemoryLocation.forLocalVariable(predecessor.getFunctionName(), newVarName).getExtendedQualifiedName();
                    CVariableDeclaration declaration = new CVariableDeclaration(fileLocation, false, CStorageClass.AUTO, current.getExpression().getExpressionType(), newVarName, newVarName, newVarQualifiedName, initializerExpression);
                    CDeclarationEdge newDeclarationEdge = new CDeclarationEdge("", fileLocation, CFANode.newDummyCFANode(), CFANode.newDummyCFANode(), declaration);
                    for (Map.Entry finishedEntry : finished.entrySet()) {
                        substitution.computeIfAbsent(newDeclarationEdge, key -> new HashMap()).put((ArrayAccess)finishedEntry.getKey(), (CAstNode)finishedEntry.getValue());
                    }
                    graph.insertPredecessor(new CFANode(predecessor.getFunction()), predecessor, newDeclarationEdge);
                    CIdExpression substituteExpression = new CIdExpression(fileLocation, declaration);
                    substitution.computeIfAbsent(edge2, key -> new HashMap()).put(current, substituteExpression);
                    if (edge2 instanceof FunctionCallEdge) {
                        FunctionSummaryEdge summaryEdge = edge2.getPredecessor().getLeavingSummaryEdge();
                        assert (summaryEdge != null) : "Missing summary edge for call edge";
                        substitution.computeIfAbsent(summaryEdge, key -> new HashMap()).put(current, substituteExpression);
                    }
                    finished.put(current, substituteExpression);
                }
            }
        }
        BiFunction<CFAEdge, CAstNode, CAstNode> substitutionFunction = (edge, originalAstNode) -> {
            CStatement statement;
            Map arrayAccessSubstitution = (Map)substitution.get(edge);
            if (arrayAccessSubstitution == null) {
                return originalAstNode;
            }
            assert (arrayAccessSubstitution.keySet().stream().filter(ArrayAccess::isWrite).findAny().isEmpty());
            Function<Map.Entry, CAstNode> extractExpression = entry -> ((ArrayAccess)entry.getKey()).getExpression();
            ImmutableMap astNodeSubstitution = (ImmutableMap)arrayAccessSubstitution.entrySet().stream().collect(ImmutableMap.toImmutableMap(extractExpression, Map.Entry::getValue));
            if (edge instanceof CStatementEdge && (statement = ((CStatementEdge)edge).getStatement()) instanceof CExpressionAssignmentStatement) {
                CExpressionAssignmentStatement assignStatement = (CExpressionAssignmentStatement)statement;
                CAstNode rhs = assignStatement.getRightHandSide().accept(new SubstitutingCAstNodeVisitor(arg_0 -> ((ImmutableMap)astNodeSubstitution).get(arg_0)));
                return new CExpressionAssignmentStatement(assignStatement.getFileLocation(), assignStatement.getLeftHandSide(), (CExpression)rhs);
            }
            return originalAstNode.accept(new SubstitutingCAstNodeVisitor(arg_0 -> ((ImmutableMap)astNodeSubstitution).get(arg_0)));
        };
        return CCfaTransformer.createCfa(pConfiguration, pLogger, pCfa, graph, substitutionFunction);
    }

    static CFA simplifyIncDecLoopEdges(Configuration pConfiguration, LogManager pLogger, CFA pCfa) {
        CfaMutableNetwork graph = CfaMutableNetwork.of(pCfa);
        HashMap<CFAEdge, Map> substitution = new HashMap<CFAEdge, Map>();
        VariableClassification variableClassification = pCfa.getVarClassification().orElseThrow();
        MachineModel machineModel = pCfa.getMachineModel();
        ValueAnalysisState emptyValueAnalysisState = new ValueAnalysisState(machineModel);
        for (TransformableLoop loop : TransformableLoop.findTransformableLoops(pCfa, pLogger)) {
            String functionName = loop.getLoopNode().getFunctionName();
            for (CFAEdge innerLoopEdge : loop.getInnerLoopEdges()) {
                SpecialOperation.UpdateAssign targetUpdateOperation;
                CSimpleDeclaration targetDeclaration;
                Optional<SpecialOperation.UpdateAssign> optTargetUpdateOperation = SpecialOperation.UpdateAssign.forEdge(innerLoopEdge, functionName, machineModel, pLogger, emptyValueAnalysisState);
                if (!optTargetUpdateOperation.isPresent() || (targetDeclaration = (targetUpdateOperation = optTargetUpdateOperation.orElseThrow()).getDeclaration()).equals(loop.getIndex().getVariableDeclaration()) || loop.hasOutgoingUses(targetDeclaration)) continue;
                String targetQualifiedName = targetDeclaration.getQualifiedName();
                if (variableClassification.getAddressedVariables().contains(targetQualifiedName) || loop.countInnerLoopDefs(targetDeclaration) > 1 || !loop.isExecutedEveryIteration(innerLoopEdge)) continue;
                CFAEdge updateIndexEdge = loop.getIndex().getUpdateEdge();
                CIdExpression indexIdExpression = new CIdExpression(innerLoopEdge.getFileLocation(), loop.getIndex().getVariableDeclaration());
                ImmutableSet<CFAEdge> indexDominated = loop.getDominatedInnerLoopEdges(updateIndexEdge);
                ImmutableSet<CFAEdge> indexPostDominated = loop.getPostDominatedInnerLoopEdges(updateIndexEdge);
                ImmutableSet<CFAEdge> targetDominated = loop.getDominatedInnerLoopEdges(innerLoopEdge);
                ImmutableSet<CFAEdge> targetPostDominated = loop.getPostDominatedInnerLoopEdges(innerLoopEdge);
                for (CFAEdge edge2 : Iterables.concat(targetDominated, targetPostDominated)) {
                    AbstractExpression substituteExpression;
                    int indexAdjustValue = indexDominated.contains((Object)edge2) && targetPostDominated.contains((Object)edge2) ? -1 : (indexPostDominated.contains((Object)edge2) && targetDominated.contains((Object)edge2) ? 1 : 0);
                    Optional<Object> targetInitialOperation = Optional.empty();
                    ImmutableSet<CFAEdge> targetIncomingDefEdges = loop.getIncomingDefs(targetDeclaration);
                    if (targetIncomingDefEdges.size() == 1) {
                        CFAEdge targetDefEdge = (CFAEdge)targetIncomingDefEdges.stream().findAny().orElseThrow();
                        targetInitialOperation = SpecialOperation.ConstantAssign.forEdge(targetDefEdge, functionName, machineModel, pLogger, emptyValueAnalysisState);
                    }
                    if (indexAdjustValue == 0 && targetUpdateOperation.getStepValue().equals(BigInteger.ONE) && targetInitialOperation.isPresent() && ((SpecialOperation.ConstantAssign)targetInitialOperation.orElseThrow()).getValue().equals(BigInteger.ZERO) && loop.getIndex().getUpdateOperation().getStepValue().equals(BigInteger.ONE) && loop.getIndex().getInitializeOperation().getValue().equals(BigInteger.ZERO)) {
                        substituteExpression = indexIdExpression;
                    } else {
                        FileLocation fileLocation = edge2.getFileLocation();
                        TransformableLoop.Index index = loop.getIndex();
                        CType indexType = index.getVariableDeclaration().getType();
                        CIdExpression indexExpression = indexIdExpression;
                        CIntegerLiteralExpression indexInitialExpression = new CIntegerLiteralExpression(fileLocation, indexType, index.getInitializeOperation().getValue());
                        CIntegerLiteralExpression indexStepExpression = new CIntegerLiteralExpression(fileLocation, indexType, index.getUpdateOperation().getStepValue());
                        CIntegerLiteralExpression indexAdjustExpression = new CIntegerLiteralExpression(fileLocation, indexType, BigInteger.valueOf(indexAdjustValue));
                        AbstractExpression targetInitialValue = targetInitialOperation.isPresent() ? new CIntegerLiteralExpression(fileLocation, indexType, ((SpecialOperation.ConstantAssign)targetInitialOperation.orElseThrow()).getValue()) : new CIdExpression(fileLocation, targetDeclaration);
                        CIntegerLiteralExpression targetStepValue = new CIntegerLiteralExpression(fileLocation, indexType, targetUpdateOperation.getStepValue());
                        CBinaryExpression subformula1 = new CBinaryExpression(fileLocation, indexType, indexType, indexExpression, indexInitialExpression, CBinaryExpression.BinaryOperator.MINUS);
                        CBinaryExpression subformula2 = new CBinaryExpression(fileLocation, indexType, indexType, subformula1, indexStepExpression, CBinaryExpression.BinaryOperator.DIVIDE);
                        CBinaryExpression subformula3 = new CBinaryExpression(fileLocation, indexType, indexType, subformula2, indexAdjustExpression, CBinaryExpression.BinaryOperator.PLUS);
                        CBinaryExpression subformula4 = new CBinaryExpression(fileLocation, indexType, indexType, subformula3, targetStepValue, CBinaryExpression.BinaryOperator.MULTIPLY);
                        substituteExpression = new CBinaryExpression(fileLocation, indexType, indexType, (CExpression)((Object)targetInitialValue), subformula4, CBinaryExpression.BinaryOperator.PLUS);
                    }
                    Map declarationSubstitution = substitution.computeIfAbsent(edge2, key -> new HashMap());
                    declarationSubstitution.put(targetDeclaration, substituteExpression);
                }
                EndpointPair endpoints = graph.incidentNodes(innerLoopEdge);
                graph.removeEdge(innerLoopEdge);
                graph.addEdge(endpoints, new BlankEdge("", innerLoopEdge.getFileLocation(), innerLoopEdge.getPredecessor(), innerLoopEdge.getSuccessor(), ""));
            }
        }
        return CCfaTransformer.createCfa(pConfiguration, pLogger, pCfa, graph, (edge, originalAstNode) -> IdExpressionSubstitutingCAstNodeVisitor.substitute(substitution, edge, originalAstNode));
    }

    private static final class IdExpressionSubstitutingCAstNodeVisitor
    extends AbstractTransformingCAstNodeVisitor<NoException> {
        private final Map<CSimpleDeclaration, CExpression> substitution;

        public IdExpressionSubstitutingCAstNodeVisitor(Map<CSimpleDeclaration, CExpression> pSubstitution) {
            this.substitution = pSubstitution;
        }

        private static CAstNode substitute(Map<CFAEdge, Map<CSimpleDeclaration, CExpression>> pSubstitution, CFAEdge pEdge, CAstNode pOriginalAstNode) {
            Map<CSimpleDeclaration, CExpression> declarationSubstitution = pSubstitution.get(pEdge);
            if (declarationSubstitution != null) {
                IdExpressionSubstitutingCAstNodeVisitor transformingVisitor = new IdExpressionSubstitutingCAstNodeVisitor(declarationSubstitution);
                return pOriginalAstNode.accept(transformingVisitor);
            }
            return pOriginalAstNode;
        }

        @Override
        public CAstNode visit(CIdExpression pCIdExpression) throws NoException {
            CSimpleDeclaration declaration = pCIdExpression.getDeclaration();
            CExpression substitute = this.substitution.get(declaration);
            if (substitute != null) {
                return substitute;
            }
            return super.visit(pCIdExpression);
        }
    }
}

