/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.arrayabstraction;

import com.google.common.base.MoreObjects;
import java.math.BigInteger;
import java.util.Objects;
import java.util.Optional;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.common.log.LogManagerWithoutDuplicates;
import org.sosy_lab.cpachecker.cfa.ast.FileLocation;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpressionAssignmentStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializer;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializerExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CIntegerLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CLeftHandSide;
import org.sosy_lab.cpachecker.cfa.ast.c.CSimpleDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CUnaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CAssumeEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CDeclarationEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CStatementEdge;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.cpa.value.ExpressionValueVisitor;
import org.sosy_lab.cpachecker.cpa.value.ValueAnalysisState;
import org.sosy_lab.cpachecker.cpa.value.type.Value;
import org.sosy_lab.cpachecker.exceptions.UnrecognizedCodeException;

abstract class SpecialOperation {
    private final CSimpleDeclaration declaration;

    private SpecialOperation(CSimpleDeclaration pDeclaration) {
        this.declaration = pDeclaration;
    }

    public static Optional<BigInteger> eval(CExpression pExpression, String pFunctionName, MachineModel pMachineModel, LogManager pLogger, ValueAnalysisState pValueAnalysisState) {
        Value value;
        LogManagerWithoutDuplicates logger = new LogManagerWithoutDuplicates(pLogger);
        ExpressionValueVisitor expressionEvalVisitor = new ExpressionValueVisitor(pValueAnalysisState, pFunctionName, pMachineModel, logger);
        try {
            value = pExpression.accept(expressionEvalVisitor);
        }
        catch (UnrecognizedCodeException ex) {
            return Optional.empty();
        }
        if (value.isExplicitlyKnown() && value.isNumericValue()) {
            Number number = value.asNumericValue().getNumber();
            if (number instanceof BigInteger) {
                return Optional.of((BigInteger)number);
            }
            if (number instanceof Byte || number instanceof Short || number instanceof Integer || number instanceof Long) {
                return Optional.of(BigInteger.valueOf(number.longValue()));
            }
        }
        return Optional.empty();
    }

    public CSimpleDeclaration getDeclaration() {
        return this.declaration;
    }

    public static final class ConstantComparison
    extends SpecialOperation {
        private final Operator operator;
        private final BigInteger value;

        private ConstantComparison(CSimpleDeclaration pDeclaration, Operator pOperator, BigInteger pValue) {
            super(pDeclaration);
            this.value = pValue;
            this.operator = pOperator;
        }

        public static Optional<ConstantComparison> forEdge(CFAEdge pEdge, String pFunctionName, MachineModel pMachineModel, LogManager pLogger, ValueAnalysisState pValueAnalysisState) {
            CAssumeEdge assumeEdge;
            CExpression expression;
            if (pEdge instanceof CAssumeEdge && (expression = (assumeEdge = (CAssumeEdge)pEdge).getExpression()) instanceof CBinaryExpression) {
                CBinaryExpression binaryExpression = (CBinaryExpression)expression;
                CExpression operand1 = binaryExpression.getOperand1();
                CBinaryExpression.BinaryOperator operator = binaryExpression.getOperator();
                if ((operator == CBinaryExpression.BinaryOperator.LESS_THAN || operator == CBinaryExpression.BinaryOperator.GREATER_THAN || operator == CBinaryExpression.BinaryOperator.LESS_EQUAL || operator == CBinaryExpression.BinaryOperator.GREATER_EQUAL) && operand1 instanceof CIdExpression) {
                    CExpression valueExpression = binaryExpression.getOperand2();
                    if (operator == CBinaryExpression.BinaryOperator.LESS_THAN) {
                        valueExpression = new CBinaryExpression(FileLocation.DUMMY, valueExpression.getExpressionType(), valueExpression.getExpressionType(), valueExpression, CIntegerLiteralExpression.ONE, CBinaryExpression.BinaryOperator.MINUS);
                    } else if (operator == CBinaryExpression.BinaryOperator.GREATER_THAN) {
                        valueExpression = new CBinaryExpression(FileLocation.DUMMY, valueExpression.getExpressionType(), valueExpression.getExpressionType(), valueExpression, CIntegerLiteralExpression.ONE, CBinaryExpression.BinaryOperator.PLUS);
                    }
                    Optional<BigInteger> optConstantValue = ConstantComparison.eval(valueExpression, pFunctionName, pMachineModel, pLogger, pValueAnalysisState);
                    if (optConstantValue.isPresent()) {
                        Operator operationOperator;
                        if (operator == CBinaryExpression.BinaryOperator.LESS_THAN) {
                            operationOperator = Operator.LESS_EQUAL;
                        } else if (operator == CBinaryExpression.BinaryOperator.GREATER_THAN) {
                            operationOperator = Operator.GREATER_EQUAL;
                        } else if (operator == CBinaryExpression.BinaryOperator.LESS_EQUAL) {
                            operationOperator = Operator.LESS_EQUAL;
                        } else if (operator == CBinaryExpression.BinaryOperator.GREATER_EQUAL) {
                            operationOperator = Operator.GREATER_EQUAL;
                        } else {
                            throw new AssertionError((Object)("Unknown operator: " + operator));
                        }
                        CSimpleDeclaration variableDeclaration = ((CIdExpression)operand1).getDeclaration();
                        BigInteger constantValue = optConstantValue.orElseThrow();
                        return Optional.of(new ConstantComparison(variableDeclaration, operationOperator, constantValue));
                    }
                }
            }
            return Optional.empty();
        }

        public Operator getOperator() {
            return this.operator;
        }

        public BigInteger getValue() {
            return this.value;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.getDeclaration(), this.operator, this.value});
        }

        public boolean equals(Object pObject) {
            if (this == pObject) {
                return true;
            }
            if (!(pObject instanceof ConstantComparison)) {
                return false;
            }
            ConstantComparison other = (ConstantComparison)pObject;
            return Objects.equals(this.getDeclaration(), other.getDeclaration()) && this.operator == other.operator && Objects.equals(this.value, other.value);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("declaration", (Object)this.getDeclaration()).add("operator", (Object)this.operator).add("value", (Object)this.value).toString();
        }

        public static enum Operator {
            LESS_EQUAL,
            GREATER_EQUAL;

        }
    }

    public static final class UpdateAssign
    extends SpecialOperation {
        private final BigInteger stepValue;

        private UpdateAssign(CSimpleDeclaration pDeclaration, BigInteger pStepValue) {
            super(pDeclaration);
            this.stepValue = pStepValue;
        }

        public static Optional<UpdateAssign> forEdge(CFAEdge pEdge, String pFunctionName, MachineModel pMachineModel, LogManager pLogger, ValueAnalysisState pValueAnalysisState) {
            ExpressionAssign expressionAssign;
            CExpression expression;
            Optional<ExpressionAssign> optExpressionAssign = ExpressionAssign.forEdge(pEdge);
            if (optExpressionAssign.isPresent() && (expression = (expressionAssign = optExpressionAssign.orElseThrow()).getExpression()) instanceof CBinaryExpression) {
                CBinaryExpression binaryExpression = (CBinaryExpression)expression;
                CExpression operand1 = binaryExpression.getOperand1();
                CBinaryExpression.BinaryOperator operator = binaryExpression.getOperator();
                if ((operator == CBinaryExpression.BinaryOperator.PLUS || operator == CBinaryExpression.BinaryOperator.MINUS) && operand1 instanceof CIdExpression) {
                    CSimpleDeclaration assignDeclaration = expressionAssign.getDeclaration();
                    CSimpleDeclaration operand1Declaration = ((CIdExpression)operand1).getDeclaration();
                    if (operand1Declaration.equals(assignDeclaration)) {
                        Optional<BigInteger> optStepValue;
                        CExpression stepExpression = binaryExpression.getOperand2();
                        if (operator == CBinaryExpression.BinaryOperator.MINUS) {
                            stepExpression = new CUnaryExpression(FileLocation.DUMMY, stepExpression.getExpressionType(), stepExpression, CUnaryExpression.UnaryOperator.MINUS);
                        }
                        if ((optStepValue = UpdateAssign.eval(stepExpression, pFunctionName, pMachineModel, pLogger, pValueAnalysisState)).isPresent()) {
                            BigInteger stepValue = optStepValue.orElseThrow();
                            return Optional.of(new UpdateAssign(assignDeclaration, stepValue));
                        }
                    }
                }
            }
            return Optional.empty();
        }

        public BigInteger getStepValue() {
            return this.stepValue;
        }

        public int hashCode() {
            return Objects.hash(this.getDeclaration(), this.stepValue);
        }

        public boolean equals(Object pObject) {
            if (this == pObject) {
                return true;
            }
            if (!(pObject instanceof UpdateAssign)) {
                return false;
            }
            UpdateAssign other = (UpdateAssign)pObject;
            return Objects.equals(this.getDeclaration(), other.getDeclaration()) && Objects.equals(this.stepValue, other.stepValue);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("declaration", (Object)this.getDeclaration()).add("stepValue", (Object)this.stepValue).toString();
        }
    }

    public static final class ConstantAssign
    extends SpecialOperation {
        private final BigInteger value;

        private ConstantAssign(CSimpleDeclaration pDeclaration, BigInteger pValue) {
            super(pDeclaration);
            this.value = pValue;
        }

        public static Optional<ConstantAssign> forEdge(CFAEdge pEdge, String pFunctionName, MachineModel pMachineModel, LogManager pLogger, ValueAnalysisState pValueAnalysisState) {
            ExpressionAssign expressionAssign;
            CExpression expression;
            Optional<BigInteger> optConstantValue;
            Optional<ExpressionAssign> optExpressionAssign = ExpressionAssign.forEdge(pEdge);
            if (optExpressionAssign.isPresent() && (optConstantValue = ConstantAssign.eval(expression = (expressionAssign = optExpressionAssign.orElseThrow()).getExpression(), pFunctionName, pMachineModel, pLogger, pValueAnalysisState)).isPresent()) {
                CSimpleDeclaration declaration = expressionAssign.getDeclaration();
                BigInteger constantValue = optConstantValue.orElseThrow();
                return Optional.of(new ConstantAssign(declaration, constantValue));
            }
            return Optional.empty();
        }

        public BigInteger getValue() {
            return this.value;
        }

        public int hashCode() {
            return Objects.hash(this.getDeclaration(), this.value);
        }

        public boolean equals(Object pObject) {
            if (this == pObject) {
                return true;
            }
            if (!(pObject instanceof ConstantAssign)) {
                return false;
            }
            ConstantAssign other = (ConstantAssign)pObject;
            return Objects.equals(this.getDeclaration(), other.getDeclaration()) && Objects.equals(this.value, other.value);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("declaration", (Object)this.getDeclaration()).add("value", (Object)this.value).toString();
        }
    }

    private static final class ExpressionAssign
    extends SpecialOperation {
        private final CExpression expression;

        private ExpressionAssign(CSimpleDeclaration pDeclaration, CExpression pExpression) {
            super(pDeclaration);
            this.expression = pExpression;
        }

        private static Optional<ExpressionAssign> forEdge(CFAEdge pEdge) {
            CExpressionAssignmentStatement assignmentStatement;
            CLeftHandSide lhs;
            CStatementEdge statementEdge;
            CStatement statement;
            CInitializer initializer;
            CDeclarationEdge declarationEdge;
            CDeclaration declaration;
            if (pEdge instanceof CDeclarationEdge && (declaration = (declarationEdge = (CDeclarationEdge)pEdge).getDeclaration()) instanceof CVariableDeclaration && (initializer = ((CVariableDeclaration)declaration).getInitializer()) instanceof CInitializerExpression) {
                CExpression expression = ((CInitializerExpression)initializer).getExpression();
                return Optional.of(new ExpressionAssign(declaration, expression));
            }
            if (pEdge instanceof CStatementEdge && (statement = (statementEdge = (CStatementEdge)pEdge).getStatement()) instanceof CExpressionAssignmentStatement && (lhs = (assignmentStatement = (CExpressionAssignmentStatement)statement).getLeftHandSide()) instanceof CIdExpression) {
                CIdExpression lhsIdExpression = (CIdExpression)lhs;
                CSimpleDeclaration variableDeclaration = lhsIdExpression.getDeclaration();
                CExpression rhs = assignmentStatement.getRightHandSide();
                return Optional.of(new ExpressionAssign(variableDeclaration, rhs));
            }
            return Optional.empty();
        }

        private CExpression getExpression() {
            return this.expression;
        }

        public int hashCode() {
            return Objects.hash(this.getDeclaration(), this.expression);
        }

        public boolean equals(Object pObject) {
            if (this == pObject) {
                return true;
            }
            if (!(pObject instanceof ExpressionAssign)) {
                return false;
            }
            ExpressionAssign other = (ExpressionAssign)pObject;
            return Objects.equals(this.getDeclaration(), other.getDeclaration()) && Objects.equals(this.expression, other.expression);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("declaration", (Object)this.getDeclaration()).add("expression", (Object)this.expression).toString();
        }
    }
}

