/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.arrayabstraction;

import com.google.common.base.Preconditions;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Sets;
import java.math.BigInteger;
import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.ast.c.CDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CSimpleDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.FunctionSummaryEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CDeclarationEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionCallEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionEntryNode;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.cpa.value.ValueAnalysisState;
import org.sosy_lab.cpachecker.util.CFATraversal;
import org.sosy_lab.cpachecker.util.CFAUtils;
import org.sosy_lab.cpachecker.util.LoopStructure;
import org.sosy_lab.cpachecker.util.arrayabstraction.SpecialOperation;
import org.sosy_lab.cpachecker.util.dependencegraph.EdgeDefUseData;
import org.sosy_lab.cpachecker.util.graph.dominance.DomTree;
import org.sosy_lab.cpachecker.util.graph.dominance.DominanceUtils;
import org.sosy_lab.cpachecker.util.states.MemoryLocation;
import org.sosy_lab.cpachecker.util.variableclassification.VariableClassification;

final class TransformableLoop {
    private final LoopStructure.Loop loop;
    private final CFANode loopNode;
    private final Index index;

    private TransformableLoop(LoopStructure.Loop pLoop, CFANode pLoopNode, Index pIndex) {
        this.loop = pLoop;
        this.loopNode = pLoopNode;
        this.index = pIndex;
    }

    private static int compareCfaEdges(CFAEdge fstEdge, CFAEdge sndEdge) {
        return ComparisonChain.start().compare((Comparable)fstEdge.getPredecessor(), (Comparable)sndEdge.getPredecessor()).compare((Comparable)fstEdge.getSuccessor(), (Comparable)sndEdge.getSuccessor()).result();
    }

    private static ImmutableSet<CFAEdge> allInnerLoopEdges(LoopStructure.Loop pLoop) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        ImmutableSortedSet innerLoopEdges = ImmutableSortedSet.copyOf(TransformableLoop::compareCfaEdges, pLoop.getInnerLoopEdges());
        builder.addAll((Iterable)innerLoopEdges);
        for (CFANode node : pLoop.getLoopNodes()) {
            FunctionSummaryEdge summaryEdge = node.getLeavingSummaryEdge();
            if (summaryEdge == null) continue;
            builder.add((Object)summaryEdge);
        }
        return builder.build();
    }

    private static ImmutableSet<CFAEdge> getDominatedInnerLoopEdges(CFAEdge pEdge, LoopStructure.Loop pLoop, CFANode pLoopStart) {
        Preconditions.checkArgument((boolean)pLoop.getLoopNodes().contains((Object)pLoopStart));
        Preconditions.checkArgument((boolean)TransformableLoop.allInnerLoopEdges(pLoop).contains((Object)pEdge));
        ImmutableSet.Builder builder = ImmutableSet.builder();
        CFANode startNode = pEdge.getSuccessor();
        DomTree<CFANode> domTree = DominanceUtils.createFunctionDomTree(startNode, (ImmutableSet<CFANode>)ImmutableSet.of((Object)pLoopStart));
        for (CFANode node : domTree) {
            if (!node.equals(startNode) && !domTree.isAncestorOf(startNode, node)) continue;
            builder.addAll(CFAUtils.allLeavingEdges(node));
        }
        return builder.build();
    }

    private static ImmutableSet<CFAEdge> getPostDominatedInnerLoopEdges(CFAEdge pEdge, LoopStructure.Loop pLoop, CFANode pLoopStart) {
        Preconditions.checkArgument((boolean)pLoop.getLoopNodes().contains((Object)pLoopStart));
        Preconditions.checkArgument((boolean)TransformableLoop.allInnerLoopEdges(pLoop).contains((Object)pEdge));
        ImmutableSet.Builder builder = ImmutableSet.builder();
        CFANode startNode = pEdge.getPredecessor();
        DomTree<CFANode> postDomTree = DominanceUtils.createFunctionPostDomTree(startNode, (ImmutableSet<CFANode>)ImmutableSet.of((Object)pLoopStart));
        for (CFANode node : postDomTree) {
            if (!node.equals(startNode) && !postDomTree.isAncestorOf(startNode, node)) continue;
            builder.addAll(CFAUtils.allEnteringEdges(node));
        }
        return builder.build();
    }

    private static boolean isExecutedEveryIteration(CFAEdge pEdge, LoopStructure.Loop pLoop, CFANode pLoopNode) {
        HashSet<CFAEdge> dominatedEdges = new HashSet<CFAEdge>();
        dominatedEdges.add(pEdge);
        dominatedEdges.addAll((Collection<CFAEdge>)TransformableLoop.getDominatedInnerLoopEdges(pEdge, pLoop, pLoopNode));
        dominatedEdges.addAll((Collection<CFAEdge>)TransformableLoop.getPostDominatedInnerLoopEdges(pEdge, pLoop, pLoopNode));
        return Sets.difference(TransformableLoop.allInnerLoopEdges(pLoop), dominatedEdges).isEmpty();
    }

    private static ImmutableSet<CFAEdge> getIncomingDefs(CFAEdge pIncomingEdge, CSimpleDeclaration pVariableDeclaration) {
        CFAEdge incomingEdge;
        final ImmutableSet.Builder builder = ImmutableSet.builder();
        final MemoryLocation memoryLocation = MemoryLocation.forDeclaration(pVariableDeclaration);
        final EdgeDefUseData.Extractor extractor = EdgeDefUseData.createExtractor(false);
        if (extractor.extract(incomingEdge = pIncomingEdge).getDefs().contains((Object)memoryLocation)) {
            builder.add((Object)incomingEdge);
            return builder.build();
        }
        CFATraversal.dfs().backwards().traverseOnce(incomingEdge.getPredecessor(), new CFATraversal.CFAVisitor(){

            @Override
            public CFATraversal.TraversalProcess visitEdge(CFAEdge pEdge) {
                if (extractor.extract(pEdge).getDefs().contains((Object)memoryLocation)) {
                    builder.add((Object)pEdge);
                    return CFATraversal.TraversalProcess.SKIP;
                }
                return CFATraversal.TraversalProcess.CONTINUE;
            }

            @Override
            public CFATraversal.TraversalProcess visitNode(CFANode pNode) {
                return CFATraversal.TraversalProcess.CONTINUE;
            }
        });
        return builder.build();
    }

    private static ImmutableSet<CFAEdge> getOutgoingUses(CFAEdge pOutgoingEdge, CSimpleDeclaration pVariableDeclaration) {
        final ImmutableSet.Builder builder = ImmutableSet.builder();
        final MemoryLocation memoryLocation = MemoryLocation.forDeclaration(pVariableDeclaration);
        final EdgeDefUseData.Extractor extractor = EdgeDefUseData.createExtractor(false);
        CFAEdge outgoingEdge = pOutgoingEdge;
        CFATraversal.dfs().traverseOnce(outgoingEdge.getSuccessor(), new CFATraversal.CFAVisitor(){

            @Override
            public CFATraversal.TraversalProcess visitEdge(CFAEdge pEdge) {
                EdgeDefUseData edgeDefUseData = extractor.extract(pEdge);
                if (edgeDefUseData.getUses().contains((Object)memoryLocation)) {
                    builder.add((Object)pEdge);
                }
                if (edgeDefUseData.getDefs().contains((Object)memoryLocation)) {
                    return CFATraversal.TraversalProcess.SKIP;
                }
                return CFATraversal.TraversalProcess.CONTINUE;
            }

            @Override
            public CFATraversal.TraversalProcess visitNode(CFANode pNode) {
                return CFATraversal.TraversalProcess.CONTINUE;
            }
        });
        return builder.build();
    }

    private static int countInnerLoopDefs(LoopStructure.Loop pLoop, CSimpleDeclaration pDeclaration) {
        MemoryLocation memoryLocation = MemoryLocation.forDeclaration(pDeclaration);
        EdgeDefUseData.Extractor extractor = EdgeDefUseData.createExtractor(false);
        int count = 0;
        for (CFAEdge edge : TransformableLoop.allInnerLoopEdges(pLoop)) {
            if (!extractor.extract(edge).getDefs().contains((Object)memoryLocation)) continue;
            ++count;
        }
        return count;
    }

    private static boolean isAddressed(CFA pCfa, CSimpleDeclaration pVariableDeclaration) {
        VariableClassification variableClassification = pCfa.getVarClassification().orElseThrow();
        return variableClassification.getAddressedVariables().contains(pVariableDeclaration.getQualifiedName());
    }

    private static Optional<TransformableLoop> forLoop(CFA pCfa, LogManager pLogger, LoopStructure.Loop pLoop) {
        ImmutableSet<CFAEdge> incomingDefs;
        if (pLoop.getIncomingEdges().size() != 1 || pLoop.getOutgoingEdges().size() != 1) {
            return Optional.empty();
        }
        CFAEdge incomingEdge = (CFAEdge)pLoop.getIncomingEdges().stream().findAny().orElseThrow();
        CFAEdge outgoingEdge = (CFAEdge)pLoop.getOutgoingEdges().stream().findAny().orElseThrow();
        if (!incomingEdge.getSuccessor().equals(outgoingEdge.getPredecessor())) {
            return Optional.empty();
        }
        CFANode loopNode = incomingEdge.getSuccessor();
        for (CFANode node : pLoop.getLoopNodes()) {
            if (node.equals(loopNode) || !node.isLoopStart()) continue;
            return Optional.empty();
        }
        MachineModel machineModel = pCfa.getMachineModel();
        ValueAnalysisState emptyValueAnalysisState = new ValueAnalysisState(machineModel);
        String functionName = loopNode.getFunctionName();
        Optional<SpecialOperation.ConstantComparison> optLoopCondition = SpecialOperation.ConstantComparison.forEdge(outgoingEdge, functionName, machineModel, pLogger, emptyValueAnalysisState);
        if (optLoopCondition.isEmpty()) {
            return Optional.empty();
        }
        SpecialOperation.ConstantComparison loopCondition = optLoopCondition.orElseThrow();
        CSimpleDeclaration indexVariableDeclaration = loopCondition.getDeclaration();
        MemoryLocation indexMemoryLocation = MemoryLocation.forDeclaration(indexVariableDeclaration);
        if (TransformableLoop.isAddressed(pCfa, indexVariableDeclaration)) {
            return Optional.empty();
        }
        CFAEdge updateIndexEdge = null;
        SpecialOperation.UpdateAssign updateIndexOperation = null;
        EdgeDefUseData.Extractor defUseExtractor = EdgeDefUseData.createExtractor(false);
        ImmutableSet<CFAEdge> innerLoopEdges = TransformableLoop.allInnerLoopEdges(pLoop);
        for (CFAEdge innerLoopEdge : innerLoopEdges) {
            ImmutableSet<MemoryLocation> edgeDefs;
            Optional<SpecialOperation.UpdateAssign> optUpdateAssign = SpecialOperation.UpdateAssign.forEdge(innerLoopEdge, functionName, machineModel, pLogger, emptyValueAnalysisState);
            if (optUpdateAssign.isPresent()) {
                SpecialOperation.UpdateAssign updateAssign = optUpdateAssign.orElseThrow();
                if (updateIndexEdge == null && updateAssign.getDeclaration().equals(indexVariableDeclaration)) {
                    if (!TransformableLoop.isExecutedEveryIteration(innerLoopEdge, pLoop, loopNode)) {
                        return Optional.empty();
                    }
                    updateIndexEdge = innerLoopEdge;
                    updateIndexOperation = updateAssign;
                    continue;
                }
            }
            if (!(edgeDefs = defUseExtractor.extract(innerLoopEdge).getDefs()).contains((Object)indexMemoryLocation)) continue;
            return Optional.empty();
        }
        if (updateIndexEdge == null) {
            return Optional.empty();
        }
        assert (updateIndexOperation != null);
        if (updateIndexOperation.getStepValue().compareTo(BigInteger.ZERO) > 0) {
            if (loopCondition.getOperator() != SpecialOperation.ConstantComparison.Operator.LESS_EQUAL) {
                return Optional.empty();
            }
        } else if (updateIndexOperation.getStepValue().compareTo(BigInteger.ZERO) < 0) {
            if (loopCondition.getOperator() != SpecialOperation.ConstantComparison.Operator.GREATER_EQUAL) {
                return Optional.empty();
            }
        } else {
            return Optional.empty();
        }
        if ((incomingDefs = TransformableLoop.getIncomingDefs(incomingEdge, indexVariableDeclaration)).size() != 1) {
            return Optional.empty();
        }
        CFAEdge incomingIndexDefEdge = (CFAEdge)incomingDefs.stream().findAny().orElseThrow();
        Optional<SpecialOperation.ConstantAssign> optIncomingIndexAssign = SpecialOperation.ConstantAssign.forEdge(incomingIndexDefEdge, functionName, machineModel, pLogger, emptyValueAnalysisState);
        if (optIncomingIndexAssign.isEmpty()) {
            return Optional.empty();
        }
        SpecialOperation.ConstantAssign incomingIndexAssign = optIncomingIndexAssign.orElseThrow();
        Index index = new Index(incomingIndexDefEdge, incomingIndexAssign, updateIndexEdge, updateIndexOperation, loopCondition);
        return Optional.of(new TransformableLoop(pLoop, loopNode, index));
    }

    public static ImmutableSet<TransformableLoop> findTransformableLoops(CFA pCfa, LogManager pLogger) {
        ImmutableSet.Builder transformableLoops = ImmutableSet.builder();
        LoopStructure loopStructure = pCfa.getLoopStructure().orElseThrow();
        for (LoopStructure.Loop loop : loopStructure.getAllLoops()) {
            Optional<TransformableLoop> optTransformableLoop = TransformableLoop.forLoop(pCfa, pLogger, loop);
            if (!optTransformableLoop.isPresent()) continue;
            transformableLoops.add((Object)optTransformableLoop.orElseThrow());
        }
        return transformableLoops.build();
    }

    public CFANode getLoopNode() {
        return this.loopNode;
    }

    public Index getIndex() {
        return this.index;
    }

    public ImmutableSet<CFAEdge> getInnerLoopEdges() {
        return TransformableLoop.allInnerLoopEdges(this.loop);
    }

    public CFAEdge getIncomingEdge() {
        return (CFAEdge)this.loop.getIncomingEdges().stream().findAny().orElseThrow();
    }

    public CFAEdge getOutgoingEdge() {
        return (CFAEdge)this.loop.getOutgoingEdges().stream().findAny().orElseThrow();
    }

    public ImmutableSet<CFAEdge> getDominatedInnerLoopEdges(CFAEdge pEdge) {
        return TransformableLoop.getDominatedInnerLoopEdges(pEdge, this.loop, this.loopNode);
    }

    public ImmutableSet<CFAEdge> getPostDominatedInnerLoopEdges(CFAEdge pEdge) {
        return TransformableLoop.getPostDominatedInnerLoopEdges(pEdge, this.loop, this.loopNode);
    }

    public boolean isExecutedEveryIteration(CFAEdge pEdge) {
        return TransformableLoop.isExecutedEveryIteration(pEdge, this.loop, this.loopNode);
    }

    public boolean hasOutgoingUses(CSimpleDeclaration pDeclaration) {
        return !TransformableLoop.getOutgoingUses(this.getOutgoingEdge(), pDeclaration).isEmpty();
    }

    public int countInnerLoopDefs(CSimpleDeclaration pDeclaration) {
        return TransformableLoop.countInnerLoopDefs(this.loop, pDeclaration);
    }

    public ImmutableSet<CSimpleDeclaration> getInnerLoopDeclarations() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (CFAEdge innerLoopEdge : this.getInnerLoopEdges()) {
            if (innerLoopEdge instanceof CDeclarationEdge) {
                CDeclaration declaration = ((CDeclarationEdge)innerLoopEdge).getDeclaration();
                if (!(declaration instanceof CVariableDeclaration)) continue;
                builder.add((Object)declaration);
                continue;
            }
            if (!(innerLoopEdge instanceof CFunctionCallEdge)) continue;
            CFunctionEntryNode functionEntryNode = ((CFunctionCallEdge)innerLoopEdge).getSuccessor();
            builder.addAll(functionEntryNode.getFunctionDefinition().getParameters());
        }
        return builder.build();
    }

    public ImmutableSet<CFAEdge> getIncomingDefs(CSimpleDeclaration pVariableDeclaration) {
        return TransformableLoop.getIncomingDefs(this.getIncomingEdge(), pVariableDeclaration);
    }

    public static final class Index {
        private final CFAEdge initializeEdge;
        private final SpecialOperation.ConstantAssign initializeOperation;
        private final CFAEdge updateEdge;
        private final SpecialOperation.UpdateAssign updateOperation;
        private final SpecialOperation.ConstantComparison comparisonOperation;

        private Index(CFAEdge pInitializeEdge, SpecialOperation.ConstantAssign pInitializeOperation, CFAEdge pUpdateEdge, SpecialOperation.UpdateAssign pUpdateOperation, SpecialOperation.ConstantComparison pComparisonOperation) {
            this.initializeEdge = (CFAEdge)Preconditions.checkNotNull((Object)pInitializeEdge);
            this.initializeOperation = (SpecialOperation.ConstantAssign)Preconditions.checkNotNull((Object)pInitializeOperation);
            this.updateEdge = (CFAEdge)Preconditions.checkNotNull((Object)pUpdateEdge);
            this.updateOperation = (SpecialOperation.UpdateAssign)Preconditions.checkNotNull((Object)pUpdateOperation);
            this.comparisonOperation = (SpecialOperation.ConstantComparison)Preconditions.checkNotNull((Object)pComparisonOperation);
        }

        public CSimpleDeclaration getVariableDeclaration() {
            return this.initializeOperation.getDeclaration();
        }

        public CFAEdge getInitializeEdge() {
            return this.initializeEdge;
        }

        public SpecialOperation.ConstantAssign getInitializeOperation() {
            return this.initializeOperation;
        }

        public CFAEdge getUpdateEdge() {
            return this.updateEdge;
        }

        public SpecialOperation.UpdateAssign getUpdateOperation() {
            return this.updateOperation;
        }

        public boolean isIncreasing() {
            return this.updateOperation.getStepValue().compareTo(BigInteger.ZERO) > 0;
        }

        public boolean isDecreasing() {
            return this.updateOperation.getStepValue().compareTo(BigInteger.ZERO) < 0;
        }

        public SpecialOperation.ConstantComparison getComparisonOperation() {
            return this.comparisonOperation;
        }
    }
}

